/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class ByteConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Byte";
    public static final String BYTE_ID = "javax.faces.converter.ByteConverter.BYTE";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() < 1) {
            return null;
        }
        try {
            return Byte.valueOf(value2);
        }
        catch (NumberFormatException nfe) {
            throw new ConverterException(MessageFactory.getMessage(context, BYTE_ID, value2, "254", MessageFactory.getLabel(context, component)));
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return "";
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        try {
            return Byte.toString((Byte)value2);
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

