/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.security.PrivilegedAction;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

class ValueExpressionValueBindingAdapter
extends ValueExpression
implements Serializable,
StateHolder {
    private static final long serialVersionUID = 2388977392466671243L;
    private static boolean securityManager = System.getSecurityManager() != null;
    private ValueBinding binding = null;
    private boolean tranzient = false;

    public ValueExpressionValueBindingAdapter() {
    }

    ValueExpressionValueBindingAdapter(ValueBinding binding) {
        assert (null != binding);
        this.binding = binding;
    }

    @Override
    public Object getValue(ELContext context) throws ELException {
        assert (null != this.binding);
        if (context == null) {
            throw new NullPointerException("ELContext -> null");
        }
        Object result = null;
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        assert (null != facesContext);
        try {
            result = this.binding.getValue(facesContext);
        }
        catch (Throwable e) {
            throw new ELException(e);
        }
        return result;
    }

    @Override
    public void setValue(ELContext context, Object value2) throws ELException {
        assert (null != this.binding);
        if (context == null) {
            throw new NullPointerException("ELContext -> null");
        }
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        assert (null != facesContext);
        try {
            this.binding.setValue(facesContext, value2);
        }
        catch (Throwable e) {
            throw new ELException(e);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context) throws ELException {
        assert (null != this.binding);
        if (context == null) {
            throw new NullPointerException("ELContext -> null");
        }
        boolean result = false;
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        assert (null != facesContext);
        try {
            result = this.binding.isReadOnly(facesContext);
        }
        catch (Throwable e) {
            throw new ELException(e);
        }
        return result;
    }

    @Override
    public Class<?> getType(ELContext context) throws ELException {
        assert (null != this.binding);
        if (context == null) {
            throw new NullPointerException("ELContext -> null");
        }
        Class result = null;
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        assert (null != facesContext);
        try {
            result = this.binding.getType(facesContext);
        }
        catch (Throwable e) {
            throw new ELException(e);
        }
        return result;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public Class<?> getExpectedType() {
        assert (null != this.binding);
        Class<?> result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            Object value2 = this.binding.getValue(context);
            result = value2.getClass();
        }
        catch (Throwable e) {
            result = null;
        }
        return result;
    }

    @Override
    public String getExpressionString() {
        assert (null != this.binding);
        return this.binding.getExpressionString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ValueExpressionValueBindingAdapter) {
            ValueBinding vb = ((ValueExpressionValueBindingAdapter)other).getWrapped();
            return this.binding.equals(vb);
        }
        if (other instanceof ValueExpression) {
            FacesContext context = FacesContext.getCurrentInstance();
            ValueExpression otherVE = (ValueExpression)other;
            Class type = this.binding.getType(context);
            if (type != null) {
                return type.equals(otherVE.getType(context.getELContext()));
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (null != this.binding);
        return this.binding.hashCode();
    }

    public String getDelimiterSyntax() {
        return "";
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] result = null;
        if (!this.tranzient) {
            if (this.binding instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)((Object)this.binding)).saveState(context), this.binding.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.binding;
            }
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (null == state) {
            return;
        }
        if (!(state instanceof ValueBinding)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            ValueBinding result = null;
            Class toRestoreClass = null;
            if (null != className) {
                try {
                    toRestoreClass = ValueExpressionValueBindingAdapter.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (null != toRestoreClass) {
                    try {
                        result = (ValueBinding)toRestoreClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (IllegalAccessException a) {
                        throw new IllegalStateException(a.getMessage());
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)((Object)result)).restoreState(context, savedState);
                }
                this.binding = result;
            }
        } else {
            this.binding = (ValueBinding)state;
        }
    }

    @Override
    public boolean isTransient() {
        return this.tranzient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.tranzient = newTransientValue;
    }

    private static Class loadClass(String name2, final Object fallbackClass) throws ClassNotFoundException {
        if (securityManager) {
            Object cl = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fallbackClass.getClass().getClassLoader();
                    }
                });
            }
            return Class.forName(name2, false, (ClassLoader)cl);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name2, false, loader);
    }

    public ValueBinding getWrapped() {
        return this.binding;
    }
}

