/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;

class MethodExpressionMethodBindingAdapter
extends MethodExpression
implements Serializable,
StateHolder {
    private static final long serialVersionUID = -1822420567946048452L;
    private static boolean securityManager = System.getSecurityManager() != null;
    private MethodBinding binding = null;
    private transient MethodInfo info = null;
    private boolean tranzient = false;

    public MethodExpressionMethodBindingAdapter() {
    }

    MethodExpressionMethodBindingAdapter(MethodBinding binding) {
        assert (null != binding);
        this.binding = binding;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext context) throws ELException {
        FacesContext facesContext;
        assert (null != this.binding);
        if (context == null) {
            throw new NullPointerException("ELContext -> null");
        }
        if (null == this.info && null != (facesContext = (FacesContext)context.getContext(FacesContext.class))) {
            try {
                this.info = new MethodInfo(null, this.binding.getType(facesContext), null);
            }
            catch (Exception e) {
                throw new ELException(e);
            }
        }
        return this.info;
    }

    @Override
    public Object invoke(ELContext context, Object[] params) throws ELException {
        assert (null != this.binding);
        if (context == null) {
            throw new NullPointerException("ELContext -> null");
        }
        Object result = null;
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        if (null != facesContext) {
            try {
                result = this.binding.invoke(facesContext, params);
            }
            catch (Exception e) {
                throw new ELException(e);
            }
        }
        return result;
    }

    @Override
    public String getExpressionString() {
        assert (null != this.binding);
        return this.binding.getExpressionString();
    }

    @Override
    public boolean isLiteralText() {
        assert (this.binding != null);
        String expr = this.binding.getExpressionString();
        return !expr.startsWith("#{") || !expr.endsWith("}");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MethodExpressionMethodBindingAdapter) {
            MethodBinding ob = ((MethodExpressionMethodBindingAdapter)other).getWrapped();
            return this.binding.equals(ob);
        }
        if (other instanceof MethodExpression) {
            Method[] methods;
            MethodExpression expression = (MethodExpression)other;
            String expr = this.binding.getExpressionString();
            int idx = expr.indexOf(46);
            String target = expr.substring(0, idx).substring(2);
            String t = expr.substring(idx + 1);
            String method = t.substring(0, t.length() - 1);
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            MethodInfo controlInfo = expression.getMethodInfo(elContext);
            if (!controlInfo.getName().equals(method)) {
                return false;
            }
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            ValueExpression ve = factory.createValueExpression(elContext, "#{" + target + '}', Object.class);
            if (ve == null) {
                return false;
            }
            Object result = ve.getValue(elContext);
            if (result == null) {
                return false;
            }
            for (Method meth : methods = result.getClass().getMethods()) {
                if (!meth.getName().equals(method) || !meth.getReturnType().equals(controlInfo.getReturnType()) || !Arrays.equals(meth.getParameterTypes(), controlInfo.getParamTypes())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (null != this.binding);
        return this.binding.hashCode();
    }

    public String getDelimiterSyntax() {
        return "";
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] result = null;
        if (!this.tranzient) {
            if (this.binding instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)((Object)this.binding)).saveState(context), this.binding.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.binding;
            }
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodBinding)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodBinding result = null;
            Class toRestoreClass = null;
            if (null != className) {
                try {
                    toRestoreClass = MethodExpressionMethodBindingAdapter.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodBinding)toRestoreClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (IllegalAccessException a) {
                        throw new IllegalStateException(a.getMessage());
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)((Object)result)).restoreState(context, savedState);
                }
                this.binding = result;
            }
        } else {
            this.binding = (MethodBinding)state;
        }
    }

    @Override
    public boolean isTransient() {
        return this.tranzient;
    }

    @Override
    public void setTransient(boolean newTransientMethod) {
        this.tranzient = newTransientMethod;
    }

    private static Class loadClass(String name2, final Object fallbackClass) throws ClassNotFoundException {
        if (securityManager) {
            Object cl = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fallbackClass.getClass().getClassLoader();
                    }
                });
            }
            return Class.forName(name2, false, (ClassLoader)cl);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name2, false, loader);
    }

    public MethodBinding getWrapped() {
        return this.binding;
    }
}

