/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.Symbol;
import com.ibm.xml.xlxp2.scan.util.SymbolMap;
import com.ibm.xml.xlxp2.scan.util.SymbolMapHolder;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SymbolTable {
    private static final boolean TRACE_PUBLIC_METHODS = false;
    private final SymbolMapHolder fSymbolMapHolder;
    private SymbolMap fMap;

    public SymbolTable() {
        this.fSymbolMapHolder = null;
        this.fMap = new SymbolMap();
    }

    public SymbolTable(SymbolMapHolder symbolMapHolder) {
        this.fSymbolMapHolder = symbolMapHolder;
        this.fMap = this.fSymbolMapHolder.createMap();
    }

    public void updateSymbolMapHolder() {
        if (this.fSymbolMapHolder != null) {
            this.fMap = this.fSymbolMapHolder.updateMap(this.fMap);
        }
    }

    public void reset(boolean bl) {
        this.fMap.reset(bl, this.fSymbolMapHolder);
    }

    public String addSymbol(XMLString xMLString) {
        return this.fMap.addSymbol(xMLString);
    }

    public String addSymbol(String string) {
        return this.fMap.addSymbol(string);
    }

    public String addSymbolSetValues(XMLString xMLString, XMLString xMLString2) {
        return this.fMap.addSymbolSetValues(xMLString, xMLString2);
    }

    public String addSymbolSetValues(String string, XMLString xMLString) {
        return this.fMap.addSymbolSetValues(string, xMLString);
    }

    public Symbol addNameSymbol(QName qName) {
        Symbol symbol = this.fMap.addNameSymbol(qName);
        return symbol;
    }

    public Symbol getQNameSymbol(QName qName, int n, int n2) {
        Symbol symbol = this.fMap.getQNameSymbol(qName, n, n2);
        return symbol;
    }

    public Symbol putQNameSymbol(QName qName, int n, int n2) {
        Symbol symbol = this.fMap.putQNameSymbol(qName, n, n2);
        return symbol;
    }

    public Symbol getQNameSymbol(QName qName) {
        Symbol symbol = this.fMap.getQNameSymbol(qName);
        return symbol;
    }
}

