/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.SymbolMap;
import java.security.AccessController;
import java.security.PrivilegedAction;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SymbolMapHolder {
    private static final boolean TRACE_SYMBOL_MAP_SHARING = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("trace.symbol.map.sharing");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private SymbolMap sharedMap = null;

    public void rebalanceMap(SymbolMap symbolMap) {
        if (symbolMap.parent == this.sharedMap) {
            if (TRACE_SYMBOL_MAP_SHARING) {
                System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** Rebalancing SymbolMap " + symbolMap.id);
            }
            symbolMap.rebalanceTables();
        } else if (TRACE_SYMBOL_MAP_SHARING) {
            System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** SymbolMap " + symbolMap.id + " not rebalanced");
        }
    }

    public SymbolMap updateMap(SymbolMap symbolMap) {
        if (symbolMap.parent == null) {
            if (TRACE_SYMBOL_MAP_SHARING) {
                System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** Assigning new shared SymbolMap " + symbolMap.id + " (was " + (this.sharedMap != null ? Integer.valueOf(this.sharedMap.id) : "null") + ")");
            }
            this.sharedMap = symbolMap.prepareForSharing();
        }
        if (symbolMap.parent != this.sharedMap) {
            SymbolMap symbolMap2 = this.sharedMap.clone();
            if (TRACE_SYMBOL_MAP_SHARING) {
                System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** New cloned SymbolMap " + symbolMap2.id + " replacing " + symbolMap.id + " (parent now " + this.sharedMap.id + ", was " + (symbolMap.parent != null ? Integer.valueOf(symbolMap.parent.id) : "null") + ")");
            }
            return symbolMap2;
        }
        return symbolMap;
    }

    public SymbolMap createMap() {
        SymbolMap symbolMap;
        if (this.sharedMap != null) {
            symbolMap = this.sharedMap.clone();
            if (TRACE_SYMBOL_MAP_SHARING) {
                System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** Creating new cloned SymbolMap " + symbolMap.id + " of shared SymbolMap " + this.sharedMap.id);
            }
        } else {
            symbolMap = new SymbolMap();
            if (TRACE_SYMBOL_MAP_SHARING) {
                System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** Creating non-shared SymbolMap " + symbolMap.id);
            }
        }
        return symbolMap;
    }
}

