/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SimpleDataBufferFactory
implements DataBufferFactory {
    private static final boolean DEBUG = false;
    private DataBufferLink fFreeBuffers;
    private DataBufferReferrerQueue fReferrers;
    private DataBufferActiveQueue fActiveBuffers = new DataBufferActiveQueue();
    private int activeCount;
    private static int fgIdCounter;

    public SimpleDataBufferFactory() {
        this.fReferrers = new DataBufferReferrerQueue(this.fActiveBuffers);
    }

    public DataBuffer createBuffer() {
        DataBuffer dataBuffer;
        DataBufferLink dataBufferLink = this.fFreeBuffers;
        if (dataBufferLink != null) {
            this.fFreeBuffers = dataBufferLink.next;
            dataBufferLink.next = null;
            dataBuffer = dataBufferLink.db;
            dataBuffer.columnNumber = 1;
            dataBuffer.lineNumber = 1;
            dataBuffer.byteOffset = -1;
            dataBuffer.startPosIncrement = 0;
        } else {
            dataBuffer = new DataBuffer(this);
            dataBuffer.id = ++fgIdCounter;
            dataBufferLink = new DataBufferLink(dataBuffer);
        }
        this.fActiveBuffers.add(dataBufferLink);
        ++this.activeCount;
        return dataBuffer;
    }

    public void addReferrer(DataBufferReferrer dataBufferReferrer) {
        this.fReferrers.add(dataBufferReferrer);
    }

    public void removeReferrer(DataBufferReferrer dataBufferReferrer) {
        this.fReferrers.remove(dataBufferReferrer);
    }

    public boolean isReferenced(DataBuffer dataBuffer) {
        return this.fReferrers.isReferenced(dataBuffer);
    }

    public void reset(boolean bl) {
        this.reclaimBuffers(0);
        if (!bl) {
            this.fFreeBuffers = null;
        }
    }

    public void reclaimBuffers(int n) {
        if (this.activeCount < n) {
            return;
        }
        DataBufferLink dataBufferLink = this.fActiveBuffers.first();
        while (dataBufferLink != null) {
            if (!this.fReferrers.isReferenced(dataBufferLink.db)) {
                if (dataBufferLink.prev.db.next == dataBufferLink.db) {
                    dataBufferLink.prev.db.next = null;
                }
                DataBufferLink dataBufferLink2 = this.fActiveBuffers.remove(dataBufferLink);
                --this.activeCount;
                dataBufferLink.db.next = null;
                dataBufferLink.next = this.fFreeBuffers;
                this.fFreeBuffers = dataBufferLink;
                dataBufferLink = dataBufferLink2;
                continue;
            }
            dataBufferLink = this.fActiveBuffers.next(dataBufferLink);
        }
    }

    static final class DataBufferActiveQueue {
        DataBufferLink head;

        DataBufferActiveQueue() {
            this.head.prev = this.head.next = (this.head = new DataBufferLink(NullDataBufferFactory.createNewBuffer()));
        }

        void add(DataBufferLink dataBufferLink) {
            DataBufferLink dataBufferLink2 = this.head.prev;
            dataBufferLink.next = dataBufferLink2.next;
            dataBufferLink.prev = dataBufferLink2;
            dataBufferLink2.next = dataBufferLink;
            this.head.prev = dataBufferLink;
        }

        DataBufferLink remove(DataBufferLink dataBufferLink) {
            DataBufferLink dataBufferLink2;
            dataBufferLink.prev.next = dataBufferLink2 = dataBufferLink.next;
            dataBufferLink2.prev = dataBufferLink.prev;
            dataBufferLink.next = null;
            dataBufferLink.prev = null;
            return dataBufferLink2 != this.head ? dataBufferLink2 : null;
        }

        DataBufferLink first() {
            return this.head.next != this.head ? this.head.next : null;
        }

        DataBufferLink next(DataBufferLink dataBufferLink) {
            return dataBufferLink.next != this.head ? dataBufferLink.next : null;
        }
    }

    static final class DataBufferLink {
        DataBufferLink next;
        DataBufferLink prev;
        final DataBuffer db;

        DataBufferLink(DataBuffer dataBuffer) {
            this.db = dataBuffer;
        }
    }

    static final class DataBufferReferrerQueue {
        DataBufferActiveQueue activeBuffers;
        DataBufferReferrer head;
        private StringBuilder sb;

        DataBufferReferrerQueue(DataBufferActiveQueue dataBufferActiveQueue) {
            this.activeBuffers = dataBufferActiveQueue;
            this.head.prev = this.head.next = (this.head = new DataBufferReferrer(){

                public boolean hasReferenceTo(DataBuffer dataBuffer) {
                    return false;
                }

                public void removeReferencesAndUnregister() {
                }
            });
        }

        boolean isReferenced(DataBuffer dataBuffer) {
            DataBufferReferrer dataBufferReferrer = this.head.next;
            boolean bl = false;
            while (dataBufferReferrer != this.head) {
                if (dataBufferReferrer.active && dataBufferReferrer.hasReferenceTo(dataBuffer)) {
                    ++dataBufferReferrer.hits;
                    if (dataBufferReferrer != this.head.next && dataBufferReferrer.hits > dataBufferReferrer.prev.hits) {
                        this.moveToFront(dataBufferReferrer);
                    }
                    return true;
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
            return false;
        }

        void moveToFront(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2;
            this.remove(dataBufferReferrer);
            dataBufferReferrer.next = dataBufferReferrer2 = this.head.next;
            dataBufferReferrer.prev = this.head;
            dataBufferReferrer2.prev = dataBufferReferrer;
            this.head.next = dataBufferReferrer;
        }

        void add(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2 = this.head.prev;
            dataBufferReferrer.next = this.head;
            dataBufferReferrer.prev = dataBufferReferrer2;
            dataBufferReferrer2.next = dataBufferReferrer;
            this.head.prev = dataBufferReferrer;
        }

        void remove(DataBufferReferrer dataBufferReferrer) {
            dataBufferReferrer.prev.next = dataBufferReferrer.next;
            dataBufferReferrer.next.prev = dataBufferReferrer.prev;
            dataBufferReferrer.next = null;
            dataBufferReferrer.prev = null;
        }

        public String toString() {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            } else {
                this.sb.setLength(0);
            }
            boolean bl = true;
            DataBufferReferrer dataBufferReferrer = this.head.next;
            while (dataBufferReferrer != this.head) {
                if (!dataBufferReferrer.active) {
                    if (bl) {
                        this.sb.append("dbr [");
                        bl = false;
                    } else {
                        this.sb.append(',');
                    }
                    this.sb.append(Integer.toString(dataBufferReferrer.id));
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
            if (!bl) {
                this.sb.append("] inactive\n");
            }
            dataBufferReferrer = this.head.next;
            while (dataBufferReferrer != this.head) {
                if (dataBufferReferrer.active) {
                    this.sb.append("dbr[");
                    this.sb.append(Integer.toString(dataBufferReferrer.id));
                    this.sb.append("] class ");
                    this.sb.append(dataBufferReferrer.getClass().getName());
                    bl = true;
                    DataBufferActiveQueue dataBufferActiveQueue = this.activeBuffers;
                    DataBufferLink dataBufferLink = dataBufferActiveQueue.first();
                    while (dataBufferLink != null) {
                        if (dataBufferReferrer.hasReferenceTo(dataBufferLink.db)) {
                            if (bl) {
                                this.sb.append(" buffers [");
                                bl = false;
                            } else {
                                this.sb.append(',');
                            }
                            this.sb.append(Integer.toString(dataBufferLink.db.id));
                            this.sb.append(':');
                            this.sb.append(Integer.toString(dataBufferLink.db.endOffset - dataBufferLink.db.startOffset));
                        }
                        dataBufferLink = dataBufferActiveQueue.next(dataBufferLink);
                    }
                    if (!bl) {
                        this.sb.append("]\n");
                    } else {
                        this.sb.append(" no buffers\n");
                    }
                    if (dataBufferReferrer.stackTrace != null) {
                        for (int i = 0; i < dataBufferReferrer.stackTrace.length; ++i) {
                            this.sb.append("    ");
                            this.sb.append(dataBufferReferrer.stackTrace[i].toString());
                            this.sb.append('\n');
                        }
                    }
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
            return this.sb.toString();
        }
    }
}

