/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.XBinary;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XSHexBinaryUtil {
    private static final byte[] hexCharNibbleMap = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final XBinary ZERO_LENGTH_HEX_BINARY = new XBinary(ArrayAllocator.newByteArray(0), 0);

    public static XBinary parseHexBinary(XMLString xMLString) {
        if (xMLString.length == 0) {
            return ZERO_LENGTH_HEX_BINARY;
        }
        if (xMLString.bytes != null) {
            return XSHexBinaryUtil.parseHexBinaryUnbuffered(xMLString);
        }
        return XSHexBinaryUtil.parseHexBinaryBuffered(xMLString);
    }

    private static XBinary parseHexBinaryUnbuffered(XMLString xMLString) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        byte[] byArray = xMLString.bytes;
        byte[] byArray2 = ArrayAllocator.newByteArray(xMLString.length >> 1);
        int n3 = 0;
        while (n < n2) {
            byte by;
            byte by2 = byArray[n];
            byte by3 = hexCharNibbleMap[by2 & 0xFF];
            if (by3 == -1) {
                if (by2 <= 32) {
                    boolean bl;
                    boolean bl2 = bl = xMLString.startOffset == n;
                    while ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n < n2) {
                        by2 = byArray[n];
                    }
                    if (n == n2) {
                        return !bl ? new XBinary(byArray2, n3) : ZERO_LENGTH_HEX_BINARY;
                    }
                    if (!bl || (by3 = hexCharNibbleMap[by2 & 0xFF]) == -1) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (++n == n2) {
                return null;
            }
            if ((by = hexCharNibbleMap[byArray[n++] & 0xFF]) == -1) {
                return null;
            }
            byArray2[n3++] = (byte)(by3 << 4 | by);
        }
        return new XBinary(byArray2, n3);
    }

    private static XBinary parseHexBinaryBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        byte[] byArray = ArrayAllocator.newByteArray(xMLString.length >> 1);
        int n2 = 0;
        while (true) {
            int n3;
            int n4 = n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            while (n < n3) {
                byte by;
                byte by2 = dataBuffer.bytes[n];
                byte by3 = hexCharNibbleMap[by2 & 0xFF];
                if (by3 == -1) {
                    if (by2 <= 32) {
                        boolean bl;
                        boolean bl2 = bl = xMLString.startOffset == n;
                        while (true) {
                            if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n < n3) {
                                by2 = dataBuffer.bytes[n];
                                continue;
                            }
                            if (n != n3 || dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            n = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by2 = dataBuffer.bytes[n];
                        }
                        if (n == n3) {
                            return !bl ? new XBinary(byArray, n2) : ZERO_LENGTH_HEX_BINARY;
                        }
                        if (!bl || (by3 = hexCharNibbleMap[by2 & 0xFF]) == -1) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                if (++n == n3) {
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    int n5 = n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                if ((by = hexCharNibbleMap[dataBuffer.bytes[n++] & 0xFF]) == -1) {
                    return null;
                }
                byArray[n2++] = (byte)(by3 << 4 | by);
            }
            if (dataBuffer == dataBuffer2) {
                return new XBinary(byArray, n2);
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
        }
    }

    public static int parseHexBinaryBuffered(ParsedEntity parsedEntity, XBinary xBinary, boolean[] blArray) {
        int n;
        int n2;
        block21: {
            byte by;
            byte[] byArray;
            block18: {
                n2 = parsedEntity.offset;
                n = parsedEntity.endOffset;
                byArray = parsedEntity.bytes;
                xBinary.length = 0;
                if (xBinary.value == null || xBinary.value.length >= 4096) {
                    xBinary.value = ArrayAllocator.newByteArray(256);
                }
                if (byArray[n2] > 32) break block18;
                while (true) {
                    block19: {
                        block20: {
                            if (n2 >= n) break block19;
                            by = byArray[n2];
                            if (by == 32) break block20;
                            if (by != 10 && by != 9 && by != 13) break block19;
                            blArray[0] = false;
                        }
                        ++n2;
                        continue;
                    }
                    if (n2 != n || parsedEntity.loadMore() == 0) break;
                    byArray = parsedEntity.bytes;
                    n2 = parsedEntity.offset;
                    n = parsedEntity.endOffset;
                }
            }
            if (n2 == n) {
                return -1;
            }
            while (true) {
                if (n2 < n) {
                    byte by2;
                    by = byArray[n2];
                    byte by3 = hexCharNibbleMap[by & 0xFF];
                    if (by3 == -1) break;
                    if (++n2 >= n) {
                        if (parsedEntity.loadMore() == 0) {
                            parsedEntity.resetToMark();
                            return -1;
                        }
                        byArray = parsedEntity.bytes;
                        n2 = parsedEntity.offset;
                        n = parsedEntity.endOffset;
                    }
                    if ((by2 = hexCharNibbleMap[byArray[n2++] & 0xFF]) == -1) {
                        return -1;
                    }
                    if (xBinary.length >= xBinary.value.length) {
                        xBinary.value = ArrayAllocator.resizeByteArray(xBinary.value, xBinary.value.length * 2);
                    }
                    xBinary.value[xBinary.length++] = (byte)(by3 << 4 | by2);
                    continue;
                }
                if (parsedEntity.loadMore() == 0) {
                    return -1;
                }
                byArray = parsedEntity.bytes;
                n2 = parsedEntity.offset;
                n = parsedEntity.endOffset;
            }
            if (by > 32) break block21;
            while (true) {
                block22: {
                    block23: {
                        if (n2 >= n) break block22;
                        by = byArray[n2];
                        if (by == 32) break block23;
                        if (by != 10 && by != 9 && by != 13) break block22;
                        blArray[0] = false;
                    }
                    ++n2;
                    continue;
                }
                if (n2 != n || parsedEntity.loadMore() == 0) break;
                byArray = parsedEntity.bytes;
                n2 = parsedEntity.offset;
                n = parsedEntity.endOffset;
            }
        }
        if (n2 == n) {
            return -1;
        }
        return n2;
    }

    private XSHexBinaryUtil() {
    }
}

