/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeUtil;
import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.validation.ListDV;
import com.ibm.xml.xlxp2.datatype.validation.QNameDV;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UnionDV
extends TypeValidator {
    private final TypeValidator[] validators;
    private Object[] enumeration;
    private int[] enumerationType;

    public UnionDV(String string, String string2, String string3, String[] stringArray, int n, TypeValidator[] typeValidatorArray, boolean bl) {
        super(string, string2, string3, 45, 45, stringArray, n, bl);
        this.validators = typeValidatorArray;
    }

    public void setEnumeration(ValidatedInfo[] validatedInfoArray) {
        this.createEnumeration(validatedInfoArray);
    }

    private void createEnumeration(ValidatedInfo[] validatedInfoArray) {
        if (validatedInfoArray != null) {
            this.enumeration = ArrayAllocator.newObjectArray(validatedInfoArray.length);
            this.enumerationType = ArrayAllocator.newIntArray(validatedInfoArray.length);
            for (int i = 0; i < this.enumeration.length; ++i) {
                this.enumeration[i] = validatedInfoArray[i].actualValue;
                this.enumerationType[i] = validatedInfoArray[i].typeValidator.builtInKind;
            }
        }
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        throw new RuntimeException("Should never be called.");
    }

    public Object getActualValue(String string, int n, int[] nArray, String[] stringArray, String string2, ValidatedInfo validatedInfo, TypeUtil typeUtil) {
        return UnionDV.getActualValue(this.validators, string, n, nArray, stringArray, string2, validatedInfo, typeUtil);
    }

    public static Object getActualValue(TypeValidator[] typeValidatorArray, String string, int n, int[] nArray, String[] stringArray, String string2, ValidatedInfo validatedInfo, TypeUtil typeUtil) {
        TypeValidator typeValidator = null;
        for (int i = 0; i < typeValidatorArray.length; ++i) {
            if (typeValidatorArray[i].builtInKind != n) continue;
            typeValidator = typeValidatorArray[i];
            break;
        }
        Object object = null;
        if (n == 19 || n == 20) {
            object = ((QNameDV)typeValidator).getActualValue(string, stringArray, string2, validatedInfo);
        } else if (n == 44 || n == 43) {
            object = ((ListDV)typeValidator).getActualValue(string, nArray, stringArray, string2, validatedInfo, typeUtil);
        } else {
            XMLString xMLString = new XMLString();
            typeUtil.addString(string, xMLString);
            object = typeValidator.getActualValue(xMLString, validatedInfo);
            xMLString.unregister();
        }
        if (validatedInfo != null) {
            validatedInfo.actualValue = object;
            validatedInfo.typeValidator = typeValidator;
            validatedInfo.errorCode = 0;
        }
        return object;
    }

    public static ValidatedInfo parse(TypeValidator[] typeValidatorArray, String string, int n, int[] nArray, String[] stringArray, String string2, TypeUtil typeUtil) {
        ValidatedInfo validatedInfo = new ValidatedInfo();
        UnionDV.getActualValue(typeValidatorArray, string, n, nArray, stringArray, string2, validatedInfo, typeUtil);
        return validatedInfo;
    }

    private static Object parseWithContext(XMLString xMLString, ValidationContext validationContext, ValidatedInfo validatedInfo, TypeValidator[] typeValidatorArray, int[] nArray) {
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        for (int i = 0; i < typeValidatorArray.length; ++i) {
            validatedInfo.errorCode = 0;
            validationContext.tempErrorCode[0] = 0;
            typeValidatorArray[i].validate(xMLString, null, validationContext, validatedInfo);
            if (validatedInfo.errorCode != 0) continue;
            return validatedInfo.actualValue;
        }
        nArray[0] = 1;
        return null;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        int[] nArray = validationContext.tempErrorCode;
        Object object = UnionDV.parseWithContext(xMLString, validationContext, validatedInfo2, this.validators, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        int n = validatedInfo2.typeValidator.builtInKind;
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.typeValidator.builtInKind != n ? 1 : (validatedInfo.actualValue.equals(object) ? 0 : 1);
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(object, xMLString, n);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = object;
    }

    private int checkFacets(Object object, XMLString xMLString, int n) {
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (n != this.enumerationType[i] || !this.enumeration[i].equals(object)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public int checkIdrefAndEntity(Object object, ValidationContext validationContext) {
        for (int i = 0; i < this.validators.length; ++i) {
            if (!this.validators[i].idrefOrEntity || this.validators[i].checkIdrefAndEntity(object, validationContext) == 0) continue;
            return 1;
        }
        return 0;
    }

    public TypeValidator[] getValidators() {
        return this.validators;
    }
}

