/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class DecimalDV
extends TypeValidator {
    private final int totalDigits;
    private final int fractionDigits;
    private final XDecimal[] enumeration;
    private final XDecimal maxInclusive;
    private final XDecimal maxExclusive;
    private final XDecimal minInclusive;
    private final XDecimal minExclusive;

    public DecimalDV(String string, String string2, String string3, String[] stringArray, XDecimal[] xDecimalArray, XDecimal xDecimal, XDecimal xDecimal2, XDecimal xDecimal3, XDecimal xDecimal4, int n, int n2, int n3) {
        super(string, string2, string3, 4, 4, stringArray, n3, false);
        this.totalDigits = n;
        this.fractionDigits = n2;
        this.enumeration = xDecimalArray;
        this.maxInclusive = xDecimal3;
        this.maxExclusive = xDecimal4;
        this.minInclusive = xDecimal;
        this.minExclusive = xDecimal2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XDecimal xDecimal = DecimalDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xDecimal;
            validatedInfo.errorCode = 0;
        }
        return xDecimal;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            XDecimal xDecimal2 = xDecimal = xMLString.bytes != null ? DecimalDV.parseDecimalUnbuffered(xMLString, validationContext.getXDecimal()) : DecimalDV.parseDecimalBuffered(xMLString, validationContext.getXDecimal());
        }
        if (xDecimal == null) {
            validatedInfo2.errorCode = 1;
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = validatedInfo.actualValue.equals(xDecimal) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(xDecimal, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xDecimal;
    }

    public int preCheckFacets(XDecimal xDecimal, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xDecimal, xMLString);
        }
        return 0;
    }

    private final int checkFacets(XDecimal xDecimal, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && xDecimal.totalDigits > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x400) != 0 && xDecimal.fracDigits > this.fractionDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && xDecimal.compareTo(this.minInclusive) == -1) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && xDecimal.compareTo(this.minExclusive) != 1) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && xDecimal.compareTo(this.maxInclusive) == 1) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && xDecimal.compareTo(this.maxExclusive) != -1) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equals(xDecimal)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private int parseDecimalUnbuffered(ParsedEntity parsedEntity, XDecimal xDecimal, boolean[] blArray) {
        int n;
        int n2;
        int n3;
        byte[] byArray = parsedEntity.bytes;
        int n4 = parsedEntity.offset;
        int n5 = parsedEntity.endOffset;
        int n6 = 1;
        int n7 = DecimalDV.removeWhitespace(byArray, n4, n5, blArray);
        if (n7 >= n5) {
            return 0;
        }
        if (byArray[n7] == 43) {
            ++n7;
        } else if (byArray[n7] == 45) {
            ++n7;
            n6 = -1;
        }
        for (n3 = n7; n3 < n5 && byArray[n3] == 48; ++n3) {
        }
        for (n2 = n3; n2 < n5 && byArray[n2] >= 48 && byArray[n2] <= 57; ++n2) {
        }
        int n8 = n = n2;
        int n9 = n;
        if (n2 < n5 && byArray[n2] == 46) {
            n9 = n2 + 1;
            int n10 = 0;
            for (n = n9; n < n5 && byArray[n] >= 48 && byArray[n] <= 57; ++n) {
                if (byArray[n] == 48) {
                    ++n10;
                    continue;
                }
                if (byArray[n] < 49 || byArray[n] > 57) continue;
                n10 = 0;
            }
            n8 = n - n10;
        }
        if ((n4 = DecimalDV.removeWhitespace(byArray, n, n5, blArray)) >= n5) {
            return 0;
        }
        if (n3 == n2 && n9 == n8) {
            if (n7 == n3 && n8 == n) {
                return 0;
            }
            return -n4;
        }
        if (n8 == n2 + 1) {
            n8 = n9 = n2;
        }
        xDecimal.setValues(parsedEntity.buffer, n3, parsedEntity.buffer, n8, n2 - n3, n8 - n9, n6);
        return n4;
    }

    private static XDecimal parseDecimalUnbuffered(XMLString xMLString, XDecimal xDecimal) {
        int n;
        int n2;
        byte[] byArray = xMLString.bytes;
        int n3 = xMLString.startOffset;
        int n4 = xMLString.endOffset;
        int n5 = 1;
        int n6 = n4;
        if (byArray[n3 = XMLStringUtil.removeWhitespace(xMLString.bytes, n3, n4)] == 43) {
            ++n3;
        } else if (byArray[n3] == 45) {
            n5 = -1;
            ++n3;
        }
        int n7 = n3;
        while (n3 < n4 && byArray[n3] == 48) {
            ++n3;
        }
        for (n2 = n3; n2 < n4 && byArray[n2] >= 48 && byArray[n2] <= 57; ++n2) {
        }
        int n8 = n2;
        int n9 = n2;
        if (n2 < n4 && byArray[n2] == 46) {
            n8 = n2 + 1;
            n = 0;
            for (n9 = n8; n9 < n4 && byArray[n9] >= 48 && byArray[n9] <= 57; ++n9) {
                if (byArray[n9] == 48) {
                    ++n;
                    continue;
                }
                if (byArray[n9] < 49 || byArray[n9] > 57) continue;
                n = 0;
            }
            n6 = n > 0 ? n9 - n : n9;
        }
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n9, n4)) < n4) {
            return null;
        }
        if (n2 == n3 && n8 == n6) {
            if (n7 == n3) {
                return null;
            }
            return XDecimal.ZERO;
        }
        if (n6 == n2 + 1) {
            n6 = n8 = n2;
        }
        xDecimal.setValues(xMLString.firstBuffer, n3, xMLString.firstBuffer, n6, n2 - n3, n6 - n8, n5);
        return xDecimal;
    }

    private static XDecimal parseDecimalBuffered(XMLString xMLString, XDecimal xDecimal) {
        int n;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = xMLString.length;
        int n7 = xMLString.startOffset;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        DataBuffer dataBuffer3 = null;
        DataBuffer dataBuffer4 = null;
        byte[] byArray = dataBuffer.bytes;
        int n8 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        int n9 = 0;
        int n10 = 0;
        byte by = byArray[n7];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n7 < n8) {
                    by = byArray[n7];
                    continue;
                }
                if (n7 != n8 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n7 = dataBuffer.startOffset;
                n8 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = byArray[n7];
            }
        }
        if (n7 == n8) {
            return null;
        }
        if (by == 43) {
            ++n7;
            --n6;
        } else if (by == 45) {
            ++n7;
            n3 = -1;
            --n6;
        }
        int n11 = n6;
        while (true) {
            n8 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            n = n7;
            while (n7 < n8 && byArray[n7] == 48) {
                ++n7;
            }
            n11 -= n7 - n;
            if (n7 != n8) break;
            if (dataBuffer == dataBuffer2) {
                return XDecimal.ZERO;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n7 = dataBuffer.startOffset;
        }
        DataBuffer dataBuffer5 = dataBuffer;
        n = n7;
        while (true) {
            if (n7 < n8) {
                by = byArray[n7];
                if (by >= 48 && by <= 57) {
                    if (dataBuffer3 != null) {
                        if (by == 48) {
                            if (dataBuffer4 == null) {
                                dataBuffer4 = dataBuffer;
                                n10 = n7;
                                n5 = n2 - 1;
                            }
                        } else {
                            dataBuffer4 = null;
                        }
                    }
                } else {
                    if (by != 46 || dataBuffer3 != null) break;
                    dataBuffer3 = dataBuffer;
                    n9 = n7;
                    n4 = n2;
                }
                ++n7;
                ++n2;
                continue;
            }
            if (n2 == n11) {
                if (dataBuffer3 == null) {
                    n4 = n5 = n11;
                    break;
                }
                if (dataBuffer4 != null) break;
                n5 = n11 - 1;
                break;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n7 = dataBuffer.startOffset;
            n8 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n7 < n8) {
            by = byArray[n7];
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n7 < n8) {
                        by = byArray[n7];
                        continue;
                    }
                    if (n7 != n8 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n7 = dataBuffer.startOffset;
                    n8 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = byArray[n7];
                }
            }
            if (n7 < n8) {
                return null;
            }
        }
        if (n5 == 0) {
            if (n11 == n6 && dataBuffer4 == null) {
                return null;
            }
            return XDecimal.ZERO;
        }
        if (dataBuffer4 != null) {
            dataBuffer2 = dataBuffer4;
            n8 = n10;
        }
        if (n5 == n4 && dataBuffer3 != null) {
            dataBuffer2 = dataBuffer3;
            n8 = n9;
        }
        if (dataBuffer2.startOffset == n8) {
            dataBuffer = dataBuffer5;
            while (dataBuffer.next != dataBuffer2) {
                dataBuffer = dataBuffer.next;
            }
            dataBuffer2 = dataBuffer;
            n8 = dataBuffer.endOffset;
        }
        xDecimal.setValues(dataBuffer5, n, dataBuffer2, n8, n4, n5 - n4, n3);
        return xDecimal;
    }

    public static XDecimal parse(XMLString xMLString) {
        XDecimal xDecimal = null;
        if (xMLString.length != 0) {
            xDecimal = xMLString.bytes != null ? DecimalDV.parseDecimalUnbuffered(xMLString, new XDecimal()) : DecimalDV.parseDecimalBuffered(xMLString, new XDecimal());
        }
        return xDecimal;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDecimal xDecimal = vMContext.dvContext.getXDecimal();
        int n = this.parseDecimalUnbuffered(parsedEntity, xDecimal, this.fNormalized);
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            xDecimal = XDecimal.ZERO;
            parsedEntity.offset = -n;
        } else {
            parsedEntity.offset = n;
        }
        return xDecimal;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets((XDecimal)object, xMLString);
    }
}

