/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype;

import com.ibm.xml.xlxp2.datatype.XBinary;
import com.ibm.xml.xlxp2.datatype.XByte;
import com.ibm.xml.xlxp2.datatype.XDateTime;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.XDouble;
import com.ibm.xml.xlxp2.datatype.XFloat;
import com.ibm.xml.xlxp2.datatype.XInt;
import com.ibm.xml.xlxp2.datatype.XList;
import com.ibm.xml.xlxp2.datatype.XLong;
import com.ibm.xml.xlxp2.datatype.XQName;
import com.ibm.xml.xlxp2.datatype.XShort;
import com.ibm.xml.xlxp2.datatype.validation.XSNormalizer;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.HashSet;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class ValidationContext {
    private static final int INITIAL_POOL_SIZE = 4;
    public final XSNormalizer xsNormalizer;
    public final int[] tempErrorCode = new int[1];
    public VMContext vmContext;
    private final HashSet<String> fIdTable = new HashSet();
    private final HashSet<String> fIdRefTable = new HashSet();
    private XByte[] fXBytePool;
    private int fXBytePoolResetCount = 0;
    private int fXBytePoolOffset = 0;
    private XMLString[] fXMLStringPool;
    private int fXMLStringPoolResetCount = 0;
    private int fXMLStringPoolOffset = 0;
    private XQName[] fXQNamePool;
    private int fXQNamePoolResetCount = 0;
    private int fXQNamePoolOffset = 0;
    private XList[] fXListPool;
    private int fXListPoolResetCount = 0;
    private int fXListPoolOffset;
    private XDateTime[] fXDateTimePool;
    private int fXDateTimePoolResetCount = 0;
    private int fXDateTimePoolOffset = 0;
    private XBinary[] fXBinaryPool;
    private int fXBinaryPoolResetCount = 0;
    private int fXBinaryPoolOffset = 0;
    private XShort[] fXShortPool;
    private int fXShortPoolResetCount = 0;
    private int fXShortPoolOffset = 0;
    private XInt[] fXIntPool;
    private int fXIntPoolResetCount = 0;
    private int fXIntPoolOffset = 0;
    private XLong[] fXLongPool;
    private int fXLongPoolResetCount = 0;
    private int fXLongPoolOffset = 0;
    private XFloat[] fXFloatPool;
    private int fXFloatPoolResetCount = 0;
    private int fXFloatPoolOffset = 0;
    private XDouble[] fXDoublePool;
    private int fXDoublePoolResetCount = 0;
    private int fXDoublePoolOffset = 0;
    private XDecimal[] fXDecimalPool;
    private int fXDecimalPoolResetCount = 0;
    private int fXDecimalPoolOffset = 0;
    private int fObjectPoolsResetCount = 0;

    public ValidationContext() {
        this(new XSNormalizer());
    }

    public ValidationContext(XSNormalizer xSNormalizer) {
        this.xsNormalizer = xSNormalizer;
        this.createObjectPools();
    }

    public void setSchemaProcessor(VMContext vMContext) {
        this.vmContext = vMContext;
    }

    private void createObjectPools() {
        int n;
        this.fXBytePool = new XByte[4];
        for (n = 0; n < 4; ++n) {
            this.fXBytePool[n] = new XByte();
        }
        this.fXMLStringPool = new XMLString[4];
        for (n = 0; n < 4; ++n) {
            this.fXMLStringPool[n] = new XMLString();
        }
        this.fXQNamePool = new XQName[4];
        for (n = 0; n < 4; ++n) {
            this.fXQNamePool[n] = new XQName();
        }
        this.fXListPool = new XList[4];
        for (n = 0; n < 4; ++n) {
            this.fXListPool[n] = new XList();
        }
        this.fXDateTimePool = new XDateTime[4];
        for (n = 0; n < 4; ++n) {
            this.fXDateTimePool[n] = new XDateTime();
        }
        this.fXBinaryPool = new XBinary[4];
        for (n = 0; n < 4; ++n) {
            this.fXBinaryPool[n] = new XBinary();
        }
        this.fXShortPool = new XShort[4];
        for (n = 0; n < 4; ++n) {
            this.fXShortPool[n] = new XShort();
        }
        this.fXIntPool = new XInt[4];
        for (n = 0; n < 4; ++n) {
            this.fXIntPool[n] = new XInt();
        }
        this.fXLongPool = new XLong[4];
        for (n = 0; n < 4; ++n) {
            this.fXLongPool[n] = new XLong();
        }
        this.fXFloatPool = new XFloat[4];
        for (n = 0; n < 4; ++n) {
            this.fXFloatPool[n] = new XFloat();
        }
        this.fXDoublePool = new XDouble[4];
        for (n = 0; n < 4; ++n) {
            this.fXDoublePool[n] = new XDouble();
        }
        this.fXDecimalPool = new XDecimal[4];
        for (n = 0; n < 4; ++n) {
            this.fXDecimalPool[n] = new XDecimal();
            this.fXDecimalPool[n].rawData = new XMLString();
        }
    }

    private void downsizeObjectPools() {
        Object[] objectArray;
        if (this.fXBytePool.length > 4) {
            objectArray = new XByte[4];
            System.arraycopy(this.fXBytePool, 0, objectArray, 0, 4);
            this.fXBytePool = objectArray;
        }
        if (this.fXMLStringPool.length > 4) {
            objectArray = new XMLString[4];
            System.arraycopy(this.fXMLStringPool, 0, objectArray, 0, 4);
            this.fXMLStringPool = objectArray;
        }
        if (this.fXQNamePool.length > 4) {
            objectArray = new XQName[4];
            System.arraycopy(this.fXQNamePool, 0, objectArray, 0, 4);
            this.fXQNamePool = objectArray;
        }
        if (this.fXListPool.length > 4) {
            objectArray = new XList[4];
            System.arraycopy(this.fXListPool, 0, objectArray, 0, 4);
            this.fXListPool = objectArray;
        }
        if (this.fXDateTimePool.length > 4) {
            objectArray = new XDateTime[4];
            System.arraycopy(this.fXDateTimePool, 0, objectArray, 0, 4);
            this.fXDateTimePool = objectArray;
        }
        if (this.fXBinaryPool.length > 4) {
            objectArray = new XBinary[4];
            System.arraycopy(this.fXBinaryPool, 0, objectArray, 0, 4);
            this.fXBinaryPool = objectArray;
        }
        if (this.fXShortPool.length > 4) {
            objectArray = new XShort[4];
            System.arraycopy(this.fXShortPool, 0, objectArray, 0, 4);
            this.fXShortPool = objectArray;
        }
        if (this.fXIntPool.length > 4) {
            objectArray = new XInt[4];
            System.arraycopy(this.fXIntPool, 0, objectArray, 0, 4);
            this.fXIntPool = objectArray;
        }
        if (this.fXLongPool.length > 4) {
            objectArray = new XLong[4];
            System.arraycopy(this.fXLongPool, 0, objectArray, 0, 4);
            this.fXLongPool = objectArray;
        }
        if (this.fXFloatPool.length > 4) {
            objectArray = new XFloat[4];
            System.arraycopy(this.fXFloatPool, 0, objectArray, 0, 4);
            this.fXFloatPool = objectArray;
        }
        if (this.fXDoublePool.length > 4) {
            objectArray = new XDouble[4];
            System.arraycopy(this.fXDoublePool, 0, objectArray, 0, 4);
            this.fXDoublePool = objectArray;
        }
        if (this.fXDecimalPool.length > 4) {
            objectArray = new XDecimal[4];
            System.arraycopy(this.fXDecimalPool, 0, objectArray, 0, 4);
            this.fXDecimalPool = objectArray;
        }
    }

    public boolean isEntityUnparsed(XMLString xMLString) {
        return this.vmContext.isUnparsedEntity(xMLString);
    }

    public boolean isIdDeclared(XMLString xMLString) {
        String string = this.vmContext.toInternedString(xMLString);
        return this.fIdTable.contains(string);
    }

    public void addId(XMLString xMLString) {
        String string = this.vmContext.toInternedString(xMLString);
        this.fIdTable.add(string);
    }

    public void addIdRef(XMLString xMLString) {
        String string = this.vmContext.toInternedString(xMLString);
        this.fIdRefTable.add(string);
    }

    public String checkIDRefID() {
        for (String string : this.fIdRefTable) {
            if (this.fIdTable.contains(string)) continue;
            return string;
        }
        return null;
    }

    public int getURI(int n) {
        return -1;
    }

    public void reset(boolean bl) {
        this.fIdTable.clear();
        this.fIdRefTable.clear();
        if (!bl) {
            this.downsizeObjectPools();
        }
    }

    public void resetObjectPools() {
        if (++this.fObjectPoolsResetCount < 0) {
            this.resetObjectPoolResetCounts();
        }
    }

    private void resetObjectPoolResetCounts() {
        this.fObjectPoolsResetCount = 1;
        this.fXBytePoolResetCount = 0;
        this.fXMLStringPoolResetCount = 0;
        this.fXQNamePoolResetCount = 0;
        this.fXListPoolResetCount = 0;
        this.fXDateTimePoolResetCount = 0;
        this.fXBinaryPoolResetCount = 0;
        this.fXShortPoolResetCount = 0;
        this.fXIntPoolResetCount = 0;
        this.fXLongPoolResetCount = 0;
        this.fXFloatPoolResetCount = 0;
        this.fXDoublePoolResetCount = 0;
        this.fXDecimalPoolResetCount = 0;
    }

    public String prefixMapping(XMLString xMLString) {
        return this.prefixMapping(this.vmContext.toInternedString(xMLString));
    }

    public String prefixMapping(String string) {
        return this.vmContext.prefixMapping(string);
    }

    public String getSymbol(XMLString xMLString) {
        return this.vmContext.toInternedString(xMLString);
    }

    public XByte getXByte(byte by) {
        if (this.fXBytePoolResetCount != this.fObjectPoolsResetCount) {
            this.fXBytePoolResetCount = this.fObjectPoolsResetCount;
            this.fXBytePoolOffset = 0;
        } else if (++this.fXBytePoolOffset == this.fXBytePool.length) {
            this.growXBytePool();
        }
        XByte xByte = this.fXBytePool[this.fXBytePoolOffset];
        xByte.value = by;
        return xByte;
    }

    private void growXBytePool() {
        int n = this.fXBytePool.length;
        int n2 = n << 1;
        XByte[] xByteArray = new XByte[n2];
        System.arraycopy(this.fXBytePool, 0, xByteArray, 0, n);
        this.fXBytePool = xByteArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXBytePool[i] = new XByte();
        }
    }

    public XMLString getXMLString() {
        if (this.fXMLStringPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXMLStringPoolResetCount = this.fObjectPoolsResetCount;
            this.fXMLStringPoolOffset = 0;
        } else if (++this.fXMLStringPoolOffset == this.fXMLStringPool.length) {
            this.growXMLStringPool();
        }
        XMLString xMLString = this.fXMLStringPool[this.fXMLStringPoolOffset];
        return xMLString;
    }

    private void growXMLStringPool() {
        int n = this.fXMLStringPool.length;
        int n2 = n << 1;
        XMLString[] xMLStringArray = new XMLString[n2];
        System.arraycopy(this.fXMLStringPool, 0, xMLStringArray, 0, n);
        this.fXMLStringPool = xMLStringArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXMLStringPool[i] = new XMLString();
        }
    }

    public XQName getXQName() {
        if (this.fXQNamePoolResetCount != this.fObjectPoolsResetCount) {
            this.fXQNamePoolResetCount = this.fObjectPoolsResetCount;
            this.fXQNamePoolOffset = 0;
        } else if (++this.fXQNamePoolOffset == this.fXQNamePool.length) {
            this.growXQNamePool();
        }
        XQName xQName = this.fXQNamePool[this.fXQNamePoolOffset];
        return xQName;
    }

    private void growXQNamePool() {
        int n = this.fXQNamePool.length;
        int n2 = n << 1;
        XQName[] xQNameArray = new XQName[n2];
        System.arraycopy(this.fXQNamePool, 0, xQNameArray, 0, n);
        this.fXQNamePool = xQNameArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXQNamePool[i] = new XQName();
        }
    }

    public XList getXList() {
        if (this.fXListPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXListPoolResetCount = this.fObjectPoolsResetCount;
            this.fXListPoolOffset = 0;
        } else if (++this.fXListPoolOffset == this.fXListPool.length) {
            this.growXListPool();
        }
        XList xList = this.fXListPool[this.fXListPoolOffset];
        return xList;
    }

    private void growXListPool() {
        int n = this.fXListPool.length;
        int n2 = n << 1;
        XList[] xListArray = new XList[n2];
        System.arraycopy(this.fXListPool, 0, xListArray, 0, n);
        this.fXListPool = xListArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXListPool[i] = new XList();
        }
    }

    public XDateTime getXDateTime(int n, int n2) {
        if (this.fXDateTimePoolResetCount != this.fObjectPoolsResetCount) {
            this.fXDateTimePoolResetCount = this.fObjectPoolsResetCount;
            this.fXDateTimePoolOffset = 0;
        } else if (++this.fXDateTimePoolOffset == this.fXDateTimePool.length) {
            this.growXDateTimePool();
        }
        XDateTime xDateTime = this.fXDateTimePool[this.fXDateTimePoolOffset];
        xDateTime.reuse(n, n2);
        return xDateTime;
    }

    private void growXDateTimePool() {
        int n = this.fXDateTimePool.length;
        int n2 = n << 1;
        XDateTime[] xDateTimeArray = new XDateTime[n2];
        System.arraycopy(this.fXDateTimePool, 0, xDateTimeArray, 0, n);
        this.fXDateTimePool = xDateTimeArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXDateTimePool[i] = new XDateTime();
        }
    }

    public XBinary getXBinary() {
        if (this.fXBinaryPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXBinaryPoolResetCount = this.fObjectPoolsResetCount;
            this.fXBinaryPoolOffset = 0;
        } else if (++this.fXBinaryPoolOffset == this.fXBinaryPool.length) {
            this.growXBinaryPool();
        }
        XBinary xBinary = this.fXBinaryPool[this.fXBinaryPoolOffset];
        return xBinary;
    }

    private void growXBinaryPool() {
        int n = this.fXBinaryPool.length;
        int n2 = n << 1;
        XBinary[] xBinaryArray = new XBinary[n2];
        System.arraycopy(this.fXBinaryPool, 0, xBinaryArray, 0, n);
        this.fXBinaryPool = xBinaryArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXBinaryPool[i] = new XBinary();
        }
    }

    public XShort getXShort(short s) {
        if (this.fXShortPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXShortPoolResetCount = this.fObjectPoolsResetCount;
            this.fXShortPoolOffset = 0;
        } else if (++this.fXShortPoolOffset == this.fXShortPool.length) {
            this.growXShortPool();
        }
        XShort xShort = this.fXShortPool[this.fXShortPoolOffset];
        xShort.value = s;
        return xShort;
    }

    private void growXShortPool() {
        int n = this.fXShortPool.length;
        int n2 = n << 1;
        XShort[] xShortArray = new XShort[n2];
        System.arraycopy(this.fXShortPool, 0, xShortArray, 0, n);
        this.fXShortPool = xShortArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXShortPool[i] = new XShort();
        }
    }

    public XInt getXInt(int n) {
        if (this.fXIntPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXIntPoolResetCount = this.fObjectPoolsResetCount;
            this.fXIntPoolOffset = 0;
        } else if (++this.fXIntPoolOffset == this.fXIntPool.length) {
            this.growXIntPool();
        }
        XInt xInt = this.fXIntPool[this.fXIntPoolOffset];
        xInt.value = n;
        return xInt;
    }

    private void growXIntPool() {
        int n = this.fXIntPool.length;
        int n2 = n << 1;
        XInt[] xIntArray = new XInt[n2];
        System.arraycopy(this.fXIntPool, 0, xIntArray, 0, n);
        this.fXIntPool = xIntArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXIntPool[i] = new XInt();
        }
    }

    public XLong getXLong(long l) {
        if (this.fXLongPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXLongPoolResetCount = this.fObjectPoolsResetCount;
            this.fXLongPoolOffset = 0;
        } else if (++this.fXLongPoolOffset == this.fXLongPool.length) {
            this.growXLongPool();
        }
        XLong xLong = this.fXLongPool[this.fXLongPoolOffset];
        xLong.value = l;
        return xLong;
    }

    private void growXLongPool() {
        int n = this.fXLongPool.length;
        int n2 = n << 1;
        XLong[] xLongArray = new XLong[n2];
        System.arraycopy(this.fXLongPool, 0, xLongArray, 0, n);
        this.fXLongPool = xLongArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXLongPool[i] = new XLong();
        }
    }

    public XFloat getXFloat(float f) {
        if (this.fXFloatPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXFloatPoolResetCount = this.fObjectPoolsResetCount;
            this.fXFloatPoolOffset = 0;
        } else if (++this.fXFloatPoolOffset == this.fXFloatPool.length) {
            this.growXFloatPool();
        }
        XFloat xFloat = this.fXFloatPool[this.fXFloatPoolOffset];
        xFloat.value = f;
        return xFloat;
    }

    private void growXFloatPool() {
        int n = this.fXFloatPool.length;
        int n2 = n << 1;
        XFloat[] xFloatArray = new XFloat[n2];
        System.arraycopy(this.fXFloatPool, 0, xFloatArray, 0, n);
        this.fXFloatPool = xFloatArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXFloatPool[i] = new XFloat();
        }
    }

    public XDouble getXDouble(double d) {
        if (this.fXDoublePoolResetCount != this.fObjectPoolsResetCount) {
            this.fXDoublePoolResetCount = this.fObjectPoolsResetCount;
            this.fXDoublePoolOffset = 0;
        } else if (++this.fXDoublePoolOffset == this.fXDoublePool.length) {
            this.growXDoublePool();
        }
        XDouble xDouble = this.fXDoublePool[this.fXDoublePoolOffset];
        xDouble.value = d;
        return xDouble;
    }

    private void growXDoublePool() {
        int n = this.fXDoublePool.length;
        int n2 = n << 1;
        XDouble[] xDoubleArray = new XDouble[n2];
        System.arraycopy(this.fXDoublePool, 0, xDoubleArray, 0, n);
        this.fXDoublePool = xDoubleArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXDoublePool[i] = new XDouble();
        }
    }

    public XDecimal getXDecimal() {
        if (this.fXDecimalPoolResetCount != this.fObjectPoolsResetCount) {
            this.fXDecimalPoolResetCount = this.fObjectPoolsResetCount;
            this.fXDecimalPoolOffset = 0;
        } else if (++this.fXDecimalPoolOffset == this.fXDecimalPool.length) {
            this.growXDecimalPool();
        }
        return this.fXDecimalPool[this.fXDecimalPoolOffset];
    }

    private void growXDecimalPool() {
        int n = this.fXDecimalPool.length;
        int n2 = n << 1;
        XDecimal[] xDecimalArray = new XDecimal[n2];
        System.arraycopy(this.fXDecimalPool, 0, xDecimalArray, 0, n);
        this.fXDecimalPool = xDecimalArray;
        for (int i = n2 - 1; i >= n; --i) {
            this.fXDecimalPool[i] = new XDecimal();
            this.fXDecimalPool[i].rawData = new XMLString();
        }
    }
}

