/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class DataSourceFactory {
    private static final int DEFAULT_BUFFER_LENGTH = 65536;
    private DataBufferFactory fBufferFactory;
    private int fBufferLength;
    private boolean fNormalizeLineBreaks;
    private ByteStreamDataSource fFreeByteStreamDataSource;
    private CharacterStreamDataSource fFreeCharacterStreamDataSource;

    public DataSourceFactory(DataBufferFactory dataBufferFactory) {
        this.fBufferFactory = dataBufferFactory;
        this.fBufferLength = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    return Integer.getInteger("com.ibm.xml.xlxp2.api.util.encoding.DataSourceFactory.bufferLength", 65536);
                }
                catch (SecurityException securityException) {
                    return 65536;
                }
            }
        });
        this.fNormalizeLineBreaks = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return Boolean.getBoolean("com.ibm.xml.xlxp2.api.util.encoding.DataSourceFactory.normalizeLineBreaks");
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
        });
    }

    public void setBufferLength(int n) {
        this.fBufferLength = n;
    }

    public void setNormalizeLineBreaks(boolean bl) {
        this.fNormalizeLineBreaks = bl;
    }

    public ByteStreamDataSource allocateByteStreamDataSource() {
        ByteStreamDataSource byteStreamDataSource = this.fFreeByteStreamDataSource;
        if (byteStreamDataSource != null) {
            this.fFreeByteStreamDataSource = byteStreamDataSource.getNextFreeDataSource();
            byteStreamDataSource.setNextFreeDataSource(null);
            byteStreamDataSource.bufferLength = this.fBufferLength;
        } else {
            byteStreamDataSource = new ByteStreamDataSource(this, this.fBufferFactory, this.fBufferLength);
        }
        byteStreamDataSource.normalizeLineBreaks = this.fNormalizeLineBreaks;
        return byteStreamDataSource;
    }

    public void releaseByteStreamDataSource(ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setNextFreeDataSource(this.fFreeByteStreamDataSource);
        this.fFreeByteStreamDataSource = byteStreamDataSource;
    }

    public CharacterStreamDataSource allocateCharacterStreamDataSource() {
        CharacterStreamDataSource characterStreamDataSource = this.fFreeCharacterStreamDataSource;
        if (characterStreamDataSource != null) {
            this.fFreeCharacterStreamDataSource = characterStreamDataSource.getNextFreeDataSource();
            characterStreamDataSource.setNextFreeDataSource(null);
            characterStreamDataSource.bufferLength = this.fBufferLength;
        } else {
            characterStreamDataSource = new CharacterStreamDataSource(this, this.fBufferFactory, this.fBufferLength);
        }
        characterStreamDataSource.normalizeLineBreaks = this.fNormalizeLineBreaks;
        return characterStreamDataSource;
    }

    public void releaseCharacterStreamDataSource(CharacterStreamDataSource characterStreamDataSource) {
        characterStreamDataSource.setNextFreeDataSource(this.fFreeCharacterStreamDataSource);
        this.fFreeCharacterStreamDataSource = characterStreamDataSource;
    }
}

