/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPHeaderElementProxy;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NamespaceUtil {
    private static final String clsName = ConfigUtil.class.getName();
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register(NamespaceUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public static boolean isWsse(String ns) {
        if (ns == null) {
            return false;
        }
        return NamespaceUtil.compareNS(ns, 0);
    }

    public static boolean isWsu(String ns) {
        if (ns == null) {
            return false;
        }
        return NamespaceUtil.compareNS(ns, 1);
    }

    public static String getCorrespondingWSUNS(String wsseNS) {
        String tmp = wsseNS;
        String ret = null;
        if (tmp != null && tmp.length() != 0) {
            for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
                if (!tmp.equals(Constants.NAMESPACES[0][i]) || i >= Constants.NAMESPACES[1].length) continue;
                ret = Constants.NAMESPACES[1][i];
            }
        }
        return ret;
    }

    public static boolean validate(MessageContextProxy context) {
        String wsseTmp;
        String wsuTmp = (String)context.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace");
        int wsseIdx = -1;
        int wsuIdx = -1;
        if (wsuTmp != null) {
            for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
                if (!wsuTmp.equals(Constants.NAMESPACES[1][i])) continue;
                wsuIdx = i;
            }
        }
        if ((wsseTmp = (String)context.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace")) != null) {
            for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
                if (!wsseTmp.equals(Constants.NAMESPACES[0][i])) continue;
                wsseIdx = i;
            }
        }
        boolean retValue = false;
        if (wsuIdx != -1) {
            retValue = wsseIdx == wsuIdx;
        } else if (wsseIdx == Constants.NAMESPACES[0].length) {
            retValue = true;
        }
        return retValue;
    }

    public static NodeList getWsseElementsByTagName(Element elem, String local) {
        return NamespaceUtil.getXElementsByTagName(elem, local, 0);
    }

    private static NodeList getXElementsByTagName(Element elem, String local, int index) {
        NodeList list = null;
        for (int i = 0; i < Constants.NAMESPACES[index].length; ++i) {
            list = elem.getElementsByTagNameNS(Constants.NAMESPACES[index][i], local);
            if (list == null || list.getLength() <= 0) continue;
            return list;
        }
        return list;
    }

    public static NodeList getWsuElementsByTagName(Element elem, String local) {
        return NamespaceUtil.getXElementsByTagName(elem, local, 1);
    }

    public static Element getFirstChildWsseElement(Element elem, String local) {
        Element child = null;
        for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
            child = DOMUtil.getFirstElement(elem, Constants.NAMESPACES[0][i], local);
            if (child == null) continue;
            return child;
        }
        return child;
    }

    public static Element getFirstChildWsuElement(Element elem, String local) {
        Element child = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            child = DOMUtil.getFirstElement(elem, Constants.NAMESPACES[1][i], local);
            if (child == null) continue;
            return child;
        }
        return child;
    }

    public static SOAPHeaderElementProxy getWsseHeaderByName(SOAPEnvelopeProxy env, String local, boolean accessAll) throws FaultProxy {
        return NamespaceUtil.findHeader(env, local, accessAll, 0);
    }

    public static SOAPHeaderElementProxy getWsuHeaderByName(SOAPEnvelopeProxy env, String local, boolean accessAll) throws FaultProxy {
        return NamespaceUtil.findHeader(env, local, accessAll, 1);
    }

    private static SOAPHeaderElementProxy findHeader(SOAPEnvelopeProxy env, String local, boolean accessAll, int idx) throws FaultProxy {
        SOAPHeaderElementProxy header2 = null;
        for (int i = 0; i < Constants.NAMESPACES[idx].length; ++i) {
            header2 = env.getHeaderByName(Constants.NAMESPACES[idx][i], local, accessAll);
            if (header2 == null) continue;
            return header2;
        }
        return header2;
    }

    public static String getWsuAttribute(Element elem, String name2) {
        String value2 = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            value2 = elem.getAttributeNS(Constants.NAMESPACES[1][i], name2);
            if (value2.length() == 0) continue;
            return value2;
        }
        return value2;
    }

    public static boolean equals(QName received, QName inConstants) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Comparing QName \"" + received + "\" with \"" + inConstants + "\"");
        }
        if (received == null || inConstants == null) {
            return false;
        }
        if (inConstants.equals(received)) {
            return true;
        }
        String receivedLocal = received.getLocalPart();
        String inConstLocal = inConstants.getLocalPart();
        if (!inConstLocal.equals(receivedLocal)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Compared local part \"" + receivedLocal + "\" with \"" + inConstLocal + "\", did not match");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Compared local part \"" + receivedLocal + "\" with \"" + inConstLocal + "\", matched.");
        }
        String receivedNS = received.getNamespaceURI();
        String inConstNS = inConstants.getNamespaceURI();
        if (inConstNS.equals(Constants.NAMESPACES[0][0])) {
            if (NamespaceUtil.compareNS(receivedNS, 0)) {
                return true;
            }
        } else if (inConstNS.equals(Constants.NAMESPACES[1][0])) {
            if (NamespaceUtil.compareNS(receivedNS, 1)) {
                return true;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Input namespace \"" + inConstNS + "\" did not match \"" + Constants.NAMESPACES[0][0] + "\" or \"" + Constants.NAMESPACES[1][0] + "\"");
        }
        return false;
    }

    private static boolean compareNS(String received, int idx) {
        for (int i = 0; i < Constants.NAMESPACES[idx].length; ++i) {
            if (received.equals(Constants.NAMESPACES[idx][i])) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compared namespace \"" + received + "\" with \"" + Constants.NAMESPACES[idx][i] + "\", matched");
                }
                return true;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Compared namespace \"" + received + "\" with \"" + Constants.NAMESPACES[idx][i] + "\", did not match");
        }
        return false;
    }
}

