/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import java.text.ParseException;
import java.util.Calendar;

public class Duration {
    private static final int ST_START = 0;
    private static final int ST_NEG = 1;
    private static final int ST_P = 2;
    private static final int ST_DIGIT_YMD = 3;
    private static final int ST_T = 1004;
    private static final int ST_YEAR = 1005;
    private static final int ST_MONTH = 1006;
    private static final int ST_DAY = 1007;
    private static final int ST_DIGIT_MD = 8;
    private static final int ST_DIGIT_D = 9;
    private static final int ST_DIGIT_HMS = 10;
    private static final int ST_HOUR = 1011;
    private static final int ST_MINUTE = 1012;
    private static final int ST_PERIOD = 13;
    private static final int ST_SECOND = 1014;
    private static final int ST_DIGIT_MS = 15;
    private static final int ST_DIGIT_S = 16;
    private static final int ST_DIGIT_MILLI = 17;
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
    int millisecond;

    public static Duration parse(String text) throws ParseException {
        int state = 0;
        int len = text.length();
        int off = 0;
        int neg = 1;
        int temp = Integer.MAX_VALUE;
        Duration ret = new Duration();
        while (state < 1000 || off < len) {
            int ch = off < len ? text.charAt(off) & 0xFF : -1;
            switch (state) {
                case 0: {
                    if (ch == 45) {
                        neg = -1;
                        ++off;
                        state = 1;
                        break;
                    }
                    if (ch == 80) {
                        ++off;
                        state = 2;
                        break;
                    }
                    throw new ParseException("'-' or 'P' is expected.", off);
                }
                case 1: {
                    if (ch == 80) {
                        ++off;
                        state = 2;
                        break;
                    }
                    throw new ParseException("'P' is expected.", off);
                }
                case 2: {
                    int digitlen;
                    if (48 <= ch && ch <= 57) {
                        digitlen = Duration.lookupDigit(text, off);
                        temp = Integer.parseInt(text.substring(off, off + digitlen));
                        off += digitlen;
                        state = 3;
                        break;
                    }
                    if (ch == 84) {
                        ++off;
                        state = 1004;
                        break;
                    }
                    throw new ParseException("Digit or 'T' is expected.", off);
                }
                case 3: {
                    if (ch == 89) {
                        ret.year = neg * temp;
                        ++off;
                        state = 1005;
                        break;
                    }
                    if (ch == 77) {
                        ret.month = neg * temp;
                        ++off;
                        state = 1006;
                        break;
                    }
                    if (ch == 68) {
                        ret.day = neg * temp;
                        ++off;
                        state = 1007;
                        break;
                    }
                    throw new ParseException("'Y' or 'M' or 'D' is expected.", off);
                }
                case 1005: {
                    int digitlen;
                    if (48 <= ch && ch <= 57) {
                        digitlen = Duration.lookupDigit(text, off);
                        temp = Integer.parseInt(text.substring(off, off + digitlen));
                        off += digitlen;
                        state = 8;
                        break;
                    }
                    if (ch == 84) {
                        ++off;
                        state = 1004;
                        break;
                    }
                    throw new ParseException("Digit or 'T' is expected.", off);
                }
                case 8: {
                    if (ch == 77) {
                        ret.month = neg * temp;
                        ++off;
                        state = 1006;
                        break;
                    }
                    if (ch == 68) {
                        ret.day = neg * temp;
                        ++off;
                        state = 1007;
                        break;
                    }
                    throw new ParseException("'M' or 'D' is expected.", off);
                }
                case 1006: {
                    int digitlen;
                    if (48 <= ch && ch <= 57) {
                        digitlen = Duration.lookupDigit(text, off);
                        temp = Integer.parseInt(text.substring(off, off + digitlen));
                        off += digitlen;
                        state = 9;
                        break;
                    }
                    if (ch == 84) {
                        ++off;
                        state = 1004;
                        break;
                    }
                    throw new ParseException("Digit or 'T' is expected.", off);
                }
                case 9: {
                    if (ch == 68) {
                        ret.day = neg * temp;
                        ++off;
                        state = 1007;
                        break;
                    }
                    throw new ParseException("'D' is expected.", off);
                }
                case 1007: {
                    if (ch == 84) {
                        ++off;
                        state = 1004;
                        break;
                    }
                    throw new ParseException("'T' is expected.", off);
                }
                case 1004: {
                    int digitlen;
                    if (48 <= ch && ch <= 57) {
                        digitlen = Duration.lookupDigit(text, off);
                        temp = Integer.parseInt(text.substring(off, off + digitlen));
                        off += digitlen;
                        state = 10;
                        break;
                    }
                    throw new ParseException("Digit is expected.", off);
                }
                case 10: {
                    if (ch == 72) {
                        ret.hour = neg * temp;
                        ++off;
                        state = 1011;
                        break;
                    }
                    if (ch == 77) {
                        ret.minute = neg * temp;
                        ++off;
                        state = 1012;
                        break;
                    }
                    if (ch == 46) {
                        ret.second = neg * temp;
                        ++off;
                        state = 13;
                        break;
                    }
                    if (ch == 83) {
                        ret.second = neg * temp;
                        ++off;
                        state = 1014;
                        break;
                    }
                    throw new ParseException("'H', 'M', '.', or 'S' is expected.", off);
                }
                case 1011: {
                    int digitlen;
                    if (48 <= ch && ch <= 57) {
                        digitlen = Duration.lookupDigit(text, off);
                        temp = Integer.parseInt(text.substring(off, off + digitlen));
                        off += digitlen;
                        state = 15;
                        break;
                    }
                    throw new ParseException("Digit is expected.", off);
                }
                case 15: {
                    if (ch == 77) {
                        ret.minute = neg * temp;
                        ++off;
                        state = 1012;
                        break;
                    }
                    if (ch == 46) {
                        ret.second = neg * temp;
                        ++off;
                        state = 13;
                        break;
                    }
                    if (ch == 83) {
                        ret.second = neg * temp;
                        ++off;
                        state = 1014;
                        break;
                    }
                    throw new ParseException("'M', '.', or 'S' is expected.", off);
                }
                case 1012: {
                    int digitlen;
                    if (48 <= ch && ch <= 57) {
                        digitlen = Duration.lookupDigit(text, off);
                        temp = Integer.parseInt(text.substring(off, off + digitlen));
                        off += digitlen;
                        state = 16;
                        break;
                    }
                    throw new ParseException("Digit is expected.", off);
                }
                case 16: {
                    if (ch == 46) {
                        ret.second = neg * temp;
                        ++off;
                        state = 13;
                        break;
                    }
                    if (ch == 83) {
                        ret.second = neg * temp;
                        ++off;
                        state = 1014;
                        break;
                    }
                    throw new ParseException("'.' or 'S' is expected.", off);
                }
                case 13: {
                    int digitlen;
                    if (48 <= ch && ch <= 57) {
                        digitlen = Duration.lookupDigit(text, off);
                        if (digitlen == 1) {
                            temp = Integer.parseInt(text.substring(off, off + digitlen));
                            temp *= 100;
                        } else if (digitlen == 2) {
                            temp = Integer.parseInt(text.substring(off, off + digitlen));
                            temp *= 10;
                        } else if (digitlen >= 3) {
                            temp = Integer.parseInt(text.substring(off, off + 3));
                        }
                        off += digitlen;
                        state = 17;
                        break;
                    }
                    if (ch == 83) {
                        ++off;
                        state = 1014;
                        break;
                    }
                    throw new ParseException("Digit is expected.", off);
                }
                case 17: {
                    ret.millisecond = neg * temp;
                    if (ch == 83) {
                        ++off;
                        state = 1014;
                        break;
                    }
                    throw new ParseException("'S' is expected.", off);
                }
                case 1014: {
                    throw new ParseException("Unexpected character.", off);
                }
            }
        }
        return ret;
    }

    private static final int lookupDigit(String t, int index) {
        char ch;
        int i;
        int len = t.length();
        for (i = index; i < len && (ch = t.charAt(i)) >= '0' && '9' >= ch; ++i) {
        }
        return i - index;
    }

    Duration() {
        this.millisecond = 0;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.day = 0;
        this.month = 0;
        this.year = 0;
    }

    public Duration(int y, int mo, int d, int h, int mi, int s, int msec) {
        this.year = y;
        this.month = mo;
        this.day = d;
        this.hour = h;
        this.minute = mi;
        this.second = s;
        this.millisecond = msec;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public void addTo(Calendar cal) {
        cal.add(1, this.year);
        cal.add(2, this.month);
        cal.add(6, this.day);
        cal.add(11, this.hour);
        cal.add(12, this.minute);
        cal.add(13, this.second);
        cal.add(14, this.millisecond);
    }

    public String toString() {
        return "Duration(year=" + this.year + " month=" + this.month + " day=" + this.day + " hour=" + this.hour + " min=" + this.minute + " sec=" + this.second + " msec=" + this.millisecond + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration d = (Duration)obj;
        return this.year == d.year && this.month == d.month && this.day == d.day && this.hour == d.hour && this.minute == d.minute && this.second == d.second && this.millisecond == d.millisecond;
    }
}

