/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.domutil.Serializer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.ErrorHandlerImpl;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtil {
    private static final TraceComponent tc = Tr.register(DOMUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = DOMUtil.class.getName();
    private static final PrivilegedAction contextLoaderGetter = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final HashSet INDENT_NS = new HashSet();

    public static Document parse(InputSource in, boolean validating) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse(InputStream in,boolean validating[" + validating + "])");
        }
        Document doc = null;
        try {
            AlgorithmFactory factory = AlgorithmFactory.getInstance();
            DocumentBuilder builder = factory.getDocumentBuilder();
            ErrorHandlerImpl errorHandler = new ErrorHandlerImpl();
            builder.setErrorHandler(errorHandler);
            builder.setEntityResolver(new JarEntityResolver());
            doc = builder.parse(in);
            int errorCount = errorHandler.getErrorCount();
            builder.setErrorHandler(null);
            builder.setEntityResolver(null);
            factory.releaseDocumentBuilder(builder);
            if (errorCount > 0) {
                throw new SAXException(ConfigUtil.getMessage("security.wssecurity.DOMUtil.s01", new String[]{Integer.toString(errorCount)}));
            }
        }
        catch (ParserConfigurationException e) {
            Tr.processException(e, clsName + ".parse", "111");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{e});
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.s04", (Throwable)e);
        }
        catch (IOException e) {
            Tr.processException(e, clsName + ".parse", "115");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{e});
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.s04", (Throwable)e);
        }
        catch (SAXException e) {
            Tr.processException(e, clsName + ".parse", "119");
            Tr.error(tc, "security.wssecurity.DOMUtil.s04", new Object[]{e});
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.s04", (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse(InputStream in,boolean validating) returns Document[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    public static Document getPrivateConfig(boolean sender) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(boolean sender[" + sender + "])");
        }
        String file = sender ? "config/ibm-wssecurity-sender-private.xml" : "config/ibm-wssecurity-receiver-private.xml";
        Document doc = DOMUtil.getPrivateConfig(file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(boolean sender) returns Document[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    protected static Document getPrivateConfig(final String file) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateConfig(String file[" + file + "])");
        }
        Document doc = null;
        try {
            doc = (Document)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SoapSecurityException {
                    InputSource src = DOMUtil.getResourceAsInputSource(file);
                    return DOMUtil.parse(src, true);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            SoapSecurityException e = (SoapSecurityException)((Object)pae.getException());
            Tr.processException(e, clsName + ".getPrivateCofig", "164");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            Throwable cause = e.getCauseException();
            if (cause != null) {
                throw new IllegalArgumentException(e.getMessage() + ": " + cause.getMessage());
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Throwable e) {
            Tr.processException(e, clsName + ".getPrivateConfig", "174");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateConfig(String file) returns Document[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    public static Document getConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigValidation()");
        }
        String file = "config/ibm-wssecurity-config-validation.xml";
        Document doc = null;
        try {
            doc = (Document)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SoapSecurityException {
                    InputSource src = DOMUtil.getResourceAsInputSource("config/ibm-wssecurity-config-validation.xml");
                    return DOMUtil.parse(src, true);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            SoapSecurityException e = (SoapSecurityException)((Object)pae.getException());
            Tr.processException(e, clsName + ".getPrivateCofig", "203");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            Throwable cause = e.getCauseException();
            if (cause != null) {
                throw new IllegalArgumentException(e.getMessage() + ": " + cause.getMessage());
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Throwable e) {
            Tr.processException(e, clsName + ".getPrivateConfig", "213");
            Tr.error(tc, "security.wssecurity.FileConfigSSR.init", new Object[]{e});
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigValidation() returns Document[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    public static InputSource getResourceAsInputSource(String path) {
        ClassLoader loader;
        InputStream in;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceAsInputSource(String path[" + path + "])");
        }
        if ((in = (loader = DOMUtil.class.getClassLoader()).getResourceAsStream(path)) == null) {
            in = loader.getResourceAsStream("/" + path);
        }
        if (in == null) {
            loader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
            if (loader == null) {
                in = ClassLoader.getSystemResourceAsStream(path);
                if (in == null) {
                    in = ClassLoader.getSystemResourceAsStream("/" + path);
                }
            } else {
                in = loader.getResourceAsStream(path);
                if (in == null) {
                    in = loader.getResourceAsStream("/" + path);
                }
            }
        }
        if (in == null) {
            throw new RuntimeException(ConfigUtil.getMessage("security.wssecurity.DOMUtil.s03", new String[]{path}));
        }
        InputSource is = new InputSource(in);
        if (tc.isEntryEnabled()) {
            String isStr = is == null ? "null" : "not null";
            Tr.exit(tc, "getResourceAsInputSource(String path) returns InputSource[" + isStr + "]");
        }
        return is;
    }

    public static String toString(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        String str = DOMUtil.toString(node, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString(Node node) returns String[" + str + "]");
        }
        return str;
    }

    public static String toString(Node node, String enc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString(Node node[" + DOMUtil.getDisplayName(node) + "]," + "String enc[" + enc + "])");
        }
        String dataString = null;
        if (node != null) {
            byte[] data = null;
            try {
                data = Serializer.serialize((Node)node);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Internal Error: " + ioe);
            }
            try {
                dataString = enc == null ? new String(data) : new String(data, enc);
            }
            catch (Exception e) {
                dataString = new String(data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString(Node node,String enc) returns String[" + dataString + "]");
        }
        return dataString;
    }

    public static Document createDocument() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDocument()");
        }
        Document doc = null;
        try {
            AlgorithmFactory factory = AlgorithmFactory.getInstance();
            DocumentBuilder builder = factory.getDocumentBuilder();
            doc = builder.newDocument();
            factory.releaseDocumentBuilder(builder);
        }
        catch (ParserConfigurationException e) {
            Tr.processException(e, clsName + ".getPrivateCofig", "378");
            Tr.error(tc, "security.wssecurity.DOMUtil.s05", new Object[]{e});
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.s05", (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDocument() returns Document[" + DOMUtil.getDisplayName(doc) + "]");
        }
        return doc;
    }

    public static Element getZeroOrOneElement(Element config, String ns, String name2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(Element config[" + DOMUtil.getDisplayName(config) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        Element elem = null;
        NodeList list = config.getElementsByTagNameNS(ns, name2);
        if (list.getLength() != 0) {
            if (list.getLength() == 1) {
                elem = (Element)list.item(0);
            } else {
                String param = (ns != null ? "{" + ns + "}" : "") + name2;
                throw SoapSecurityException.format((String)"security.wssecurity.RequestReceiverConfig.sconf02", (String)param);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(Element config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static Element getZeroOrOneElement(Document config, String ns, String name2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getZeroOrOneElement(Document config[" + DOMUtil.getDisplayName(config) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        Element elem = DOMUtil.getZeroOrOneElement(config.getDocumentElement(), ns, name2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getZeroOrOneElement(Document config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static Element getOneElement(Element config, String ns, String name2) throws SoapSecurityException {
        NodeList list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(Element config[" + DOMUtil.getDisplayName(config) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        if ((list = config.getElementsByTagNameNS(ns, name2)).getLength() != 1) {
            String param = (ns != null ? "{" + ns + "}" : "") + name2;
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf03", (String)param);
        }
        Element elem = (Element)list.item(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(Element config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static Element getOneElement(Document config, String ns, String name2) throws SoapSecurityException {
        NodeList list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneElement(Document config[" + DOMUtil.getDisplayName(config) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        if ((list = config.getElementsByTagNameNS(ns, name2)).getLength() != 1) {
            String param = (ns != null ? "{" + ns + "}" : "") + name2;
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf03", (String)param);
        }
        Element elem = (Element)list.item(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneElement(Document config,String ns,String name) returns Element[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static NodeList getChildElements(Element parent, String ns, String name2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElements(Element parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        final ArrayList<Node> children = new ArrayList<Node>();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !DOMUtil.equals(node, ns, name2)) continue;
            children.add(node);
        }
        NodeList nlist = new NodeList(){

            public int getLength() {
                return children.size();
            }

            public Node item(int index) {
                return (Node)children.get(index);
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElements(Element parent,String ns,String name) returns NodeList[" + nlist + "]");
        }
        return nlist;
    }

    public static Element getChildElement(Element parent, String ns, String name2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildElement(Element parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        Element child = null;
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !DOMUtil.equals(node, ns, name2)) continue;
            child = (Element)node;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildElement(Element parent,String ns,String name) returns Element[" + DOMUtil.getDisplayName(child) + "]");
        }
        return child;
    }

    public static Element getAncestorElement(Element element, String ns, String name2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAncestorElement(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        Element elem = null;
        if (DOMUtil.equals(element, ns, name2)) {
            elem = element;
        } else {
            for (Node parent = element.getParentNode(); parent != null && element != parent; parent = parent.getParentNode()) {
                if (parent.getNodeType() != 1) continue;
                elem = DOMUtil.getAncestorElement((Element)parent, ns, name2);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAncestorElement(Element element,String ns,String name) returns Element[" + DOMUtil.getDisplayName(elem) + "]");
        }
        return elem;
    }

    public static boolean equals(Node node, String ns, String name2) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(Node node[" + DOMUtil.getDisplayName(node) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        boolean bl = ret = DOMUtil.equals(node.getNamespaceURI(), ns) && DOMUtil.equals(node.getLocalName(), name2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(Node node,String ns,String name) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static boolean equals(String str1, String str2) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(String str1[" + str1 + "]," + "String str2[" + str2 + "])");
        }
        boolean bl = ret = str1 == null && str2 == null || str1 != null && str1.equals(str2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(String str1,String str2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean equals(Node node1, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(Node node1[" + DOMUtil.getDisplayName(node1) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (node1 == null || node2 == null) {
            ret = false;
        } else if (node1.equals(node2)) {
            ret = true;
        } else if (node1.getNodeType() != node2.getNodeType()) {
            ret = false;
        } else {
            switch (node1.getNodeType()) {
                case 1: {
                    ret = DOMUtil.equalsElement(node1, node2);
                    break;
                }
                case 2: {
                    ret = DOMUtil.equalsAttribute((Attr)node1, (Attr)node2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    ret = DOMUtil.equalsTextValue(node1, node2);
                    break;
                }
                case 5: 
                case 12: {
                    ret = DOMUtil.equalsNodeName(node1, node2);
                    break;
                }
                default: {
                    ret = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(Node node1,Node node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static boolean equalsElement(Node node1, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsElement(Node node1[" + DOMUtil.getDisplayName(node1) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getNamespaceURI(), node2.getNamespaceURI()) && DOMUtil.equals(node1.getLocalName(), node2.getLocalName())) {
            Node n1 = node1.getParentNode();
            Node n2 = node2.getParentNode();
            Element nc1 = DOMUtil.getFirstElement(n1);
            Element nc2 = DOMUtil.getFirstElement(n2);
            while (nc1 != null && nc2 != null) {
                if (nc1.equals(node1) && nc2.equals(node2)) {
                    if (n1 != null && n2 != null && n1.getNodeType() == 9 && n2.getNodeType() == 9) {
                        ret = true;
                    } else {
                        ret = DOMUtil.equals(n1, n2);
                        break;
                    }
                }
                nc1 = DOMUtil.getNextElement(nc1);
                nc2 = DOMUtil.getNextElement(nc2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsElement(Node node1,Node node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static boolean equalsAttribute(Attr node1, Attr node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsAttribute(Attr node1[" + DOMUtil.getDisplayName(node1) + "]," + "Attr node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getName(), node2.getName()) && DOMUtil.equals(node1.getValue(), node2.getValue())) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsAttribute(Attr node1,Attr node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static boolean equalsTextValue(Node node1, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsTextValue(Node node1[" + DOMUtil.getDisplayName(node1) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getNodeValue(), node2.getNodeValue())) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsTextValue(Node node1,Node node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private static boolean equalsNodeName(Node node1, Node node2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equalsNodeName(Node node1[" + DOMUtil.getDisplayName(node1) + "]," + "Node node2[" + DOMUtil.getDisplayName(node2) + "])");
        }
        boolean ret = false;
        if (node1 == null && node2 == null) {
            ret = true;
        } else if (DOMUtil.equals(node1.getNodeName(), node2.getNodeName())) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equalsNodeName(Node node1,Node node2) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static NodeList getOneOrMoreChildElements(Element parent, String ns, String name2) throws SoapSecurityException {
        NodeList children;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreChildElements(Element parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        if ((children = DOMUtil.getChildElements(parent, ns, name2)).getLength() <= 0) {
            String param = (ns != null ? "{" + ns + "}" : "") + name2;
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf09", (String)param);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreChildElements(Element parent,String ns,String name) returns NodeList[" + children + "]");
        }
        return children;
    }

    public static NodeList getOneOrMoreElements(Element parent, String ns, String name2) throws SoapSecurityException {
        NodeList descendants;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneOrMoreElements(Element parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        if ((descendants = parent.getElementsByTagNameNS(ns, name2)).getLength() <= 0) {
            String param = (ns != null ? "{" + ns + "}" : "") + name2;
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf09", (String)param);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneOrMoreElements(Element parent,String ns,String name) retuns NodeList[" + descendants + "]");
        }
        return descendants;
    }

    public static String getAttribute(Element element, String name2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String name[" + name2 + "])");
        }
        if (!element.hasAttribute(name2)) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf10", (String)element.getLocalName(), (String)name2);
        }
        String attrValue = element.getAttribute(name2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute(Element element,String name) returns String [" + attrValue + "]");
        }
        return attrValue;
    }

    public static Element getOneChildElement(Element parent, String ns, String name2) throws SoapSecurityException {
        Element child;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(Element parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        if ((child = DOMUtil.getChildElement(parent, ns, name2)) == null) {
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf03", (String)name2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(Element parent,String ns,String name) retuns Element[" + DOMUtil.getDisplayName(child) + "]");
        }
        return child;
    }

    public static Element getOneChildElement(Element parent, String ns, String[] names) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneChildElement(Element parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String[] names[" + names + "])");
        }
        Element child = null;
        for (int i = 0; i < names.length && (child = DOMUtil.getChildElement(parent, ns, names[i])) == null; ++i) {
        }
        if (child == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(names[i]);
            }
            throw SoapSecurityException.format((String)"security.wssecurity.DOMUtil.sconf11", (String)sb.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneChildElement(Element parent,String ns,String[] names) retuns Element[" + DOMUtil.getDisplayName(child) + "]");
        }
        return child;
    }

    public static Node getNextSibling2(Node node) {
        Node ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextSibling2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        if ((ret = node.getNextSibling()) == null) {
            Node parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() == 5) {
                ret = DOMUtil.getNextSibling2(parent);
            }
        } else {
            while (ret.getNodeType() == 5) {
                Node first = ret.getFirstChild();
                if (first == null) {
                    ret = DOMUtil.getNextSibling2(ret);
                    break;
                }
                ret = first;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextSibling2(Node node) returns Node[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Node getPreviousSibling2(Node node) {
        Node ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreviousSibling2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        if ((ret = node.getPreviousSibling()) == null) {
            Node parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() == 5) {
                ret = DOMUtil.getPreviousSibling2(parent);
            }
        } else {
            while (ret.getNodeType() == 5) {
                Node last = ret.getLastChild();
                if (last == null) {
                    ret = DOMUtil.getPreviousSibling2(ret);
                    break;
                }
                ret = last;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreviousSibling2(Node node) returns Node[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Node getFirstChild2(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstChild2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node ret = node.getFirstChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node first = ret.getFirstChild();
            if (first == null) {
                ret = DOMUtil.getNextSibling2(ret);
                break;
            }
            ret = first;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstChild2(Node node) returns Node[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Node getLastChild2(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastChild2(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node ret = node.getLastChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node last = ret.getLastChild();
            if (last == null) {
                ret = DOMUtil.getPreviousSibling2(ret);
                break;
            }
            ret = last;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastChild2(Node node) returns Node[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Element getFirstElement(Node parent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstElement(Node parent[" + DOMUtil.getDisplayName(parent) + "])");
        }
        Node child = DOMUtil.getFirstChild2(parent);
        while (child != null && child.getNodeType() != 1) {
            child = DOMUtil.getNextSibling2(child);
        }
        Element ret = (Element)child;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstElement(Node parent) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Element getFirstElement(Node parent, String ns, String name2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstElement(Node parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        Node child = DOMUtil.getFirstChild2(parent);
        while (child != null) {
            if (child.getNodeType() == 1) {
                Element el = (Element)child;
                String elns = el.getNamespaceURI();
                if ((name2.equals("*") || el.getLocalName().equals(name2)) && (ns == null && elns == null || ns != null && ns.equals("*") || ns != null && ns.equals(elns))) break;
            }
            child = DOMUtil.getNextSibling2(child);
        }
        Element ret = (Element)child;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstElement(Node parent,String ns,String name) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Element getLastElement(Node parent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastElement(Node parent[" + DOMUtil.getDisplayName(parent) + "])");
        }
        Node child = DOMUtil.getLastChild2(parent);
        while (child != null && child.getNodeType() != 1) {
            child = DOMUtil.getPreviousSibling2(child);
        }
        Element ret = (Element)child;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastElement(Node parent) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Element getLastElement(Node parent, String ns, String name2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastElement(Node parent[" + DOMUtil.getDisplayName(parent) + "]," + "String ns[" + ns + "]," + "String name[" + name2 + "])");
        }
        Node child = DOMUtil.getLastChild2(parent);
        while (child != null) {
            if (child.getNodeType() == 1) {
                Element el = (Element)child;
                String elns = el.getNamespaceURI();
                if ((name2.equals("*") || el.getLocalName().equals(name2)) && (ns == null && elns == null || ns != null && ns.equals("*") || ns != null && ns.equals(elns))) break;
            }
            child = DOMUtil.getPreviousSibling2(child);
        }
        Element ret = (Element)child;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastElement(Node parent,String ns,String name) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static Element getNextElement(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextElement(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        Node next = node;
        while ((next = DOMUtil.getNextSibling2(next)) != null && next.getNodeType() != 1) {
        }
        Element ret = (Element)next;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextElement(Node node) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public static String getStringValue(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringValue(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        String ret = null;
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 9: {
                Node child = node.getFirstChild();
                if (child == null) {
                    ret = "";
                    break;
                }
                if (child == node.getLastChild() && (child.getNodeType() == 3 || child.getNodeType() == 4)) {
                    ret = child.getNodeValue();
                    break;
                }
                StringBuffer buf = new StringBuffer();
                DOMUtil.getStringValue0(node, buf);
                ret = new String(buf);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                ret = node.getNodeValue();
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unexpected node type: " + node.getNodeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringValue(Node node) returns String[" + ret + "]");
        }
        return ret;
    }

    private static void getStringValue0(Node n, StringBuffer buf) {
        switch (n.getNodeType()) {
            case 1: 
            case 5: {
                for (Node ch = n.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
                    DOMUtil.getStringValue0(ch, buf);
                }
                break;
            }
            case 3: 
            case 4: {
                buf.append(n.getNodeValue());
                break;
            }
        }
    }

    public static boolean declareNamespace(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "declareNamespace(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        boolean ret = true;
        String nsdecl = "xmlns";
        if (element.getPrefix() != null) {
            nsdecl = "xmlns:" + element.getPrefix();
        }
        String ns = element.getNamespaceURI();
        for (Node parent = element; parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
            Attr attr = parent.getAttributeNode(nsdecl);
            if (attr == null) continue;
            if (ns == null) {
                if (attr.getNodeValue().length() == 0) {
                    ret = false;
                    break;
                }
                element.setAttributeNS(Constants.NS_XMLNS, nsdecl, "");
                ret = true;
                break;
            }
            if (ns.equals(attr.getNodeValue())) {
                ret = false;
                break;
            }
            element.setAttributeNS(Constants.NS_XMLNS, nsdecl, ns);
            ret = true;
            break;
        }
        if (ns == null) {
            ret = false;
        }
        element.setAttributeNS(Constants.NS_XMLNS, nsdecl, ns);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "declareNamespace(Element element) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static void removeIndentation(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                DOMUtil.removeIndentation((Element)child);
                child = child.getNextSibling();
                continue;
            }
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                Node node = child;
                if (DOMUtil.isAllSpace(child)) {
                    child = child.getNextSibling();
                    element.removeChild(node);
                    continue;
                }
                if (DOMUtil.hasSpace(child)) {
                    DOMUtil.trimSpaces(child);
                    child = child.getNextSibling();
                    continue;
                }
                child = child.getNextSibling();
                continue;
            }
            child = child.getNextSibling();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIndentation(Element element)");
        }
    }

    public static void indent(Element element, int init, int diff) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "indent(Element element[" + DOMUtil.getDisplayName(element) + "]," + "int init[" + init + "]," + "int diff[" + diff + "])");
        }
        int sp = init + diff;
        if (INDENT_NS.contains(element.getNamespaceURI()) && element.hasChildNodes()) {
            element.normalize();
            Document factory = element.getOwnerDocument();
            Node prev = null;
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() == 1) {
                    if (prev == null || prev.getNodeType() != 3) {
                        element.insertBefore(DOMUtil.createTextNode(factory, sp), child);
                    } else if (DOMUtil.isAllSpace(prev)) {
                        element.replaceChild(DOMUtil.createTextNode(factory, sp), prev);
                    }
                    DOMUtil.indent((Element)child, sp, diff);
                }
                prev = child;
            }
            if (prev == null || prev.getNodeType() != 3) {
                element.appendChild(DOMUtil.createTextNode(factory, init));
            } else if (DOMUtil.isAllSpace(prev)) {
                element.replaceChild(DOMUtil.createTextNode(factory, init), prev);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "indent(Element element,int init,int diff)");
        }
    }

    protected static Node createTextNode(Document factory, int spaces) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextNode(Document factory[" + DOMUtil.getDisplayName(factory) + "]," + "int spaces[" + spaces + "])");
        }
        StringBuffer buffer = new StringBuffer(1 + spaces);
        buffer.append("\n");
        for (int i = 0; i < spaces; ++i) {
            buffer.append(" ");
        }
        Text ret = factory.createTextNode(new String(buffer));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTextNode(Document factory,int spaces) returns Node[" + ret + "]");
        }
        return ret;
    }

    protected static boolean isAllSpace(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllSpace(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        boolean ret = true;
        String s = node.getNodeValue();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') continue;
            ret = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllSpace(Node node) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static boolean hasSpace(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSpace(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        boolean ret = false;
        String s = node.getNodeValue();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') continue;
            ret = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSpace(Node node) returns boolean[" + ret + "]");
        }
        return ret;
    }

    protected static void trimSpaces(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trimSpaces(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        boolean ignoreSpace = false;
        String s = node.getNodeValue();
        StringBuffer buffer = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\r' || ch == '\n') {
                ignoreSpace = false;
                continue;
            }
            if (!ignoreSpace && (ch == ' ' || ch == '\t')) continue;
            ignoreSpace = true;
            buffer.append(ch);
        }
        node.setNodeValue(new String(buffer));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trimSpaces(Node node)");
        }
    }

    public static QName getQName(Element element, String qNameStr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String qNameStr[" + qNameStr + "])");
        }
        String nsDecl = null;
        String localPart = null;
        int index = qNameStr.indexOf(":");
        if (index == -1) {
            nsDecl = "xmlns";
            localPart = qNameStr;
        } else {
            nsDecl = "xmlns:" + qNameStr.substring(0, index);
            localPart = qNameStr.substring(index + 1);
        }
        Node n = element;
        String nsURI = "";
        while (n instanceof Element && (nsURI = n.getAttribute(nsDecl)).equals("")) {
            n = n.getParentNode();
        }
        QName ret = new QName(nsURI, localPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName(Element element,String qNameStr) returns QName[" + ret + "]");
        }
        return ret;
    }

    public static void setQNameAttr(Element element, String attrNameNS, String attrName, QName attrValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameAttr(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String attrNameNS[" + attrNameNS + "]," + "String attrName[" + attrName + "]," + "QName attrValue[" + attrValue + "])");
        }
        String strQName = DOMUtil.setQName0(element, attrValue);
        element.setAttributeNS(attrNameNS, attrName, strQName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameAttr(Element element,String attrNameNS,String attrName,QName attrValue)");
        }
    }

    public static void setQNameText(Element element, QName text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setQNameText(Element element[" + DOMUtil.getDisplayName(element) + "]," + "QName text[" + text + "])");
        }
        String strQName = DOMUtil.setQName0(element, text);
        Document doc = element.getOwnerDocument();
        element.appendChild(doc.createTextNode(strQName));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setQNameText(Element element,QName text)");
        }
    }

    private static String setQName0(Element elem, QName qName) {
        String nsURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        Node n = elem;
        String prefix = null;
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (n instanceof Element) {
            NamedNodeMap map = n.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node attr = map.item(i);
                String name2 = attr.getNodeName();
                String value2 = attr.getNodeValue();
                if (!name2.startsWith("xmlns")) continue;
                String tmpPrefix = null;
                int index = name2.indexOf(":");
                tmpPrefix = index == -1 ? "" : name2.substring(index + 1);
                if (value2.equals(nsURI) && prefix == null && !usedPrefixes.contains(tmpPrefix)) {
                    prefix = tmpPrefix;
                }
                usedPrefixes.add(tmpPrefix);
            }
            n = n.getParentNode();
        }
        if (prefix == null) {
            prefix = nsURI != null && nsURI.length() != 0 ? "ns" + nsURI.hashCode() : "ns" + qName.hashCode();
            while (usedPrefixes.contains(prefix)) {
                prefix = "ns" + DOMUtil.makeRandomStr();
            }
            elem.setAttributeNS(Constants.NS_XMLNS, "xmlns:" + prefix, nsURI);
        }
        return prefix.equals("") ? localPart : prefix + ":" + localPart;
    }

    protected static String makeRandomStr() {
        return String.valueOf(Math.abs(new Random().nextLong()));
    }

    public static Element StringToElement(String namespace, String name2, String str) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StringToElement(String namespace[" + namespace + "]," + "String name[" + name2 + "]," + "String str[" + str + "])");
        }
        Element ret = null;
        Document doc = DOMUtil.createDocument();
        Element element = null;
        element = namespace == null || namespace.length() == 0 ? doc.createElement(name2) : doc.createElementNS(namespace, name2);
        Text text = doc.createTextNode(str);
        element.appendChild(text);
        ret = element;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StringToElement(String namespace,String name,String str) returns Element[" + ret + "]");
        }
        return ret;
    }

    public static boolean hasNamespaceDeclaration(Element element, String namespace) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNamespaceDeclaration(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        boolean bl = ret = DOMUtil.getNamespaceDeclaration(element, namespace) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNamespaceDeclaration(Element element,String namespace) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static String getNamespacePrefix(Element element, String namespace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespacePrefix(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        String prefix = null;
        String ns = element.getNamespaceURI();
        if (ns != null && ns.equals(namespace)) {
            prefix = element.getPrefix();
        } else {
            Node parent;
            String s;
            Attr a = DOMUtil.getNamespaceDeclaration(element, namespace);
            if (a != null && !"xmlns".equals(s = a.getLocalName())) {
                prefix = s;
            }
            if (prefix == null && (parent = element.getParentNode()) != null && parent instanceof Element) {
                prefix = DOMUtil.getNamespacePrefix((Element)parent, namespace);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespacePrefix(Element element,String namespace) returns String[" + prefix + "]");
        }
        return prefix;
    }

    public static Attr getNamespaceDeclaration(Element element, String namespace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespaceDeclaration(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        NamedNodeMap aa = element.getAttributes();
        Attr attr = null;
        int l = aa.getLength();
        for (int i = 0; i < l; ++i) {
            Attr a = (Attr)aa.item(i);
            String s = a.getName();
            if (!"xmlns".equals(s) && !s.startsWith("xmlns:") || !namespace.equals(s = a.getValue())) continue;
            attr = a;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespaceDeclaration(Element element,String namespace) returns Attr[" + attr + "]");
        }
        return attr;
    }

    public static Attr removeNamespaceDeclaration(Element element, String namespace) {
        Attr attr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNamespaceDeclaration(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String namespace[" + namespace + "])");
        }
        if ((attr = DOMUtil.getNamespaceDeclaration(element, namespace)) != null) {
            element.removeAttributeNode(attr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNamespaceDeclaration(Element element,String namespace) returns Attr[" + attr + "]");
        }
        return attr;
    }

    public static Collection getEffectiveNamespaceDeclarations(Node node, boolean inclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveNamespaceDeclarations(Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        Collection attrs = null;
        if (node != null) {
            HashMap<String, Attr> m = new HashMap<String, Attr>();
            DOMUtil.getEffectiveAttributes(node, node, inclusive, new String[]{"xmlns", "xmlns:"}, m);
            Document d = node.getOwnerDocument();
            if (node.getNodeType() == 9) {
                d = (Document)node;
            }
            Attr a = d.createAttributeNS(Constants.NS_XMLNS, "xmlns:xml");
            a.setValue("http://www.w3.org/XML/1998/namespace");
            m.put(a.getName(), a);
            attrs = m.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveNamespaceDeclarations(Node node,boolean inclusive) returns Collection[" + attrs + "]");
        }
        return attrs;
    }

    private static void getEffectiveAttributes(Node current, Node start, boolean inclusive, String[] names, Map name2Attr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveAttributes(Node current[" + DOMUtil.getDisplayName(current) + "]," + "Node start[" + DOMUtil.getDisplayName(start) + "]," + "boolean inclusive[" + inclusive + "]," + "String[] names[" + names + "]," + "Map name2Attr)");
        }
        if (com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil.hasParentNode((Node)current)) {
            DOMUtil.getEffectiveAttributes(current.getParentNode(), start, inclusive, names, name2Attr);
        }
        if ((current != start || inclusive) && current.getNodeType() == 1) {
            NamedNodeMap nnm = current.getAttributes();
            int l = nnm.getLength();
            for (int i = 0; i < l; ++i) {
                Attr a = (Attr)nnm.item(i);
                String s = a.getName();
                for (int j = 0; j < names.length; ++j) {
                    String t = names[j];
                    if (t.endsWith(":")) {
                        if (!s.startsWith(t)) continue;
                        name2Attr.put(s, a);
                        continue;
                    }
                    if (!s.equals(t)) continue;
                    name2Attr.put(s, a);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveAttributes(Node current,Node start,boolean inclusive,String[] names,Map name2Attr)");
        }
    }

    public static Collection getEffectiveXMLPrefixedAttributes(Node node, boolean inclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveXMLPrefixedAttributes(Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        Collection attrs = null;
        if (node != null) {
            HashMap m = new HashMap();
            DOMUtil.getEffectiveAttributes(node, node, inclusive, new String[]{"xml:"}, m);
            attrs = m.values();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveXMLPrefixedAttributes(Node node,boolean inclusive) returns Collection[" + attrs + "]");
        }
        return attrs;
    }

    public static Element createDummyElement(Element element, Document factory, Node node, boolean inclusive) {
        Collection c;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(Element element[" + DOMUtil.getDisplayName(element) + "]," + "Document factory[" + DOMUtil.getDisplayName(factory) + "]," + "Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        String s1 = null;
        String s2 = "dummy";
        if (element != null) {
            s1 = element.getNamespaceURI();
            s2 = element.getTagName();
        }
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element dummy = factory.createElementNS(s1, s2);
        if (node != null && (c = DOMUtil.getEffectiveNamespaceDeclarations(node, inclusive)) != null && c.size() > 0) {
            for (Attr a : c) {
                dummy.setAttributeNS(Constants.NS_XMLNS, a.getName(), a.getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(Element element,Document factory,Node node,boolean inclusive) returns Element[" + DOMUtil.getDisplayName(dummy) + "]");
        }
        return dummy;
    }

    public static Element createDummyElement(Document factory, Node node, boolean inclusive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(Document factory[" + DOMUtil.getDisplayName(factory) + "]," + "Node node[" + DOMUtil.getDisplayName(node) + "]," + "boolean inclusive[" + inclusive + "])");
        }
        Element dummy = DOMUtil.createDummyElement(null, factory, node, inclusive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(Document factory,Node node,boolean inclusive) returns Element[" + DOMUtil.getDisplayName(dummy) + "]");
        }
        return dummy;
    }

    public static Element createDummyElement(Document factory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDummyElement(Document factory[" + DOMUtil.getDisplayName(factory) + "])");
        }
        Element dummy = DOMUtil.createDummyElement(null, factory, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDummyElement(Document factory) returns Element[" + dummy + "]");
        }
        return dummy;
    }

    public static String getQualifiedName(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQualifiedName(Node node[" + DOMUtil.getDisplayName(node) + "])");
        }
        String prefix = node.getPrefix();
        String localName = node.getLocalName();
        if (prefix == null) {
            prefix = "";
        } else if (!"".equals(prefix)) {
            prefix = prefix + ":";
        }
        String ret = prefix + localName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQualifiedName(Node node) returns String[" + ret + "]");
        }
        return ret;
    }

    public static String getDisplayName(Node node) {
        return DOMUtil.getDisplayName(node, true);
    }

    public static String getDisplayName(Node node, boolean displayClassname) {
        String ret = null;
        if (node != null) {
            String str0 = displayClassname ? node.getClass().getName() + " --- " : "";
            String str2 = node.getLocalName();
            switch (node.getNodeType()) {
                case 1: {
                    String str1 = node.getNamespaceURI();
                    ret = str0 + "{" + str1 + "}" + str2;
                    break;
                }
                default: {
                    String str1 = node.getNodeName();
                    ret = str2 != null ? str0 + str1 + "::" + str2 : str0 + str1;
                }
            }
        }
        return ret;
    }

    static {
        INDENT_NS.add(Constants.NS_WSSE);
        INDENT_NS.add(Constants.NS_DSIG);
        INDENT_NS.add(Constants.NS_ENC);
        INDENT_NS.add(Constants.NS_WSSE200207);
        INDENT_NS.add(Constants.NS_WSSE200204);
        INDENT_NS.add(Constants.NS_WSU);
        INDENT_NS.add(Constants.NS_WSU200207);
    }

    public static class JarEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveEntity(String publicId[" + publicId + "]," + "String systemId[" + systemId + "])");
            }
            InputSource is = null;
            if (systemId != null) {
                try {
                    String localResourceName = null;
                    int ind = systemId.lastIndexOf(47);
                    localResourceName = ind < 0 ? "config/" + systemId : "config/" + systemId.substring(ind + 1);
                    InputStream in = DOMUtil.class.getClassLoader().getResourceAsStream(localResourceName);
                    if (in == null) {
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(contextLoaderGetter);
                        in = loader == null ? ClassLoader.getSystemResourceAsStream(localResourceName) : loader.getResourceAsStream(localResourceName);
                    }
                    if (in != null) {
                        is = new InputSource(in);
                    }
                }
                catch (Exception e) {
                    Tr.processException(e, clsName + ".resolveEntity", "266");
                    Tr.error(tc, "security.wssecurity.DOMUtil.s02", new Object[]{publicId, systemId, e});
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                String isStr = is == null ? "null" : "not null";
                Tr.entry(tc, "resolveEntity(String publicId,String systemId) returns InputStream[" + isStr + "]");
            }
            return is;
        }
    }
}

