/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.xml.soapsec.util.BasicTraceComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Trace;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class BasicTrace
implements Trace {
    private static PrintStream out = System.err;
    private static DateFormat date = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private ResourceBundle resource = null;

    public TraceComponent register(Class aClass, String group, String resourceBundleName) {
        if (resourceBundleName != null) {
            this.resource = ResourceBundle.getBundle(resourceBundleName);
        }
        return new BasicTraceComponent(aClass);
    }

    public void audit(TraceComponent tc, String msgKey) {
        this.audit(tc, msgKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void audit(TraceComponent tc, String msgKey, Object objs) {
        String text = objs == null ? ConfigUtil.getMessage(msgKey) : (objs instanceof Object[] ? MessageFormat.format(ConfigUtil.getMessage(msgKey), (Object[])objs) : MessageFormat.format(ConfigUtil.getMessage(msgKey), objs));
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(this.getMessage(tc, text));
            out.flush();
        }
    }

    public void error(TraceComponent tc, String msgKey) {
        this.error(tc, msgKey, null);
    }

    public void error(TraceComponent tc, String msgKey, Object objs) {
        if (((BasicTraceComponent)tc).isErrorEnabled()) {
            this.audit(tc, msgKey, objs);
        }
    }

    public void info(TraceComponent tc, String msgKey) {
        this.audit(tc, msgKey, null);
    }

    public void info(TraceComponent tc, String msgKey, Object objs) {
        this.audit(tc, msgKey, objs);
    }

    public void warning(TraceComponent tc, String msgKey) {
        this.warning(tc, msgKey, null);
    }

    public void warning(TraceComponent tc, String msgKey, Object objs) {
        if (((BasicTraceComponent)tc).isWarningEnabled()) {
            this.audit(tc, msgKey, objs);
        }
    }

    public void debug(TraceComponent tc, String msg) {
        this.debug(tc, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(TraceComponent tc, String msg, Object objs) {
        StringBuffer buf = new StringBuffer(msg);
        if (objs != null) {
            if (objs instanceof Object[]) {
                Object[] array = (Object[])objs;
                for (int i = 0; i < array.length; ++i) {
                    buf.append(", ");
                    buf.append(array[i]);
                }
            } else {
                buf.append(objs);
            }
        }
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(this.getMessage(tc, buf.toString()));
            out.flush();
        }
    }

    public void entry(TraceComponent tc, String msg) {
        this.debug(tc, msg, null);
    }

    public void entry(TraceComponent tc, String msg, Object objs) {
        this.debug(tc, msg, objs);
    }

    public void exit(TraceComponent tc, String msg) {
        this.debug(tc, msg, null);
    }

    public void exit(TraceComponent tc, String msg, Object objs) {
        this.debug(tc, msg, objs);
    }

    private String getMessage(TraceComponent tc, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(date.format(new Date()));
        buf.append("] ");
        buf.append(((BasicTraceComponent)tc).getClassName());
        buf.append(": ");
        buf.append(message);
        return buf.toString();
    }
}

