/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluatorException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.LoginResult;
import com.ibm.xml.soapsec.token.ReceiverLoginComponent;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.token.UserRegistry;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReceiverLogin
implements ReceiverLoginComponent {
    private static final TraceComponent tc = Tr.register(ReceiverLogin.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = ReceiverLogin.class.getName();
    private static final String comp = "security.wssecurity";
    protected TokenReceiverConfig conf = null;
    protected SignatureReceiverConfig sconf = null;
    protected String currentRealm = null;

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(TokenReceiverConfig.class);
        this.sconf = (SignatureReceiverConfig)map.get(SignatureReceiverConfig.class);
        this.currentRealm = UserRegistry.getInstance().getRealm();
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        if (this.conf == null) {
            String wsseSent = Constants.getWSSENS(context);
            throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "InvalidSecurity"), (String)"security.wssecurity.ReceiverLogin.token01");
        }
        String idType = this.conf.getIdType();
        String trustMode = this.conf.getTrustMode();
        LinkedList authMethods = this.conf.getAuthMethods();
        if (authMethods == null) {
            authMethods = new LinkedList();
        }
        Subject subject = null;
        String tokenId = null;
        boolean skipSign = false;
        Iterator iter = authMethods.iterator();
        String authMethodList = null;
        while (iter.hasNext()) {
            String authMethod = (String)iter.next();
            authMethodList = authMethodList == null ? new String(authMethod) : authMethodList + ", " + authMethod;
            if (authMethod.equals("IDAssertion")) {
                Result[] userResults;
                int i;
                TokenResult tResult = null;
                if (idType.equals("X509Certificate")) {
                    Result[] x509Results = ResultPool.get(context, TokenResult.X509.class);
                    for (i = 0; i < x509Results.length; ++i) {
                        TokenResult.X509 x509Result = (TokenResult.X509)x509Results[i];
                        if (x509Result.getUsed()) continue;
                        subject = ReceiverLogin.login(this.conf.getLoginMapping("IDAssertion"), this.getSecurityName(x509Result.getCertificate()), null, null, context);
                        tokenId = x509Result.getIdName();
                        tResult = x509Result;
                        x509Result.setAuthenticatedId();
                        break;
                    }
                } else {
                    userResults = ResultPool.get(context, TokenResult.Username.class);
                    for (i = 0; i < userResults.length; ++i) {
                        TokenResult.Username userResult = (TokenResult.Username)userResults[i];
                        if (!userResult.isIdAssertion()) continue;
                        subject = userResult.getSubject();
                        tokenId = userResult.getIdName();
                        tResult = userResult;
                        break;
                    }
                }
                if ("BasicAuth".equals(trustMode)) {
                    userResults = ResultPool.get(context, TokenResult.Username.class);
                    boolean trusted = false;
                    for (int i2 = 0; i2 < userResults.length; ++i2) {
                        TokenResult.Username userResult = (TokenResult.Username)userResults[i2];
                        if (userResult.isIdAssertion() || !this.validateId(userResult.getUsername())) continue;
                        trusted = true;
                        break;
                    }
                    if (!trusted) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token35");
                    }
                } else if ("Signature".equals(trustMode)) {
                    Result[] sigResults = ResultPool.get(context, SignatureResult.class);
                    if (sigResults.length <= 0) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token03");
                    }
                    String id = tResult.getIdName();
                    if (id == null) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token05");
                    }
                    boolean trusted = false;
                    for (int i3 = 0; i3 < sigResults.length; ++i3) {
                        SignatureResult sigResult = (SignatureResult)sigResults[i3];
                        String securityName = this.getSecurityName(sigResult.getCertificate());
                        if (!sigResult.isSigned(id) || !this.validateId(securityName)) continue;
                        trusted = true;
                        break;
                    }
                    if (!trusted) {
                        throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token06");
                    }
                }
                if (subject != null) {
                    Subject loginSubject = null;
                    ContextManager ctxMgr = ContextManagerFactory.getInstance();
                    String uname = null;
                    Map map = this.conf.getLoginMapping("IDAssertion").getProperties();
                    if (map == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "properties is null.");
                        }
                    } else {
                        Set keys = map.keySet();
                        if (keys == null || keys.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CallerConfig's properties has no entry.");
                            }
                        } else {
                            for (String key : keys) {
                                if (!"LoginUsername".equals(key)) continue;
                                uname = (String)map.get(key);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Extracted Username", uname);
                        }
                    }
                    if (ctxMgr == null) {
                        Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
                    } else {
                        try {
                            loginSubject = ctxMgr.login(this.currentRealm, uname);
                        }
                        catch (WSLoginFailedException e) {
                            Tr.processException((Throwable)e, clsName + ".login", "236", this);
                            throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token11", (Throwable)e);
                        }
                        this.addToSubject(loginSubject, subject);
                    }
                }
            } else if (authMethod.equals("BasicAuth")) {
                Result[] userResults = ResultPool.get(context, TokenResult.Username.class);
                for (int i = 0; i < userResults.length; ++i) {
                    TokenResult.Username userResult = (TokenResult.Username)userResults[i];
                    if (userResult.isIdAssertion()) continue;
                    subject = userResult.getSubject();
                    tokenId = userResult.getIdName();
                    break;
                }
            } else if (authMethod.equals("Signature")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authMethod is Signature.");
                }
                Result[] sigResults = ResultPool.get(context, SignatureResult.class);
                String uname = null;
                for (int i = 0; i < sigResults.length; ++i) {
                    SignatureResult sigResult = (SignatureResult)sigResults[i];
                    if (!sigResult.getCompliance()) continue;
                    uname = this.getSecurityName(sigResult.getCertificate());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling Signature login module, uname is " + uname);
                    }
                    subject = ReceiverLogin.login(this.conf.getLoginMapping("Signature"), uname, null, null, context);
                    if (tc.isDebugEnabled()) {
                        if (subject == null) {
                            Tr.debug(tc, "Subject returned from Signature login module is null.");
                        } else {
                            Tr.debug(tc, "Subject returned from Signature login module is not null.");
                        }
                    }
                    skipSign = true;
                    sigResult.setAuthenticatedId();
                    break;
                }
                if (subject != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authMethod is Signature, subject is not null, uname is " + uname);
                    }
                    Subject loginSubject = null;
                    ContextManager ctxMgr = ContextManagerFactory.getInstance();
                    if (ctxMgr == null) {
                        Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "about to do context manager login. realm is " + this.currentRealm + ", uname is " + uname);
                        }
                        try {
                            loginSubject = ctxMgr.login(this.currentRealm, uname);
                        }
                        catch (WSLoginFailedException e) {
                            Tr.processException((Throwable)e, clsName + ".login", "307", this);
                            throw SoapSecurityException.format((String)"security.wssecurity.ReceiverLogin.token11", (Throwable)e);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Context manager login successful. About to add credentials and principal to subject.");
                        }
                        this.addToSubject(loginSubject, subject);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authMethod is Signature, subject is null");
                }
            } else {
                int i = 0;
                Result[] genResults = ResultPool.get(context, TokenResult.Generic.class);
                if (i < genResults.length) {
                    TokenResult.Generic genResult = (TokenResult.Generic)genResults[i];
                    subject = genResult.getSubject();
                    tokenId = genResult.getIdName();
                }
            }
            if (subject == null) continue;
            break;
        }
        if (authMethods.size() != 0) {
            if (subject == null) {
                Tr.error(tc, "security.wssecurity.WSEC5207E", new Object[]{authMethodList});
                String wsseSent = Constants.getWSSENS(context);
                throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "FailedAuthentication"), (String)"security.wssecurity.ReceiverLogin.token07");
            }
            if (!skipSign && this.sconf.getRequiredIntegralParts().contains("securitytoken")) {
                boolean signed = false;
                Result[] sresults = ResultPool.get(context, SignatureResult.class);
                for (int i = 0; i < sresults.length; ++i) {
                    SignatureResult sigres = (SignatureResult)sresults[i];
                    if (!sigres.isSigned(tokenId)) continue;
                    signed = true;
                    break;
                }
                if (!signed) {
                    String wsseSent = Constants.getWSSENS(context);
                    throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "FailedCheck"), (String)"security.wssecurity.ReceiverLogin.unsigned");
                }
            }
            ResultPool.add(context, new LoginResult(subject));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    private void addToSubject(final Subject loginSubject, final Subject subject) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Object publicObject : loginSubject.getPublicCredentials()) {
                    if (publicObject == null) continue;
                    if (!subject.getPublicCredentials().contains(publicObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding public object to Subject: " + publicObject);
                        }
                        subject.getPublicCredentials().add(publicObject);
                        continue;
                    }
                    Tr.error(tc, "Public credential already exists within subject");
                }
                for (Object privateObject : loginSubject.getPrivateCredentials()) {
                    if (privateObject == null) continue;
                    if (!subject.getPrivateCredentials().contains(privateObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding private object to Subject: " + privateObject);
                        }
                        subject.getPrivateCredentials().add(privateObject);
                        continue;
                    }
                    Tr.error(tc, "Private credential already exists within subject");
                }
                for (Principal principalObject : loginSubject.getPrincipals()) {
                    if (principalObject == null) continue;
                    if (!subject.getPrincipals().contains(principalObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding principal object to Subject: " + principalObject);
                        }
                        subject.getPrincipals().add(principalObject);
                        continue;
                    }
                    Tr.error(tc, "Principal already exists within subject");
                }
                return null;
            }
        });
    }

    protected boolean validateId(String id) {
        try {
            return this.conf.getTrustedIDEvaluator().evaluate(id);
        }
        catch (TrustedIDEvaluatorException tiee) {
            Tr.processException(tiee, clsName + ".validateId", "265");
            Tr.error(tc, "security.wssecurity.ReceiverLogin.trust", (Object)tiee);
            return false;
        }
    }

    static Subject login(LoginMapping mapping, Object token, Document message, char[] password, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(" + mapping + "," + token + "," + "XXXXXX" + "," + context + ")");
        }
        CallbackHandlerFactory factory = mapping.getCallbackHandlerFactory();
        if (token instanceof byte[]) {
            factory.setTokenBytes((byte[])token);
        } else if (token instanceof Element) {
            factory.setXMLToken((Element)token);
            factory.setSOAPMessage(message);
        } else {
            factory.setUsername((String)token);
            factory.setPassword(password);
        }
        factory.setProperties(mapping.getProperties());
        CallbackHandler handler2 = factory.newCallbackHandler();
        LoginContext lcontext = null;
        try {
            lcontext = new LoginContext(mapping.getConfigName(), handler2);
        }
        catch (LoginException le) {
            String msgKey = "security.wssecurity.ReceiverLogin.token10";
            Tr.processException(le, clsName + ".login", "300");
            Tr.error(tc, msgKey, le);
            String wsseSent = Constants.getWSSENS(context);
            throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "InvalidSecurity"), (String)msgKey, (String)le.toString());
        }
        try {
            lcontext.login();
        }
        catch (LoginException le) {
            String msgKey_client = "security.wssecurity.ReceiverLogin.token11";
            String msgKey_server = "security.wssecurity.WSEC5201E";
            Tr.processException(le, clsName + ".login", "315");
            Tr.error(tc, msgKey_server, le);
            String wsseSent = Constants.getWSSENS(context);
            throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "FailedAuthentication"), (String)msgKey_client, (String)le.toString());
        }
        Subject subject = lcontext.getSubject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(LoginMapping mapping, Object token, char[] password) returns " + subject);
        }
        return subject;
    }

    private String getSecurityName(final X509Certificate cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName", cert);
        }
        String mappedName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String name2 = UserRegistry.getInstance().mapCertificate(cert);
                return name2;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mappedName: " + mappedName);
        }
        if (mappedName == null || mappedName.length() == 0) {
            mappedName = cert.getSubjectDN().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mappedName is null, so used the DN in the certificate: " + mappedName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName returns " + mappedName);
        }
        return mappedName;
    }
}

