/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryTokenSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(BinaryTokenSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";

    public void init(Map map) throws Exception {
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        Request[] requests = RequestPool.get(context, TokenRequest.Binary.class);
        for (int i = 0; i < requests.length; ++i) {
            BinaryTokenSender.insertBST(doc, target, context, (TokenRequest.Binary)requests[i]);
            RequestPool.remove(context, requests[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    private static void insertBST(Document doc, Element target, Map context, TokenRequest.Binary request) throws SoapSecurityException {
        QName encodingType;
        String prefix = target.getPrefix();
        prefix = prefix == null || prefix.length() == 0 ? "" : prefix + ":";
        String wsseSent = Constants.getWSSENS(context);
        String wsuSent = Constants.getWSUNS(context);
        Element binarySecurityToken = doc.createElementNS(wsseSent, prefix + "BinarySecurityToken");
        target.insertBefore(binarySecurityToken, target.getFirstChild());
        target.insertBefore(doc.createTextNode("\n      "), binarySecurityToken);
        String id = request.getIdName();
        if (id != null && !id.equals("")) {
            BinaryTokenSender.addIdAttribute(binarySecurityToken, id, wsseSent, wsuSent);
        } else if (request.getSignature()) {
            id = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_binary_security_token_id_");
            BinaryTokenSender.addIdAttribute(binarySecurityToken, id, wsseSent, wsuSent);
        }
        if (request.getSignature()) {
            RequestPool.add(context, new SignatureRequest(id));
        }
        if ((encodingType = request.getEncoding()) == null) {
            encodingType = Constants.getQName(wsseSent, "Base64Binary");
        }
        DOMUtil.setQNameAttr(binarySecurityToken, null, "EncodingType", encodingType);
        QName valueType = request.getType();
        if (valueType != null) {
            DOMUtil.setQNameAttr(binarySecurityToken, null, "ValueType", valueType);
        }
        byte[] binaryData = request.getContent();
        String stringValue = null;
        if (!NamespaceUtil.equals(encodingType, Constants.getQName(wsseSent, "Base64Binary"))) {
            if (NamespaceUtil.equals(encodingType, Constants.getQName(wsseSent, "HexBinary"))) {
                throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "InvalidSecurity"), (String)"security.wssecurity.BinaryTokenReceiver.token14");
            }
            throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "InvalidSecurity"), (String)"security.wssecurity.BinaryTokenReceiver.token15", (String)encodingType.toString());
        }
        stringValue = Base64.format((String)Base64.encode((byte[])binaryData), (int)8, (String)"\n", (String)"      ");
        binarySecurityToken.appendChild(doc.createTextNode(stringValue));
    }

    static void addIdAttribute(Element el, String id, String wsseNSSent, String wsuNSSent) {
        if (wsseNSSent == Constants.NS_WSSE200204) {
            el.setAttributeNS(null, "Id", id);
        } else {
            el.setAttributeNS(wsuNSSent, "wsu:Id", id);
            el.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", wsuNSSent);
        }
    }
}

