/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.time;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.time.TimestampSenderConfig;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimestampSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(TimestampSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampSender.class.getName();
    SenderConfig gconfig;
    TimestampSenderConfig config;

    public void init(Map map) throws Exception {
        this.gconfig = (SenderConfig)map.get(SenderConfig.class);
        this.config = (TimestampSenderConfig)map.get(TimestampSenderConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        Element timestamp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        if ((timestamp = NamespaceUtil.getFirstChildWsuElement(target, "Timestamp")) == null) {
            if (this.config.addCreatedTimestamp()) {
                this.addCreated(doc, target, context);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
            }
            return;
        }
        if (this.config.addCreatedTimestamp()) {
            throw SoapSecurityException.format((String)"security.wssecurity.TimestampSender.time03");
        }
        Element tstrace = NamespaceUtil.getFirstChildWsuElement(target, "TimestampTrace");
        Element received = null;
        Node n = DOMUtil.getLastChild2(tstrace);
        while (n != null) {
            if (n.getNodeType() == 1 && NamespaceUtil.isWsu(n.getNamespaceURI()) && "Received".equals(n.getLocalName())) {
                received = (Element)n;
                if (received.getAttribute("Role").equals(this.config.getMyActor())) break;
                received = null;
            }
            n = DOMUtil.getPreviousSibling2(n);
        }
        if (received == null) {
            if (this.config.signTimestamp()) {
                throw SoapSecurityException.format((String)"security.wssecurity.TimestampSender.time04");
            }
        } else {
            Date recdate;
            if (this.config.signTimestamp()) {
                String id = NamespaceUtil.getWsuAttribute(received, "Id");
                if (id == null) {
                    id = IdUtil.getInstance().makeUniqueId(doc, "tsr_");
                    String qname = "Id";
                    if (received.getPrefix() != null) {
                        qname = received.getPrefix() + ":Id";
                    }
                    received.setAttributeNS(received.getNamespaceURI(), qname, id);
                }
                RequestPool.add(context, new SignatureRequest(id));
            }
            try {
                recdate = UTC.parse(DOMUtil.getStringValue(received));
            }
            catch (ParseException pe) {
                String msgKey = "security.wssecurity.TimestampReceiver.parse";
                Tr.processException((Throwable)pe, clsName + ".invoke", "139", this);
                Tr.error(tc, msgKey, pe);
                throw SoapSecurityException.format((String)msgKey, (String)pe.toString(), (Throwable)pe);
            }
            long delay = System.currentTimeMillis() - recdate.getTime();
            received.setAttributeNS(null, "Delay", Long.toString(delay));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void addCreated(Document factory, Element header2, Map context) {
        Date now = new Date();
        String ns = Constants.getWSUNS(context);
        String prefix = "wsu";
        Element timestamp = factory.createElementNS(ns, "wsu:Timestamp");
        timestamp.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", ns);
        if (this.config.signTimestamp()) {
            String id = IdUtil.getInstance().makeUniqueId(factory, "ts_");
            timestamp.setAttributeNS(ns, "wsu:Id", id);
            RequestPool.add(context, new SignatureRequest(id));
        }
        if (this.config.addCreatedTimestamp()) {
            String dt = UTC.format(now);
            Element created = factory.createElementNS(ns, "wsu:Created");
            created.appendChild(factory.createTextNode(dt));
            timestamp.appendChild(created);
        }
        if (this.config.getDuration() != null) {
            Duration duration = this.config.getDuration();
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            duration.addTo(cal);
            String dt = UTC.format(cal.getTime());
            Element expires = factory.createElementNS(ns, "wsu:Expires");
            expires.appendChild(factory.createTextNode(dt));
            timestamp.appendChild(expires);
        }
        header2.insertBefore(timestamp, header2.getFirstChild());
        if (this.gconfig.doIndentation()) {
            header2.insertBefore(factory.createTextNode("\n    "), timestamp);
            DOMUtil.indent(timestamp, 4, 2);
        }
    }
}

