/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.proxy;

import com.ibm.ws.webservices.engine.Message;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.proxy.ProxyBase;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPPartProxy;
import com.ibm.xml.soapsec.util.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WASMessageProxyImpl
extends MessageProxy {
    private Message message;

    public WASMessageProxyImpl(Object initialContents) {
        try {
            this.message = initialContents instanceof String || initialContents instanceof InputStream ? new Message(initialContents) : (initialContents instanceof FaultProxy ? new Message(((FaultProxy)initialContents).get()) : (initialContents instanceof Message ? (Message)initialContents : new Message(initialContents)));
        }
        catch (Throwable th) {
            ProxyBase.processException(th);
        }
    }

    public Object get() {
        return this.message;
    }

    public SOAPEnvelopeProxy getSOAPEnvelope() throws FaultProxy {
        try {
            return SOAPEnvelopeProxy.getInstance(this.message.getSOAPEnvelope());
        }
        catch (Throwable th) {
            ProxyBase.throwException(th);
            return null;
        }
    }

    public SOAPPartProxy getSOAPPart() {
        try {
            return SOAPPartProxy.getInstance(this.message.getSOAPPart());
        }
        catch (Throwable th) {
            ProxyBase.processException(th);
            return null;
        }
    }

    public Document getDocument() throws FaultProxy {
        try {
            SOAPPartProxy part = this.getSOAPPart();
            String origMsg = part.getOriginalMessage();
            if (origMsg != null && origMsg.length() > 0) {
                return DOMUtil.parse(new InputSource(new ByteArrayInputStream(origMsg.getBytes("UTF-8"))), false);
            }
            byte[] bytes = part.getAsBytes();
            return DOMUtil.parse(new InputSource(new ByteArrayInputStream(bytes)), false);
        }
        catch (Throwable th) {
            ProxyBase.throwException(th);
            return null;
        }
    }

    public String getCharEncoding() {
        String charEnc = null;
        if (!ProxyBase.axis) {
            try {
                charEnc = this.message.getCharacterEncoding();
            }
            catch (Throwable th) {
                ProxyBase.processException(th);
            }
            if (charEnc == null) {
                charEnc = "UTF-8";
            }
        } else {
            charEnc = "UTF-8";
        }
        return charEnc;
    }
}

