/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.proxy;

import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.proxy.AxisFaultProxyImpl;
import com.ibm.xml.soapsec.proxy.ProxyBase;
import com.ibm.xml.soapsec.proxy.WASFaultProxyImpl;
import java.io.BufferedWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class FaultProxy
extends Exception {
    private static final String FAULT_NS = "http://websphere.ibm.com/webservices/";

    public static FaultProxy getInstance() {
        FaultProxy inst = null;
        inst = ProxyBase.axis ? new AxisFaultProxyImpl() : new WASFaultProxyImpl();
        return inst;
    }

    public static FaultProxy getInstance(Exception fault2) {
        FaultProxy inst = null;
        inst = ProxyBase.axis ? new AxisFaultProxyImpl(fault2) : new WASFaultProxyImpl(fault2);
        return inst;
    }

    public static FaultProxy getInstance(QName code, String str, String actor, Element[] details) {
        FaultProxy inst = null;
        inst = ProxyBase.axis ? new AxisFaultProxyImpl(code, str, actor, details) : new WASFaultProxyImpl(code, str, actor, details);
        return inst;
    }

    public static FaultProxy makeFault(Throwable t) {
        if (t instanceof SoapSecurityException) {
            SoapSecurityException sse = (SoapSecurityException)t;
            if (sse.getFaultCode() != null) {
                try {
                    Element[] details = new Element[]{};
                    return FaultProxy.getInstance(sse.getFaultCode(), sse.getMessage(), null, details);
                }
                catch (Throwable th) {
                    ProxyBase.processException(th);
                }
            } else if (sse.getCauseException() != null) {
                t = sse.getCauseException();
            }
        }
        try {
            if (!ProxyBase.axis || t instanceof Exception) {
                WebServicesFault f = null;
                f = WebServicesFault.makeFault(t);
                return FaultProxy.getInstance(f);
            }
            ProxyBase.processException(t);
        }
        catch (Throwable th) {
            ProxyBase.processException(th);
        }
        return null;
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public abstract Exception get();

    public abstract void printStackTrace();

    public abstract void printStackTrace(PrintStream var1);

    public abstract void printStackTrace(PrintWriter var1);
}

