/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.proxy;

import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.proxy.ProxyBase;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPPartProxy;
import com.ibm.xml.soapsec.util.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AxisMessageProxyImpl
extends MessageProxy {
    private Object message;
    private static Constructor constructor;
    private static Method getSOAPEnvelope;
    private static Method getSOAPPart;
    private static Method getCharacterEncoding;
    static Class cls;

    public AxisMessageProxyImpl(Object initialContents) {
        try {
            this.message = initialContents instanceof String || initialContents instanceof InputStream ? constructor.newInstance(initialContents) : (initialContents instanceof FaultProxy ? constructor.newInstance(((FaultProxy)initialContents).get()) : initialContents);
        }
        catch (Throwable th) {
            ProxyBase.processException(th);
        }
    }

    public Object get() {
        return this.message;
    }

    public SOAPEnvelopeProxy getSOAPEnvelope() throws FaultProxy {
        try {
            Object ret = getSOAPEnvelope.invoke(this.message, null);
            return SOAPEnvelopeProxy.getInstance(ret);
        }
        catch (Throwable th) {
            ProxyBase.throwException(th);
            return null;
        }
    }

    public SOAPPartProxy getSOAPPart() {
        try {
            Object ret = getSOAPPart.invoke(this.message, null);
            return SOAPPartProxy.getInstance(ret);
        }
        catch (Throwable th) {
            ProxyBase.processException(th);
            return null;
        }
    }

    public Document getDocument() throws FaultProxy {
        try {
            SOAPPartProxy part = this.getSOAPPart();
            String origMsg = part.getOriginalMessage();
            if (origMsg != null && origMsg.length() > 0) {
                return DOMUtil.parse(new InputSource(new ByteArrayInputStream(origMsg.getBytes("UTF-8"))), false);
            }
            byte[] bytes = part.getAsBytes();
            return DOMUtil.parse(new InputSource(new ByteArrayInputStream(bytes)), false);
        }
        catch (Throwable th) {
            ProxyBase.throwException(th);
            return null;
        }
    }

    public String getCharEncoding() {
        String charEnc = null;
        if (!ProxyBase.axis) {
            try {
                charEnc = (String)getCharacterEncoding.invoke(this.message, null);
            }
            catch (Throwable th) {
                ProxyBase.processException(th);
            }
            if (charEnc == null) {
                charEnc = "UTF-8";
            }
        } else {
            charEnc = "UTF-8";
        }
        return charEnc;
    }

    static {
        try {
            cls = Class.forName("org.apache.axis.Message");
            constructor = cls.getConstructor(Object.class);
            getSOAPEnvelope = cls.getMethod("getSOAPEnvelope", null);
            getSOAPPart = cls.getMethod("getSOAPPart", null);
            getCharacterEncoding = cls.getMethod("getCharacterEncoding", null);
        }
        catch (Throwable th) {
            ProxyBase.processException(th);
        }
    }
}

