/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.enc;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyName;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyIdentifierKeyResolver
extends KeyInfoResolverBase {
    private static final TraceComponent tc = Tr.register(KeyIdentifierKeyResolver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyIdentifierKeyResolver.class.getName();
    private KeyLocator fKeyLocator;
    private Map fId2Name;
    private Map fId602Name;
    private boolean sender = false;
    private QName _ITSHA1 = null;
    private QName _IT60SHA1 = null;
    private QName _BASE64_BINARY = null;
    private QName _HEX_BINARY = null;
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;

    KeyIdentifierKeyResolver(KeyLocator locator, int operationMode, Map context, boolean sender) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyIdentifierKeyResolver(" + locator + "," + operationMode + ")");
        }
        super.setOperationMode(operationMode);
        this.fKeyLocator = locator;
        this.fId2Name = new HashMap();
        this.fId602Name = new HashMap();
        this.sender = sender;
        String wsseNSSent = Constants.getWSSENS(context);
        if (this.sender) {
            this._ITSHA1 = Constants.getQName(wsseNSSent, "ITSHA1");
            this._IT60SHA1 = Constants.getQName(wsseNSSent, "IT60SHA1");
            this._BASE64_BINARY = Constants.getQName(wsseNSSent, "Base64Binary");
            this._HEX_BINARY = Constants.getQName(wsseNSSent, "HexBinary");
        } else {
            this._ITSHA1 = Constants.ITSHA1_RCVR;
            this._IT60SHA1 = Constants.IT60SHA1_RCVR;
            this._BASE64_BINARY = Constants.BASE64_BINARY_RCVR;
            this._HEX_BINARY = Constants.HEX_BINARY_RCVR;
        }
        for (String name2 : locator.getNames((Object)context)) {
            Certificate cert = null;
            try {
                cert = locator.getCertificate(name2);
            }
            catch (KeyLocatorException e) {
                // empty catch block
            }
            if (cert == null) continue;
            byte[] id = KeyIdentifierKeyResolver.makeIdentifier(cert, this._ITSHA1, wsseNSSent);
            this.fId2Name.put(Base64.encode((byte[])id), name2);
            id = KeyIdentifierKeyResolver.makeIdentifier(cert, this._IT60SHA1, wsseNSSent);
            this.fId602Name.put(Base64.encode((byte[])id), name2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KeyIdentifierKeyResolver(KeyLocator locator, int operationMode)");
        }
    }

    private boolean isSecurityTokenReference(Element elem) {
        boolean tokenRef;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityTokenReference(" + elem + ")");
        }
        boolean bl = tokenRef = NamespaceUtil.isWsse(elem.getNamespaceURI()) && "SecurityTokenReference".equals(elem.getLocalName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityTokenReference(Element elem) returns " + tokenRef);
        }
        return tokenRef;
    }

    /*
     * Unable to fully structure code
     */
    private Key resolveSecurityTokenReference(Element tokenRef) throws KeyInfoResolvingException {
        if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
            Tr.entry(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(" + tokenRef + ")");
        }
        if ((kid = NamespaceUtil.getFirstChildWsseElement(tokenRef, "KeyIdentifier")) == null) {
            Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.resolveSecurityTokenReference.nokid");
            if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
                Tr.exit(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(Element tokenRef) returns null");
            }
            return null;
        }
        idty = this._ITSHA1;
        encoding = this._BASE64_BINARY;
        idtystr = kid.getAttribute("IdentifierType");
        if (idtystr.length() > 0) {
            idty = DOMUtil.getQName(kid, idtystr);
        }
        if ((encodingstr = kid.getAttribute("EncodingType")).length() > 0) {
            encoding = DOMUtil.getQName(kid, encodingstr);
        }
        if (this._BASE64_BINARY.equals(encoding)) {
            identifier = Base64.decode((String)DOMUtil.getStringValue(kid));
        } else if (this._HEX_BINARY.equals(encoding)) {
            try {
                identifier = Hex.decode(DOMUtil.getStringValue(kid));
            }
            catch (ParseException pe) {
                Tr.processException((Throwable)pe, KeyIdentifierKeyResolver.clsName + ".resolveSecurityTokenReference", "154", (Object)this);
                Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.resolveSecurityTokenReference.decode", pe);
                if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
                    Tr.exit(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(Element tokenRef) returns null");
                }
                return null;
            }
        } else {
            throw new IllegalArgumentException("Internal Error: " + encoding);
        }
        key = null;
        if (this.fInEncryptMode) {
            itsha1 = true;
            if (!this._ITSHA1.equals(idty)) {
                if (this._IT60SHA1.equals(idty)) {
                    itsha1 = false;
                } else {
                    throw new IllegalArgumentException("Internal Error: " + idty);
                }
            }
            id = Base64.encode((byte[])identifier);
            try {
                v0 = name = itsha1 != false ? (String)this.fId2Name.get(id) : (String)this.fId602Name.get(id);
                if (name == null) ** GOTO lbl63
                key = this.fKeyLocator.getEncryptionKey(name, null);
            }
            catch (KeyLocatorException e) {
                Tr.processException((Throwable)e, KeyIdentifierKeyResolver.clsName + ".resolveSecurityTokenReference", "186", (Object)this);
                Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)e);
                throw new KeyInfoResolvingException(e.getMessage());
            }
        } else {
            itsha1 = true;
            if (!this._ITSHA1.equals(idty)) {
                if (this._IT60SHA1.equals(idty)) {
                    itsha1 = false;
                } else {
                    throw new IllegalArgumentException("Internal Error: " + idty);
                }
            }
            id = Base64.encode((byte[])identifier);
            try {
                v1 = name = itsha1 != false ? (String)this.fId2Name.get(id) : (String)this.fId602Name.get(id);
                if (name != null) {
                    key = this.fKeyLocator.getDecryptionKey(name, null);
                }
            }
            catch (KeyLocatorException e) {
                Tr.processException((Throwable)e, KeyIdentifierKeyResolver.clsName + ".resolveSecurityTokenReference", "210", (Object)this);
                Tr.error(KeyIdentifierKeyResolver.tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)e);
                throw new KeyInfoResolvingException(e.getMessage());
            }
        }
lbl63:
        // 3 sources

        if (KeyIdentifierKeyResolver.tc.isEntryEnabled()) {
            Tr.exit(KeyIdentifierKeyResolver.tc, "resolveSecurityTokenReference(Element tokenRef) returns " + key);
        }
        return key;
    }

    private static byte[] certToIdentifier(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        byte[] der = ((X509Certificate)cert).getExtensionValue(OID_KEYIDENTIFIER);
        if (der == null) {
            return null;
        }
        byte[] ki = new byte[der.length - 4];
        System.arraycopy(der, 4, ki, 0, der.length - 4);
        return ki;
    }

    private static byte[] pubkeyToIdentifier(Certificate cert, QName idty, String wsseNSSent) throws NoSuchAlgorithmException, SoapSecurityException {
        byte[] bits;
        byte[] key = cert.getPublicKey().getEncoded();
        MessageDigest digester = MessageDigest.getInstance("SHA");
        if (key[0] != 48) {
            throw new RuntimeException("Unknown encoded key: " + Hex.encode(key));
        }
        int len = key[1] & 0xFF;
        int offset = (len & 0x80) == 0 ? 2 : 2 + (len & 0x7F);
        len = key[offset + 1] & 0xFF;
        if ((len & 0x80) == 0) {
            offset += 2;
        } else {
            int lenoff = offset + 2;
            offset += 2 + (len & 0x7F);
            switch (len & 0x7F) {
                case 1: {
                    len = key[lenoff] & 0xFF;
                    break;
                }
                case 2: {
                    len = ((key[lenoff] & 0xFF) << 8) + (key[lenoff + 1] & 0xFF);
                    break;
                }
                case 3: {
                    len = ((key[lenoff] & 0xFF) << 16) + ((key[lenoff + 1] & 0xFF) << 8) + (key[lenoff + 2] & 0xFF);
                    break;
                }
                case 4: {
                    len = ((key[lenoff] & 0xFF) << 24) + ((key[lenoff + 1] & 0xFF) << 16) + ((key[lenoff + 2] & 0xFF) << 8) + (key[lenoff + 3] & 0xFF);
                    break;
                }
                default: {
                    throw new RuntimeException("Integer overflow: " + Hex.encode(key));
                }
            }
        }
        if (key[offset += len] != 3) {
            throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(key[offset] & 0xFF, 16));
        }
        offset += ((len = key[offset + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (len & 0x7F);
        if (idty == null || NamespaceUtil.equals(idty, Constants.getQName(wsseNSSent, "ITSHA1")) || NamespaceUtil.equals(idty, Constants.ITSHA1_RCVR)) {
            digester.update(key, offset, key.length - offset);
            bits = digester.digest();
        } else if (NamespaceUtil.equals(idty, Constants.getQName(wsseNSSent, "IT60SHA1")) || NamespaceUtil.equals(idty, Constants.IT60SHA1_RCVR)) {
            digester.update(key, offset, key.length - offset);
            byte[] digest = digester.digest();
            bits = new byte[8];
            bits[0] = (byte)(64 + (digest[digest.length - 8] & 0xF));
            System.arraycopy(digest, digest.length - 8 + 1, bits, 1, bits.length - 1);
        } else {
            throw new IllegalArgumentException("Internal Error: " + idty);
        }
        return bits;
    }

    private static byte[] makeIdentifier(Certificate cert, QName idty, String wsseNSSent) throws NoSuchAlgorithmException, SoapSecurityException {
        byte[] bits;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeIdentifier(" + cert + "," + idty + ")");
        }
        if ((bits = KeyIdentifierKeyResolver.certToIdentifier(cert)) == null || idty != null) {
            if (idty == null || NamespaceUtil.equals(idty, Constants.getQName(wsseNSSent, "ITSHA1")) || NamespaceUtil.equals(idty, Constants.ITSHA1_RCVR)) {
                if (bits == null || bits.length != 20) {
                    bits = KeyIdentifierKeyResolver.pubkeyToIdentifier(cert, idty, wsseNSSent);
                }
            } else if (NamespaceUtil.equals(idty, Constants.getQName(wsseNSSent, "IT60SHA1")) || NamespaceUtil.equals(idty, Constants.IT60SHA1_RCVR)) {
                if (bits == null || bits.length != 8) {
                    bits = KeyIdentifierKeyResolver.pubkeyToIdentifier(cert, idty, wsseNSSent);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + idty);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeIdentifier(KeyStore store, String alias, QName idty) returns " + bits);
        }
        return bits;
    }

    static void addKeyId(KeyInfo keyInfo, KeyLocator locator, String name2, Document factory, QName idty, QName encoding, Object context) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKeyId(" + keyInfo + "," + locator + "," + name2 + "," + factory + "," + idty + "," + encoding + "," + context + ")");
        }
        Key key = locator.getEncryptionKey(name2, context);
        boolean added = false;
        if (key == null) {
            throw new NullPointerException("Key not located: " + name2);
        }
        if (key instanceof PublicKey) {
            Certificate cert = locator.getCertificate(key);
            if (cert != null) {
                Map map = (Map)context;
                Element tokenRef = KeyIdentifierKeyResolver.createElement(factory, cert, idty, encoding, Constants.getWSSENS(map));
                keyInfo.addKeyId(tokenRef);
                added = true;
            }
        } else {
            String name22 = locator.getName(key);
            if (name22 != null) {
                KeyName keyName = new KeyName();
                keyName.setName(name22);
                keyInfo.addKeyName(keyName);
                added = true;
            }
        }
        if (!added) {
            throw new RuntimeException("Key id not added: " + name2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKeyId(KeyInfo keyInfo, KeyLocator locator, String name, Document factory, QName idty, QName encoding, Object context)");
        }
    }

    private static Element createElement(Document factory, Certificate cert, QName idty, QName encoding, String wsseNSSent) throws NoSuchAlgorithmException, SoapSecurityException {
        String content;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createElement(" + factory + "," + cert + "," + idty + "," + encoding + ")");
        }
        byte[] bits = KeyIdentifierKeyResolver.makeIdentifier(cert, idty, wsseNSSent);
        if (encoding == null || NamespaceUtil.equals(encoding, Constants.getQName(wsseNSSent, "Base64Binary")) || NamespaceUtil.equals(encoding, Constants.BASE64_BINARY_RCVR)) {
            content = Base64.encode((byte[])bits);
        } else if (NamespaceUtil.equals(encoding, Constants.getQName(wsseNSSent, "HexBinary")) || NamespaceUtil.equals(encoding, Constants.HEX_BINARY_RCVR)) {
            content = Hex.encode(bits);
        } else {
            throw new IllegalArgumentException("Internal Error: " + idty);
        }
        Element kid = factory.createElementNS(wsseNSSent, "wsse:KeyIdentifier");
        kid.appendChild(factory.createTextNode(content));
        Element str = factory.createElementNS(wsseNSSent, "wsse:SecurityTokenReference");
        str.appendChild(kid);
        str.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", wsseNSSent);
        if (bits.length != 20) {
            DOMUtil.setQNameAttr(kid, null, "IdentifierType", Constants.getQName(wsseNSSent, "IT60SHA1"));
        }
        if (encoding != null) {
            DOMUtil.setQNameAttr(kid, null, "EncodingType", encoding);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created KeyInfo for (cert) " + cert + " and (content) " + content);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createElement(Document factory, Certificate cert, QName idty, QName encoding) returns " + str);
        }
        return str;
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveKeyName(" + keyName + "," + encMeth + "," + key + ")");
        }
        if (key == null) {
            String name2 = keyName.getName();
            if (this.fInEncryptMode) {
                try {
                    key = this.fKeyLocator.getEncryptionKey(name2, null);
                }
                catch (KeyLocatorException e) {
                    Tr.processException((Throwable)e, clsName + ".resolveKeyName", "455", (Object)this);
                    Tr.error(tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)e);
                    throw new KeyInfoResolvingException(e.getMessage());
                }
            }
            try {
                key = this.fKeyLocator.getDecryptionKey(name2, null);
            }
            catch (KeyLocatorException e) {
                Tr.processException((Throwable)e, clsName + ".resolveKeyName", "464", (Object)this);
                Tr.error(tc, "security.wssecurity.KeyIdentifierKeyResolver.keyloc", (Object)e);
                throw new KeyInfoResolvingException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) returns " + key);
        }
        return key;
    }

    protected Key resolveKeyId(Element keyId, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveKeyId(" + keyId + "," + encMeth + "," + key + ")");
        }
        if (key == null && this.isSecurityTokenReference(keyId)) {
            key = this.resolveSecurityTokenReference(keyId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveKeyId(Element keyId, EncryptionMethod encMeth, Key key) returns " + key);
        }
        return key;
    }
}

