/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.enc;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.enc.EncryptionRequest;
import com.ibm.xml.soapsec.enc.EncryptionSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.enc.KeyIdentifierKeyResolver;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EncryptionSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(EncryptionSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private EncryptionSenderConfig fConfig;

    private Map createEncryptionSettingsToRequestsMap(Set parts, EncryptionSettings settings, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptionSettingsToRequestsMap(" + parts + "," + settings + "," + context + ")");
        }
        for (String part : parts) {
            if (part.equals("bodycontent")) {
                RequestPool.add(context, new EncryptionRequest(settings));
                continue;
            }
            if (part.equals("usernametoken")) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionSender.enc03", (String)part);
        }
        Request[] requests = RequestPool.get(context, EncryptionRequest.class);
        HashMap settings2Reqs = new HashMap();
        for (int i = 0; i < requests.length; ++i) {
            EncryptionRequest request = (EncryptionRequest)requests[i];
            EncryptionSettings settings2 = request.getEncryptionSettings();
            if (!settings2Reqs.containsKey(settings2)) {
                settings2Reqs.put(settings2, new ArrayList());
            }
            List requests2 = (List)settings2Reqs.get(settings2);
            requests2.add(request);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptionSettingsToRequestsMap(Set parts, EncryptionSettings settings, Map context) returns " + settings2Reqs);
        }
        return settings2Reqs;
    }

    private EncryptionContext createEncryptionContext(KeyLocator locator, Map ccontext) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptionContext(" + locator + ")");
        }
        EncryptionContext context = new EncryptionContext();
        context.setAlgorithmFactory(AlgorithmFactory.getInstance());
        context.setKeyInfoResolver((KeyInfoResolver)new KeyIdentifierKeyResolver(locator, 1, ccontext, true));
        if (tc.isDebugEnabled()) {
            context.setResourceShower((ResourceShower)ShowerImpl.getInstance());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptionContext(KeyLocator locator) returns " + context);
        }
        return context;
    }

    private boolean isKeyGenerated(EncryptionSettings settings) {
        boolean keyGen;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyGenerated(" + settings + ")");
        }
        boolean bl = keyGen = settings.getKeyEncryptionMethod() != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyGenerated(EncryptionSettings settings) returns " + keyGen);
        }
        return keyGen;
    }

    private EncryptedData createEncryptedData(EncryptionSettings settings, boolean keyGen, KeyLocator locator, Document factory, Object context) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedData(" + settings + "," + keyGen + "," + locator + "," + factory + "," + context + ")");
        }
        EncryptedData encData = new EncryptedData();
        this.setEncryptionMethod((EncryptedType)encData, settings.getDataEncryptionMethod());
        if (!keyGen) {
            this.setKeyInfo((EncryptedType)encData, settings.getKeyName(), locator, factory, context);
        }
        this.setCipherData((EncryptedType)encData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedData(EncryptionSettings settings, boolean keyGen, KeyLocator locator,  Document factory, Object context) returns " + encData);
        }
        return encData;
    }

    private void setEncryptionMethod(EncryptedType encType, String algorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(" + encType + "," + algorithm + ")");
        }
        EncryptionMethod encMeth = new EncryptionMethod();
        encMeth.setAlgorithm(algorithm);
        encType.setEncryptionMethod(encMeth);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(EncryptedType encType, String algorithm)");
        }
    }

    private void setKeyInfo(EncryptedType encType, String name2, KeyLocator locator, Document factory, Object context) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyInfo(" + encType + "," + name2 + "," + locator + "," + factory + "," + context + ")");
        }
        KeyInfo keyInfo = new KeyInfo();
        KeyIdentifierKeyResolver.addKeyId(keyInfo, locator, name2, factory, null, null, context);
        encType.setKeyInfo(keyInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyInfo(EncryptedType encType, String name, KeyLocator locator, Document factory, Object context)");
        }
    }

    private void setCipherData(EncryptedType encType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCipherData(" + encType + ")");
        }
        CipherValue ciphVal = new CipherValue();
        CipherData ciphData = new CipherData();
        ciphData.setCipherValue(ciphVal);
        encType.setCipherData(ciphData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCipherData(EncryptedType encType)");
        }
    }

    private Key generateKey(EncryptionContext context, EncryptedData encData, Document factory) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKey(" + context + "," + encData + "," + factory + ")");
        }
        context.setEncryptedType(encData.createElement(factory, true), null, null, null);
        Key key = context.generateKey();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKey(EncryptionContext context, EncryptedData encData, Document factory) returns " + key);
        }
        return key;
    }

    private List encryptData(List requests, EncryptionContext context, EncryptedData encData, Document doc) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, SoapSecurityException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptData(" + requests + "," + context + "," + encData + "," + doc + ")");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (EncryptionRequest request : requests) {
            String id = this.encryptData(request, context, encData, doc);
            ids.add(0, id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptData(List requests, EncryptionContext context, EncryptedData encData, Document doc) returns " + ids);
        }
        return ids;
    }

    private String encryptData(EncryptionRequest request, EncryptionContext context, EncryptedData encData, Document doc) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, SoapSecurityException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptData(" + request + "," + context + "," + encData + "," + doc + ")");
        }
        Element data = null;
        String type = "http://www.w3.org/2001/04/xmlenc#Element";
        String id = null;
        if (request.isBodyContent()) {
            NodeList nl = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (nl.getLength() <= 0) {
                throw SoapSecurityException.format((String)"security.wssecurity.EncryptionSender.enc02");
            }
            data = (Element)nl.item(0);
            type = "http://www.w3.org/2001/04/xmlenc#Content";
        } else {
            id = request.getId();
            if (id != null) {
                data = IdUtil.getInstance().resolveID(doc, id);
                if (data == null) {
                    throw SoapSecurityException.format((String)"security.wssecurity.EncryptionSender.enc08", (String)id);
                }
                if (request.isContentOnly()) {
                    type = "http://www.w3.org/2001/04/xmlenc#Content";
                }
            }
        }
        id = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_encryption_id_");
        encData.setId(id);
        encData.setType(type);
        this.encryptData(data, context, encData.createElement(doc, true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptData(EncryptionRequest request, EncryptionContext context, EncryptedData encData, Document doc) returns " + id);
        }
        return id;
    }

    private void encryptData(Element elem, EncryptionContext context, Element encData) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptData(" + elem + "," + context + "," + encData + ")");
        }
        context.setData(elem);
        context.setEncryptedType(encData, null, null, null);
        context.encrypt();
        context.replace();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptData(Element elem, EncryptionContext context, Element encData)");
        }
    }

    private EncryptedKey createEncryptedKey(EncryptionSettings settings, KeyLocator locator, Document factory, List ids, Object context) throws KeyLocatorException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedKey(" + settings + "," + locator + "," + factory + "," + ids + "," + context + ")");
        }
        EncryptedKey encKey = new EncryptedKey();
        this.setEncryptionMethod((EncryptedType)encKey, settings.getKeyEncryptionMethod());
        this.setKeyInfo((EncryptedType)encKey, settings.getKeyName(), locator, factory, context);
        this.setCipherData((EncryptedType)encKey);
        encKey.setReferenceList(this.createReferenceList(ids));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedKey(EncryptionSettings settings, KeyLocator locator, Document factory, List ids, Object context) returns " + encKey);
        }
        return encKey;
    }

    private void encryptKey(Key key, EncryptionContext context, Element encKey) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(" + key + "," + context + "," + encKey + ")");
        }
        context.setData(key);
        context.setEncryptedType(encKey, null, null, null);
        context.encrypt();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptKey(Key key, EncryptionContext context, Element encKey)");
        }
    }

    private ReferenceList createReferenceList(List ids) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createReferenceList(" + ids + ")");
        }
        ReferenceList refList = new ReferenceList();
        for (String id : ids) {
            DataReference dataRef = new DataReference();
            dataRef.setURI("#" + id);
            refList.addDataReference(dataRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReferenceList(List ids) returns " + refList);
        }
        return refList;
    }

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.fConfig = (EncryptionSenderConfig)map.get(EncryptionSenderConfig.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document doc, Element target, Map context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        Map keycontext = context;
        Set parts = this.fConfig.getConfidentialParts();
        EncryptionSettings settings = this.fConfig.getEncryptionSettings();
        Map settings2Reqs = this.createEncryptionSettingsToRequestsMap(parts, settings, context);
        KeyLocator locator = settings.getKeyLocator();
        EncryptionContext encCont = this.createEncryptionContext(locator, context);
        if (settings2Reqs.containsKey(settings)) {
            boolean keyGen = this.isKeyGenerated(settings);
            EncryptedData encData = this.createEncryptedData(settings, keyGen, locator, doc, keycontext);
            encCont.setKey(null);
            Key key = null;
            if (keyGen) {
                key = this.generateKey(encCont, encData, doc);
            }
            List requests = (List)settings2Reqs.get(settings);
            List ids = this.encryptData(requests, encCont, encData, doc);
            Element elem = null;
            if (keyGen) {
                EncryptedKey encKey = this.createEncryptedKey(settings, locator, doc, ids, keycontext);
                elem = encKey.createElement(doc, true);
                encCont.setKey(null);
                this.encryptKey(key, encCont, elem);
            } else {
                ReferenceList refList = this.createReferenceList(ids);
                elem = refList.createElement(doc, true);
            }
            target.insertBefore(elem, target.getFirstChild());
            target.insertBefore(doc.createTextNode("\n      "), elem);
            DOMUtil.indent(elem, 6, 2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] content, Object data, Element encType) {
            String dumpData = null;
            try {
                dumpData = EncryptedData.isOfType((Element)encType) ? new String(content, "UTF-8") : Base64.encode((byte[])content);
            }
            catch (Exception e) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType((Element)encType)) {
                Tr.debug(tc, "ResourceShower logs encrypt-" + encType.getAttribute("Id") + ": " + dumpData);
            } else {
                Tr.debug(tc, "ResourceShower logs encrypt-EncryptedKey: " + dumpData);
            }
        }
    }
}

