/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.dsig;

import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.KeyInfoResolver;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.dsig.VerificationResult;
import com.ibm.xml.soapsec.dsig.VerificationResultHandler;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.token.BinaryTokenReceiver;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureReceiver
implements SoapSecurityComponent {
    SignatureReceiverConfig config;
    TokenReceiverConfig tconfig;
    private IdUtil idResolver;
    private static final String[] ELEMENTS_TO_BE_CHECKED = new String[]{"CanonicalizationMethod", "SignatureMethod", "DigestMethod", "Transform"};
    private static final TraceComponent tc = Tr.register(SignatureReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureReceiver.class.getName();

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.config = (SignatureReceiverConfig)map.get(SignatureReceiverConfig.class);
        this.tconfig = (TokenReceiverConfig)map.get(TokenReceiverConfig.class);
        this.idResolver = IdUtil.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document doc, Element target, Map context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        boolean succeeded = false;
        Exception lastException = null;
        List settingsList = this.config.getVerificationSettingsList();
        Iterator iter = settingsList.iterator();
        while (iter.hasNext()) {
            try {
                this.invoke0(doc, target, context, (VerificationSettings)iter.next());
                succeeded = true;
                break;
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".invoke", "104", this);
                lastException = e;
            }
        }
        if (!succeeded) {
            throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.dsig21", lastException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void invoke0(Document doc, Element target, Map context, VerificationSettings settings) throws Exception {
        VerificationResult result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke0(" + doc + "," + target + "," + context + "," + settings + ")");
        }
        try {
            X509Certificate cert = this.verify(target, context, settings);
            result = new VerificationResult(context, target, cert);
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".invoke", "126", this);
            Tr.error(tc, "security.wssecurity.SignatureReceiver.invoke", (Object)e);
            result = new VerificationResult(context, target, e);
        }
        this.callVerificationResultHandlers(result);
        if (!result.getResult()) {
            throw result.getReason();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke0(Document doc, Element target, Map context, VerificationSettings settings)");
        }
    }

    private void callVerificationResultHandlers(VerificationResult result) throws SoapSecurityException {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callVerificationResultHandlers(" + result + ")");
        }
        if ((list = this.config.getVerificationResultHandlers()).isEmpty()) {
            SoapSecurityException reason = result.getReason();
            if (reason != null) {
                throw reason;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "callVerificationResultHandlers(VerificationResult result)");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((VerificationResultHandler)iterator.next()).verificationDone(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callVerificationResultHandlers(VerificationResult result)");
        }
    }

    private X509Certificate verify(Element sig, Map context, VerificationSettings settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify(" + sig + "," + context + settings + ")");
        }
        this.checkAlgorithms(sig, settings, context);
        Set certs = this.checkCertpathValidity(sig, context, settings);
        SignatureResult result = this.analyzeSignedParts(sig, settings);
        X509Certificate usedCert = this.checkCoreValidity(sig, certs);
        if (usedCert != null) {
            result.setCertificate(usedCert);
            ResultPool.add(context, result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verify(Element sig, Map context, VerificationSettings settings) returns " + usedCert);
        }
        return usedCert;
    }

    private SignatureResult analyzeSignedParts(Element sig, VerificationSettings settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "analyzeSignedParts(" + sig + "," + settings + ")");
        }
        SignatureResult result = new SignatureResult();
        Element ref = null;
        Element signed_info = DOMUtil.getFirstElement(sig, Constants.NS_DSIG, "SignedInfo");
        if (signed_info != null) {
            ref = DOMUtil.getFirstElement(signed_info);
        }
        while (ref != null) {
            if (Constants.NS_DSIG.equals(ref.getNamespaceURI()) && "Reference".equals(ref.getLocalName())) {
                String uri = ref.getAttribute("URI");
                if (ref.getAttributeNode("URI") == null) {
                    throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.dsig03");
                }
                if (uri.equals("")) {
                    Element e = DOMUtil.getFirstElement(ref, Constants.NS_DSIG, "Transforms");
                    if (e == null) {
                        Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig04", uri);
                    } else if ((e = DOMUtil.getFirstElement(e)) == null) {
                        Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig04", uri);
                    } else {
                        String alg = e.getAttribute("Algorithm");
                        if (!alg.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                            Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig05", new Object[]{uri, alg});
                        } else {
                            String xpathexp = DOMUtil.getStringValue(DOMUtil.getFirstElement(e, Constants.NS_DSIG, "XPath"));
                            if (!xpathexp.equals("count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::*) = count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::* | .)")) {
                                Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig06", xpathexp);
                            } else if ((e = DOMUtil.getNextElement(e)) != null && !settings.getC14nMethod().equals(e.getAttribute("Algorithm"))) {
                                Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig05", new Object[]{uri, alg});
                            } else {
                                result.setBodySigned(true);
                            }
                        }
                    }
                } else if (uri.length() < 2 || uri.charAt(0) != '#') {
                    Tr.error(tc, "security.wssecurity.SignatureReceiver.dsig07", uri);
                } else {
                    boolean onlyc14n = true;
                    Element transform = null;
                    Element transforms = DOMUtil.getFirstElement(ref, Constants.NS_DSIG, "Transforms");
                    if (transforms != null) {
                        transform = DOMUtil.getFirstElement(transforms);
                    }
                    while (transform != null) {
                        if (Constants.NS_DSIG.equals(transform.getNamespaceURI()) && "Transform".equals(transform.getLocalName()) && !settings.getC14nMethod().equals(transform.getAttribute("Algorithm"))) {
                            onlyc14n = false;
                            break;
                        }
                        transform = DOMUtil.getNextElement(transform);
                    }
                    if (onlyc14n) {
                        result.addSignedId(uri.substring(1));
                    }
                }
            }
            ref = DOMUtil.getNextElement(ref);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "analyzeSignedParts(Element sig, VerificationSettings settings) returns " + result);
        }
        return result;
    }

    private X509Certificate checkCoreValidity(Element sig, Set certs) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCoreValidity(" + sig + "," + certs + ")");
        }
        Element keyInfo = KeyInfo.searchForKeyInfo((Element)sig);
        Iterator iterator = this.config.getKeyInfoResolvers().iterator();
        while (iterator.hasNext()) {
            ((KeyInfoResolver)iterator.next()).resolve(keyInfo);
        }
        iterator = certs.iterator();
        String errMsg = null;
        while (iterator.hasNext()) {
            X509Certificate cert = (X509Certificate)iterator.next();
            PublicKey key = cert.getPublicKey();
            errMsg = this.verify(sig, key);
            if (errMsg != null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCoreValidity(Element sig, Set certs) returns " + cert);
            }
            return cert;
        }
        throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.dsig22", errMsg);
    }

    private String verify(Element sig, Key key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify(" + sig + "," + key + ")");
        }
        SignatureContext context = new SignatureContext();
        if (tc.isDebugEnabled()) {
            context.setResourceShower((ResourceShower)ShowerImpl.getInstance());
        }
        if (this.idResolver != null) {
            context.setIDResolver((IDResolver)this.idResolver);
        }
        Validity validity = context.verify(sig, key);
        boolean coreValidity = validity.getCoreValidity();
        String errMsg = null;
        if (!coreValidity || tc.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Core validity=");
            buf.append(coreValidity);
            buf.append(" Signed info validity=");
            buf.append(validity.getSignedInfoValidity());
            buf.append(" Signed info message='");
            buf.append(validity.getSignedInfoMessage());
            buf.append("'");
            int count = validity.getNumberOfReferences();
            for (int i = 0; i < count; ++i) {
                buf.append(" Ref[");
                buf.append(i);
                buf.append("](validity=");
                buf.append(validity.getReferenceValidity(i));
                buf.append(" message='");
                buf.append(validity.getReferenceMessage(i));
                buf.append("' uri='");
                buf.append(validity.getReferenceURI(i));
                buf.append("' type='");
                buf.append(validity.getReferenceType(i));
                buf.append("')");
            }
            errMsg = buf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, errMsg);
            }
            if (coreValidity) {
                errMsg = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verify(Element sig, Key key) returns " + errMsg);
        }
        return errMsg;
    }

    private void parseTokenReference(Set certs, Node tokenref, Map context, VerificationSettings settings) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseTokenReference(" + certs + "," + tokenref + "," + context + "," + settings + ")");
        }
        Element ref = DOMUtil.getFirstElement(tokenref);
        while (ref != null) {
            block7: {
                TokenResult.X509 bst;
                String id;
                block9: {
                    Element bstElem;
                    block8: {
                        id = null;
                        bst = null;
                        if (!NamespaceUtil.isWsse(ref.getNamespaceURI())) break block7;
                        if (!"Reference".equals(ref.getLocalName())) break block8;
                        String uri = ref.getAttribute("URI");
                        if (uri == null || uri.length() < 1) break block7;
                        if (!uri.startsWith("#")) {
                            String wsseNSSent = Constants.getWSSENS(context);
                            throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "SecurityTokenUnavailable"), (String)"security.wssecurity.SignatureReceiver.dsig09", (String)uri);
                        }
                        id = uri.substring(1);
                        break block9;
                    }
                    if ("Embedded".equals(ref.getLocalName()) && (bstElem = NamespaceUtil.getFirstChildWsseElement(ref, "BinarySecurityToken")) != null) {
                        BinaryTokenReceiver bstReceiver = new BinaryTokenReceiver(this.tconfig);
                        bstReceiver.invoke(bstElem.getOwnerDocument(), bstElem, context);
                    }
                }
                Result[] results = ResultPool.get(context, TokenResult.X509.class);
                for (int j = 0; j < results.length; ++j) {
                    boolean sameStore;
                    bst = (TokenResult.X509)results[j];
                    String setAnchor = settings.getTrustAnchorRef();
                    String setStore = settings.getCertStoreRef();
                    String bstAnchor = bst.getTrustAnchorRef();
                    String bstStore = bst.getCertStoreRef();
                    boolean bothTrustAny = settings.getTrustAnyCertificate() && bst.getTrustAnyCertificate();
                    boolean sameAnchor = setAnchor != null && setAnchor.equals(bstAnchor);
                    boolean bl = sameStore = setStore != null && setStore.equals(bstStore) || setStore == null && bstStore == null;
                    if ((id == null || id.equals(bst.getIdName())) && (bothTrustAny || sameAnchor && sameStore)) break;
                    bst = null;
                }
                if (bst == null) {
                    String wsseNSSent = Constants.getWSSENS(context);
                    throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "SecurityTokenUnavailable"), (String)"security.wssecurity.SignatureReceiver.dsig10", (String)(id == null ? "<Embedded>" : id));
                }
                bst.setUsed(true);
                certs.add(bst.getCertificate());
            }
            ref = DOMUtil.getNextElement(ref);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseTokenReference(Set certs, Node tokenref, Map context, VerificationSettings settings)");
        }
    }

    private Set checkCertpathValidity(Element sig, Map context, VerificationSettings settings) throws SoapSecurityException {
        CertificateUtil.X509DataUtil[] utils;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCertpathValidity(" + sig + "," + context + "," + settings + ")");
        }
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        Element keyInfoElement = KeyInfo.searchForKeyInfo((Element)sig);
        if (keyInfoElement != null) {
            NodeList list = NamespaceUtil.getWsseElementsByTagName(keyInfoElement, "SecurityTokenReference");
            for (int i = 0; i < list.getLength(); ++i) {
                this.parseTokenReference(certs, list.item(i), context, settings);
            }
        }
        if (settings.getTrustAnyCertificate()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCertpathValidity(Element sig, Map context)");
            }
            return certs;
        }
        try {
            utils = CertificateUtil.getX509Data(sig);
        }
        catch (XSignatureException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to retreive valid X.509 data (should be embedded in BST) from Signature element.", new Object[]{e});
            }
            utils = new CertificateUtil.X509DataUtil[]{};
        }
        if (utils.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling CertificateUtil.verify()");
            }
            PKIXBuilderParameters params = (PKIXBuilderParameters)settings.getPKIXBuilderParameters().clone();
            HashSet certSet = settings.getEeCerts();
            if (certSet == null) {
                certSet = new HashSet();
            }
            Provider provider = settings.getCertPathProvider();
            CertStore store = null;
            try {
                store = provider == null ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(certSet)) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certSet), provider);
            }
            catch (Exception e) {
                throw new SoapSecurityException((Throwable)e);
            }
            params.addCertStore(store);
            for (int i = 0; i < utils.length; ++i) {
                try {
                    X509CertSelector selector = utils[i].createSelector();
                    Date date = new Date();
                    selector.setCertificateValid(date);
                    params.setDate(date);
                    params.setTargetCertConstraints(selector);
                    certs.add(utils[i].validateAndGetCert(params));
                    continue;
                }
                catch (XSignatureException e) {
                    Tr.processException((Throwable)e, clsName + ".checkCertpathValidity", "503", this);
                    Tr.error(tc, "security.wssecurity.SignatureReceiver.exception", (Object)e);
                    continue;
                }
                catch (IOException e) {
                    Tr.processException((Throwable)e, clsName + ".checkCertpathValidity", "507", this);
                    Tr.error(tc, "security.wssecurity.SignatureReceiver.exception", e);
                }
            }
        }
        if (!certs.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCertpathValidity(Element sig, Map context, VerificationSettings settings) returns " + certs);
            }
            return certs;
        }
        throw SoapSecurityException.format((String)"security.wssecurity.SignatureReceiver.s28", (Throwable)new Exception());
    }

    private void checkAlgorithms(Element sig, VerificationSettings settings, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAlgorithms(" + sig + "," + settings + "," + context + ")");
        }
        for (int i = 0; i < ELEMENTS_TO_BE_CHECKED.length; ++i) {
            this.checkAlgorithm(sig, i, settings, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAlgorithms(Element, VerificationSettings, Map");
        }
    }

    private void checkAlgorithm(Element sig, int index, VerificationSettings settings, Map context) throws SoapSecurityException {
        NodeList list = sig.getElementsByTagNameNS(Constants.NS_DSIG, ELEMENTS_TO_BE_CHECKED[index]);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element elem = (Element)list.item(i);
            String algorithm = elem.getAttribute("Algorithm");
            boolean exception = false;
            if (index == 0) {
                if (!settings.getC14nMethod().equals(algorithm)) {
                    exception = true;
                }
            } else if (index == 1) {
                if (!settings.getSignatureMethod().equals(algorithm)) {
                    exception = true;
                }
            } else if (index == 2) {
                if (!settings.getDigestMethod().equals(algorithm)) {
                    exception = true;
                }
            } else if (index == 3 && !this.config.getAllowedTransforms().contains(algorithm)) {
                exception = true;
            }
            if (!exception) continue;
            String wsseNSSent = Constants.getWSSENS(context);
            throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "UnsupportedAlgorithm"), (String)"security.wssecurity.SignatureReceiver.s26", (String)algorithm, (String)ELEMENTS_TO_BE_CHECKED[index]);
        }
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(Element owner, int count, String uri, String type, byte[] content, String encoding) {
            String dumpData = null;
            try {
                dumpData = encoding == null ? new String(content, "UTF-8") : new String(content, encoding);
            }
            catch (Exception e) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [" + encoding + "].");
            }
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: " + dumpData);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + count + ": " + dumpData);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + uri + ": " + dumpData);
            }
        }
    }
}

