/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.confimpl;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.dsig.KeyInfoResolver;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.VerificationResultHandler;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.enc.EncryptionReceiverConfig;
import com.ibm.xml.soapsec.time.TimestampReceiverConfig;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PrivateReceiverConfig
implements ReceiverConfig {
    private static final TraceComponent tc = Tr.register(PrivateReceiverConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PrivateReceiverConfig.class.getName();
    protected String myactor = null;
    protected boolean _bypassSecurityHeader = false;
    protected final Set requiredIntegralParts = new HashSet();
    protected final Set allowedTransforms = new HashSet();
    protected final List defaultVerificationKeys = new LinkedList();
    protected final List keyInfoResolvers = new LinkedList();
    protected final List verificationResultHandlers = new LinkedList();
    protected final List verificationSettingsList = new LinkedList();
    protected final SignatureReceiverConfig signatureReceiverConfig = new SignatureReceiverConfig(){

        public Set getRequiredIntegralParts() {
            return PrivateReceiverConfig.this.requiredIntegralParts;
        }

        public Set getAllowedTransforms() {
            return PrivateReceiverConfig.this.allowedTransforms;
        }

        public List getDefaultVerificationKeys() {
            return PrivateReceiverConfig.this.defaultVerificationKeys;
        }

        public List getKeyInfoResolvers() {
            return PrivateReceiverConfig.this.keyInfoResolvers;
        }

        public List getVerificationResultHandlers() {
            return PrivateReceiverConfig.this.verificationResultHandlers;
        }

        public List getVerificationSettingsList() {
            return PrivateReceiverConfig.this.verificationSettingsList;
        }

        public String toString() {
            return "SignatureReceiverConfig(requiredIntegralParts=" + PrivateReceiverConfig.this.requiredIntegralParts + " defaultVerificationKeys=" + PrivateReceiverConfig.this.defaultVerificationKeys + " keyInfoResolvers=" + PrivateReceiverConfig.this.keyInfoResolvers + " verificationResultHandlers=" + PrivateReceiverConfig.this.verificationResultHandlers + " verificationSettingsList=" + PrivateReceiverConfig.this.verificationSettingsList + ")";
        }
    };
    protected final List authMethods = new LinkedList();
    protected String idType = null;
    protected String trustMode = null;
    protected final Map am2lm = new HashMap();
    protected final Map tvt2lm = new HashMap();
    protected TrustedIDEvaluator trustedIDEvaluator = null;
    protected boolean checkNonce = false;
    protected NonceManager nonceManager = null;
    protected boolean checkNonceTimestamp = false;
    protected long nonceMaxAge = -1L;
    protected long nonceClockSkew = -1L;
    protected Map _properties = null;
    protected final TokenReceiverConfig tokenReceiverConfig = new TokenReceiverConfig(){

        public List getAuthMethods() {
            return PrivateReceiverConfig.this.authMethods;
        }

        public String getIdType() {
            return PrivateReceiverConfig.this.idType;
        }

        public String getTrustMode() {
            return PrivateReceiverConfig.this.trustMode;
        }

        public LoginMapping getLoginMapping(String authMethod) {
            if (PrivateReceiverConfig.this.am2lm.containsKey(authMethod)) {
                return (LoginMapping)PrivateReceiverConfig.this.am2lm.get(authMethod);
            }
            return null;
        }

        public LoginMapping getLoginMapping(QName tokenValueType) {
            if (PrivateReceiverConfig.this.tvt2lm.containsKey(tokenValueType)) {
                return (LoginMapping)PrivateReceiverConfig.this.tvt2lm.get(tokenValueType);
            }
            return null;
        }

        public TrustedIDEvaluator getTrustedIDEvaluator() {
            return PrivateReceiverConfig.this.trustedIDEvaluator;
        }

        public List getVerificationSettingsList() {
            return PrivateReceiverConfig.this.verificationSettingsList;
        }

        public boolean isX509Ready() {
            return PrivateReceiverConfig.this.verificationSettingsList.size() > 0;
        }

        public boolean isNonceChecked() {
            return PrivateReceiverConfig.this.checkNonce;
        }

        public NonceManager getNonceManager() {
            return PrivateReceiverConfig.this.nonceManager;
        }

        public boolean isNonceTimestampChecked() {
            return PrivateReceiverConfig.this.checkNonceTimestamp;
        }

        public long getNonceMaxAge() {
            return PrivateReceiverConfig.this.nonceMaxAge;
        }

        public long getNonceClockSkew() {
            return PrivateReceiverConfig.this.nonceClockSkew;
        }

        public String toString() {
            return "TokenReceiverConfig(authMethods=" + PrivateReceiverConfig.this.authMethods + " idType=" + PrivateReceiverConfig.this.idType + " trustMode=" + PrivateReceiverConfig.this.trustMode + " loginMappings=" + PrivateReceiverConfig.this.am2lm + " trustedIDEvaluator=" + PrivateReceiverConfig.this.trustedIDEvaluator + " verificationSettingsList=" + PrivateReceiverConfig.this.verificationSettingsList + " isNonceChecked=" + PrivateReceiverConfig.this.checkNonce + " nonceManager=" + PrivateReceiverConfig.this.nonceManager + " isNonceTimestampChecked=" + PrivateReceiverConfig.this.checkNonceTimestamp + " nonceMaxAge=" + PrivateReceiverConfig.this.nonceMaxAge + " nonceClockSkew=" + PrivateReceiverConfig.this.nonceClockSkew + ")";
        }
    };
    protected final Set requiredConfidentialParts = new HashSet();
    protected final List encryptionSettingsList = new LinkedList();
    protected EncryptionReceiverConfig encryptionReceiverConfig = new EncryptionReceiverConfig(){

        public Set getRequiredConfidentialParts() {
            return PrivateReceiverConfig.this.requiredConfidentialParts;
        }

        public List getEncryptionSettingsList() {
            return PrivateReceiverConfig.this.encryptionSettingsList;
        }

        public String toString() {
            return "EncryptionReceiverConfig(requiredConfidentialParts=" + PrivateReceiverConfig.this.requiredConfidentialParts + " encryptionSettingsList=" + PrivateReceiverConfig.this.encryptionSettingsList + ")";
        }
    };
    protected boolean enableReceivedTimestamp;
    protected TimestampReceiverConfig timestampReceiverConfig = new TimestampReceiverConfig(){

        public boolean addReceivedTimestamp() {
            return PrivateReceiverConfig.this.enableReceivedTimestamp;
        }

        public String getActor() {
            return PrivateReceiverConfig.this.myactor;
        }

        public String toString() {
            return "TimestampReceiverConfig(addReceivedTimestamp=" + this.addReceivedTimestamp() + ")";
        }
    };

    protected void processPrivateConfig(Document privateConfig) throws SoapSecurityException {
        Object instance;
        Map map;
        String cls;
        Element elem;
        int i;
        String value2;
        ClassLoader appClassLoader = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processPrivateConfig(" + privateConfig + ")");
        }
        NodeList list = privateConfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "CertificatePolicy");
        int length = list.getLength();
        HashSet<String> initialPolicies = new HashSet<String>();
        for (int i2 = 0; i2 < length; ++i2) {
            value2 = list.item(i2).getFirstChild().getNodeValue();
            initialPolicies.add(value2.trim());
        }
        Element el = DOMUtil.getZeroOrOneElement(privateConfig, "http://www.ibm.com/xml/soapsec/config", "PolicyMappingInhibited");
        boolean policyMappingInhibited = el != null && ConfigUtil.isTrue(el.getAttribute("flag"));
        el = DOMUtil.getZeroOrOneElement(privateConfig, "http://www.ibm.com/xml/soapsec/config", "ExplicitPolicyRequired");
        boolean explicitPolicyRequired = el != null && ConfigUtil.isTrue(el.getAttribute("flag"));
        el = DOMUtil.getZeroOrOneElement(privateConfig, "http://www.ibm.com/xml/soapsec/config", "RevocationEnabled");
        boolean revocationEnabled = el != null && ConfigUtil.isTrue(el.getAttribute("flag"));
        boolean[] keyUsage = new boolean[]{false, false, false, false, false, false, false, false, false};
        list = privateConfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyUsage");
        length = list.getLength();
        for (int i3 = 0; i3 < length; ++i3) {
            value2 = DOMUtil.getStringValue(list.item(i3));
            if ("DIGITAL_SIGNATURE".equals(value2)) {
                keyUsage[0] = true;
                continue;
            }
            if ("NON_REPUDIATION".equals(value2)) {
                keyUsage[1] = true;
                continue;
            }
            if ("KEY_ENCIPHERMENT".equals(value2)) {
                keyUsage[2] = true;
                continue;
            }
            if ("DATA_ENCHIPERMENT".equals(value2)) {
                keyUsage[3] = true;
                continue;
            }
            if ("KEY_AGREEMENT".equals(value2)) {
                keyUsage[4] = true;
                continue;
            }
            if ("KEY_CERT_SIGN".equals(value2)) {
                keyUsage[5] = true;
                continue;
            }
            if ("CRL_SIGN".equals(value2)) {
                keyUsage[6] = true;
                continue;
            }
            if ("ENCIPHER_ONLY".equals(value2)) {
                keyUsage[7] = true;
                continue;
            }
            if ("DECIPHER_ONLY".equals(value2)) {
                keyUsage[8] = true;
                continue;
            }
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s18", (String)value2);
        }
        list = privateConfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "ExtendedKeyUsage");
        length = list.getLength();
        HashSet<String> extendedKeyUsage = new HashSet<String>();
        for (int i4 = 0; i4 < length; ++i4) {
            extendedKeyUsage.add(DOMUtil.getStringValue(list.item(i4)));
        }
        Iterator iter = this.verificationSettingsList.iterator();
        PKIXBuilderParameters params = null;
        X509CertSelector selector = null;
        while (iter.hasNext()) {
            params = ((VerificationSettings)iter.next()).getPKIXBuilderParameters();
            if (params == null) continue;
            params.setInitialPolicies(initialPolicies);
            params.setPolicyMappingInhibited(policyMappingInhibited);
            params.setExplicitPolicyRequired(explicitPolicyRequired);
            params.setRevocationEnabled(revocationEnabled);
            selector = (X509CertSelector)params.getTargetCertConstraints();
            selector.setKeyUsage(keyUsage);
            try {
                selector.setExtendedKeyUsage(extendedKeyUsage);
            }
            catch (IOException e) {
                String msgKey = "security.wssecurity.PrivateReceiverConfig.s25";
                Tr.processException((Throwable)e, clsName + ".processPrivateConfig", "309", this);
                Tr.error(tc, msgKey, ((Object)extendedKeyUsage).toString());
                throw SoapSecurityException.format((String)msgKey, (String)((Object)extendedKeyUsage).toString(), (Throwable)e);
            }
        }
        list = privateConfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "Transform");
        length = list.getLength();
        if (length == 0) {
            Tr.warning(tc, "security.wssecurity.no.allowed.algorithms.defined");
        } else {
            for (i = 0; i < length; ++i) {
                elem = (Element)list.item(i);
                this.allowedTransforms.add(DOMUtil.getAttribute(elem, "algorithm"));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Allowed Transforms:", new Object[]{this.allowedTransforms});
        }
        if (this.allowedTransforms.isEmpty()) {
            Tr.warning(tc, "security.wssecurity.no.allowed.transforms.defined");
        }
        list = privateConfig.getElementsByTagNameNS(Constants.NS_DSIG, "KeyInfo");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            this.defaultVerificationKeys.add(list.item(i));
        }
        list = privateConfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "KeyInfoResolver");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            elem = (Element)list.item(i);
            cls = DOMUtil.getAttribute(elem, "class");
            map = ConfigUtil.getProperties(elem);
            instance = (KeyInfoResolver)ConfigUtil.instantiate(cls, KeyInfoResolver.class, map, appClassLoader);
            this.keyInfoResolvers.add(instance);
        }
        list = privateConfig.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", "VerificationResultHandler");
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            elem = (Element)list.item(i);
            cls = DOMUtil.getAttribute(elem, "class");
            map = ConfigUtil.getProperties(elem);
            instance = (VerificationResultHandler)ConfigUtil.instantiate(cls, VerificationResultHandler.class, map, appClassLoader);
            this.verificationResultHandlers.add(instance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPrivateConfig(Document privateConfig)");
        }
    }

    public String getMyActor() {
        return this.myactor;
    }

    protected boolean containsId() {
        return this.authMethods.contains("IDAssertion");
    }

    public boolean isSignatureReady() {
        return this.isSignatureRequired() || this.authMethods.contains("Signature") || this.containsId() && "Signature".equals(this.trustMode);
    }

    public boolean isSignatureRequired() {
        return this.requiredIntegralParts.size() > 0;
    }

    public boolean isLoginRequired() {
        return this.authMethods.size() > 0;
    }

    public boolean isDecryptionRequired() {
        return this.requiredConfidentialParts.size() > 0;
    }

    public void validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        Iterator<Object> iter = this.requiredIntegralParts.iterator();
        Object obj2 = null;
        while (iter.hasNext()) {
            obj2 = iter.next();
            if (!(obj2 instanceof String)) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.rconf02", (String)obj2.toString());
            }
            if ("body".equals(obj2) || "timestamp".equals(obj2) || "securitytoken".equals(obj2)) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.rconf02", (String)obj2.toString());
        }
        for (Object obj2 : this.requiredConfidentialParts) {
            if (!(obj2 instanceof String)) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.confPart", (String)obj2.toString());
            }
            if ("bodycontent".equals(obj2) || "usernametoken".equals(obj2)) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.confPart", (String)obj2.toString());
        }
        if (!(this.idType == null || "Username".equals(this.idType) || "DN".equals(this.idType) || "X509Certificate".equals(this.idType))) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s31", (String)this.idType);
        }
        if ("X509Certificate".equals(this.idType) && this.verificationSettingsList.size() == 0) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s44");
        }
        if (this.trustMode != null && !"Signature".equals(this.trustMode) && !"BasicAuth".equals(this.trustMode)) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s08", (String)this.trustMode);
        }
        if (this.authMethods.contains("Signature")) {
            if (this.requiredIntegralParts.size() == 0) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s34");
            }
            if (this.requiredIntegralParts.contains("securitytoken")) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.sigWithSec");
            }
        }
        if (this.authMethods.contains("IDAssertion")) {
            if (this.idType == null) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s32");
            }
            if (this.trustMode != null && this.trustedIDEvaluator == null) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s35");
            }
        }
        for (String authMethod : this.am2lm.keySet()) {
            obj2 = this.am2lm.get(authMethod);
            if (!(obj2 instanceof LoginMapping)) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s37");
            }
            LoginMapping mapping = (LoginMapping)obj2;
            if (this.isNullOrZero(mapping.getConfigName())) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s38");
            }
            if (mapping.getCallbackHandlerFactory() == null) {
                throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s39");
            }
            if ("IDAssertion".equals(authMethod) || "BasicAuth".equals(authMethod) || "Signature".equals(authMethod) || mapping.getTokenValueType() != null) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s40");
        }
        for (Object obj2 : this.authMethods) {
            if (obj2 instanceof String && this.am2lm.containsKey(obj2)) continue;
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s29", (String)obj2.toString());
        }
        if ("BasicAuth".equals(this.trustMode) && !this.am2lm.containsKey("BasicAuth")) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.s43");
        }
        if (this.enableReceivedTimestamp && (this.myactor == null || this.myactor.length() == 0)) {
            throw SoapSecurityException.format((String)"security.wssecurity.PrivateReceiverConfig.rconf03");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
    }

    private boolean isNullOrZero(String str) {
        return str == null || str.length() == 0;
    }

    public SignatureReceiverConfig getSignatureConfig() {
        return this.signatureReceiverConfig;
    }

    public TokenReceiverConfig getTokenConfig() {
        return this.tokenReceiverConfig;
    }

    public EncryptionReceiverConfig getDecryptionConfig() {
        return this.encryptionReceiverConfig;
    }

    public TimestampReceiverConfig getTimestampConfig() {
        return this.timestampReceiverConfig;
    }

    public boolean getBypassSecurityHeaderSetting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled=" + this._bypassSecurityHeader);
        }
        return this._bypassSecurityHeader;
    }

    public Map getProperties() {
        return this._properties;
    }

    public Object getProperty(Object property) {
        if (this._properties != null) {
            return this._properties.get(property);
        }
        return null;
    }

    protected String getLogProperties(Map defaultProps, Map bndParams, Map extProps, Map bndProps, String reqRespTypeIn, String genConTypeIn) {
        StringBuffer buf = new StringBuffer();
        String genConType = "";
        String reqRespType = "";
        if (genConTypeIn != null) {
            genConType = genConTypeIn;
        }
        if (reqRespTypeIn != null) {
            reqRespType = reqRespTypeIn;
        }
        buf.append("\nDefault properties: " + (defaultProps == null ? "null" : defaultProps.toString()));
        buf.append("\nApplication " + reqRespType + " " + genConType + " extension properties: " + (extProps == null ? "null" : extProps.toString()));
        buf.append("\nApplication binding parameters: " + (bndParams == null ? "null" : bndParams.toString()));
        buf.append("\nApplication " + reqRespType + " " + genConType + " binding properties: " + (bndProps == null ? "null" : bndProps.toString()));
        buf.append("\nCombined properties: " + this._properties);
        return buf.toString();
    }

    public String toString() {
        return this.getClass().getName() + "(" + "signatureReceiverConfig=" + this.signatureReceiverConfig + " tokenReceiverConfig=" + this.tokenReceiverConfig + " encryptionReceiverConfig=" + this.encryptionReceiverConfig + " bypassSecurityHeader=" + this._bypassSecurityHeader + " properties=" + this._properties + ")";
    }
}

