/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.policy;

import com.ibm.ws.security.policy.WSPolicyIterator;
import com.ibm.wsspi.security.policy.WSPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolicies
implements WSPolicy {
    private static final long serialVersionUID = 1L;
    private static final String myClassName = AbstractPolicies.class.getName();
    private static final Logger log = Logger.getLogger(myClassName, "com.ibm.ejs.resources.security");
    private List<WSPolicy> policies;
    private Map<Class, Object> adapterCache;

    public AbstractPolicies() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "AbstractPolicies()");
        }
        this.policies = new ArrayList<WSPolicy>();
        this.adapterCache = new HashMap<Class, Object>();
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "AbstractPolicies()");
        }
    }

    @Override
    public void add(WSPolicy policy) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "add(WSPolicy)", policy);
        }
        this.policies.add(policy);
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, myClassName, "add(WSPolicy)", policy + " added.");
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "add(WSPolicy)");
        }
    }

    @Override
    public Object getExtensionAdapter(Class clz) {
        Object adapter;
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "getExtensionAdapter(Class)", clz);
        }
        if ((adapter = this.adapterCache.get(clz)) == null) {
            adapter = Platform.getAdapterManager().getAdapter((Object)this, clz);
            this.adapterCache.put(clz, adapter);
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, myClassName, "getExtensionAdapter(Class)", "adapterCache=" + this.adapterCache);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "getExtensionAdapter(Class)", adapter);
        }
        return adapter;
    }

    @Override
    public boolean isComplete() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "isComplete()");
        }
        boolean result = true;
        for (WSPolicy p : this) {
            if (result = result && p.isComplete()) continue;
            break;
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "isComplete()", result);
        }
        return result;
    }

    @Override
    public Iterator<WSPolicy> iterator() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "iterator()");
        }
        WSPolicyIterator iter = new WSPolicyIterator(this.policies.iterator());
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "iterator()", iter);
        }
        return iter;
    }

    @Override
    public void remove(WSPolicy policy) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "remove(WSPolicy)", policy);
        }
        int index = this.policies.indexOf(policy);
        while (index != -1) {
            this.policies.remove(index);
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, myClassName, "remove(WSPolicy)", policy + " removed.");
            }
            index = this.policies.indexOf(policy);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "remove(WSPolicy)");
        }
    }

    public String toString() {
        return super.toString() + " WSPolicy list=" + this.policies + " adapterCache size=" + this.adapterCache.size();
    }
}

