/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.profile;

import com.ibm.websphere.management.AdminContext;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class ProfileUtility {
    public static final String PROFILE_NAME_KEY = "com.ibm.ws.profile.name";
    public static final String PROFILE_TYPE_KEY = "com.ibm.ws.profile.type";
    public static final String PROFILE_PATH_KEY = "com.ibm.ws.profile.path";
    public static final String PROFILE_UUID_KEY = "com.ibm.ws.profile.key";
    public static final String PROFILE_TYPE_DEPLOYMENT_MANAGER = "DEPLOYMENT_MANAGER";
    public static final String PROFILE_TYPE_JOB_MANAGER = "JOB_MANAGER";
    public static final String PROFILE_TYPE_ADMIN_AGENT = "ADMIN_AGENT";
    public static final String PROFILE_TYPE_BASE = "BASE";

    public static Properties getProfileProperties(String profilePath) throws FileNotFoundException, IOException {
        FileInputStream inStream = new FileInputStream(profilePath + "/properties/profileKey.metadata");
        Properties ret = new Properties();
        ret.load(inStream);
        inStream.close();
        return ret;
    }

    public static String getProfilePath() {
        if (AdminContext.peek() != null) {
            return (String)AdminSubsystemServiceRegistry.getService(PROFILE_PATH_KEY);
        }
        return System.getProperty("user.install.root");
    }

    public static String getUUID() throws FileNotFoundException, IOException {
        String profileRoot;
        String uuid = AdminContext.peek();
        if (uuid == null && (profileRoot = ProfileUtility.getProfilePath()) != null) {
            Properties profileProps = ProfileUtility.getProfileProperties(profileRoot);
            uuid = profileProps.getProperty(PROFILE_UUID_KEY);
        }
        return uuid;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0 || args.length > 1) {
                System.out.println("usage: java com.ibm.wsspi.ProfileUtility <profilePath>");
            } else {
                System.setProperty("user.install.root", args[0]);
                String profilePath = ProfileUtility.getProfilePath();
                System.out.println("profilePath: " + profilePath);
                Properties props = ProfileUtility.getProfileProperties(profilePath);
                for (String string : props.keySet()) {
                    String value2 = props.getProperty(string);
                    System.out.println(string + "=" + value2);
                }
                String uuid = ProfileUtility.getUUID();
                System.out.println("UUID: " + uuid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

