/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.management.ObjectName;

abstract class ServerCommandBase
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ServerCommandBase.class, "ServerCommandBase", "com.ibm.wsspi.management.commands.server");
    private final String implClassName = "com.ibm.ws.management.commands.server.ServerConfigHelper";
    private final String templateConfigHelperClassName = "com.ibm.ws.management.commands.templates.TemplateConfigHelper";
    protected Class implClass = null;
    protected Class templateConfigHelperClass = null;
    protected ManagedObjectMetadataHelper metadataHelper = null;

    public ServerCommandBase(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
        this.initImpl();
    }

    public ServerCommandBase(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateServer", commandData);
        }
        this.initImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateServer");
        }
    }

    private void initImpl() {
        try {
            this.implClass = Class.forName("com.ibm.ws.management.commands.server.ServerConfigHelper");
            this.templateConfigHelperClass = Class.forName("com.ibm.ws.management.commands.templates.TemplateConfigHelper");
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.management.commands.server.CreateServer.initImpl", "70");
        }
    }

    protected ManagedObjectMetadataHelper getManagedObjectMetadataHelper() {
        return this.metadataHelper;
    }

    public void setConfigSession(Session session) {
        super.setConfigSession(session);
        try {
            Method method = this.implClass.getMethod("getMetadataHelper", Session.class);
            this.metadataHelper = (ManagedObjectMetadataHelper)method.invoke(null, session);
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.setConfigSession", "69");
        }
    }

    protected List getTemplate(ObjectName templateLocation, String templateName) {
        List result = null;
        try {
            Session session = ServerCommandBase.getConfigSession(templateLocation);
            if (session == null) {
                session = this.getConfigSession();
            }
            Method method = this.implClass.getMethod("getTemplate", Session.class, ObjectName.class, String.class);
            result = (List)method.invoke(null, session, templateLocation, templateName);
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.setConfigSession", "69");
        }
        return result;
    }

    protected List listServerTemplates(String serverType, String[] queryExp) throws Throwable {
        return this.listServerTemplates(serverType, queryExp, null);
    }

    protected List listServerTemplates(String serverType, String[] queryExp, String nodeName) throws Throwable {
        List result = null;
        try {
            Method method = this.implClass.getMethod("listServerTemplates", ConfigService.class, Session.class, String.class, String[].class, String.class);
            result = (List)method.invoke(null, ConfigServiceFactory.getConfigService(), this.getConfigSession(), serverType, queryExp, nodeName);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.setConfigSession", "69");
        }
        return result;
    }

    protected ObjectName findBestMatchingTemplate(List templates) {
        ObjectName result = null;
        try {
            Object obj;
            Session session = null;
            if (templates.size() > 0 && (obj = templates.get(0)) instanceof ObjectName) {
                ObjectName on = (ObjectName)obj;
                session = ServerCommandBase.getConfigSession(on);
            }
            if (session == null) {
                session = this.getConfigSession();
            }
            Method method = this.templateConfigHelperClass.getMethod("findBestMatchingTemplate", ConfigService.class, Session.class, List.class);
            result = (ObjectName)method.invoke(null, ConfigServiceFactory.getConfigService(), session, templates);
        }
        catch (InvocationTargetException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no such method", ex);
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.findBestMatchingTemplate", "69");
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.findBestMatchingTemplate", "69");
        }
        return result;
    }

    protected int getMatchCount(ObjectName template, String nodeName) {
        Integer result = null;
        Session session = ServerCommandBase.getConfigSession(template);
        if (session == null) {
            session = this.getConfigSession();
        }
        try {
            Method method = this.templateConfigHelperClass.getMethod("getMatchCountInteger", ConfigService.class, Session.class, ObjectName.class, String.class);
            result = (Integer)method.invoke(null, ConfigServiceFactory.getConfigService(), session, template, nodeName);
        }
        catch (InvocationTargetException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no such method", ex);
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getMatchCount", "69");
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getMatchCount", "69");
        }
        if (result != null) {
            return result;
        }
        return -1;
    }

    protected int getDefaultTemplateMatchCount(String serverType, String nodeName) {
        Integer result = null;
        try {
            Method method = this.templateConfigHelperClass.getMethod("getDefaultTemplateMatchCount", ConfigService.class, Session.class, String.class, String.class);
            result = (Integer)method.invoke(null, ConfigServiceFactory.getConfigService(), this.getConfigSession(), serverType, nodeName);
        }
        catch (InvocationTargetException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no such method", ex);
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getDefaultTemplateMatchCount", "69");
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", th);
            }
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.management.commands.server.ServerCommandBase.getDefaultTemplateMatchCount", "69");
        }
        if (result != null) {
            return result;
        }
        return -1;
    }

    private static Session getConfigSession(ObjectName objName) {
        String session = objName.getKeyProperty("_WEBSPHERE_CONFIG_SESSION");
        return session == null ? null : new Session(session, true);
    }
}

