/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import com.ibm.wsspi.configarchive.ImportStep;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;

public abstract class ImportCommand
extends ConfigArchiveCommand {
    private static TraceComponent tc = Tr.register(ImportCommand.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    protected HashMap preImportData = new HashMap();

    public ImportCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportCommand(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    protected void beforeStepsExecuted() {
        TaskCommandResultImpl result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        if (!(result = (TaskCommandResultImpl)this.getTaskCommandResult()).isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.collectConfigBeforeImport();
            EList stepDataList = this.getTaskCommandData().getSteps();
            for (CommandStepData stepData : stepDataList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stepData", stepData);
                }
                ImportStep step = (ImportStep)this.getCommandStep(stepData.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "step", step);
                }
                step.collectConfigBeforeImport();
            }
        }
        catch (Throwable th) {
            Manager.Ffdc.log(th, this, "com.ibm.wsspi.configarchive.ImportCell.beforeStepsExecuted", "99");
            result.setException(new ConfigArchiveException(th, "importCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void createArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArchiveSession");
        }
        try {
            File archive = this.getArchiveLocation();
            Method loadMethod = this.composerCls.getMethod("loadConfigArchiveSession", File.class, FileAccessor.class);
            Session result = (Session)loadMethod.invoke(null, archive, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createArchiveSession", result);
            }
            this.setConfigArchiveSession(result);
        }
        catch (InvocationTargetException ex) {
            Throwable th = ex.getTargetException();
            if (th instanceof ConfigArchiveException) {
                Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ImportCommand.createArchiveSession", "88");
                throw (ConfigArchiveException)th;
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ImportCommand.createArchiveSession", "91");
            throw new ConfigArchiveException(th, "unexpected exception");
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ImportCommand.createArchiveSession", "95");
            throw new ConfigArchiveException(ex, "unexpected exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArchiveSession");
        }
    }

    protected void collectConfigBeforeImport() throws Exception {
    }

    public void setParameter(String paramName, Object value2) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{paramName, value2});
        }
        if (paramName.equals("archive") && !value2.equals("")) {
            try {
                Session archiveSession = this.getConfigArchiveSession();
                if (archiveSession != null) {
                    this.unload();
                }
                super.setParameter(paramName, value2);
                this.createArchiveSession();
            }
            catch (Throwable ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid parameter value", ex);
                }
                Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ImportCommand.setParameter", "108");
                throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            }
        } else {
            super.setParameter(paramName, value2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            if (this.getParameter("archive") == null || this.getConfigArchiveSession() == null) {
                throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            }
        }
        catch (Throwable ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalid parameter value", ex);
            }
            Manager.Ffdc.log(ex, this, "com.ibm.wsspi.configarchive.ImportCommand.validate", "145");
            throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }
}

