/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import com.ibm.wsspi.cluster.selection.rule.TimePeriodRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteActionRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(RouteActionRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private List<TimePeriodRule> tpRuleList;

    public RouteActionRule(List<TimePeriodRule> tpRules) {
        if (tpRules == null) {
            throw new IllegalArgumentException("The list of TimePeriodRules must not be null.");
        }
        this.tpRuleList = tpRules;
    }

    @Override
    public void subset(List identities, StringBuffer reason) {
        ArrayList originalIdentities = new ArrayList();
        originalIdentities.addAll(identities);
        Iterator<TimePeriodRule> tprIter = this.tpRuleList.iterator();
        long currentMillis = System.currentTimeMillis();
        while (tprIter.hasNext()) {
            TimePeriodRule tpr = tprIter.next();
            if (!tpr.ruleActive(currentMillis)) {
                reason.append(" inactive rule");
                continue;
            }
            StringBuffer tempReason = new StringBuffer();
            tpr.subset(identities, tempReason);
            if (identities.isEmpty()) {
                reason.append(" removed: active rule removed all members");
                if (!tprIter.hasNext()) continue;
                identities.addAll(originalIdentities);
                continue;
            }
            reason.append(tempReason);
            return;
        }
        identities.clear();
        reason.append(" removed: all");
    }

    @Override
    public void registerRuleArbitrator(RuleArbitrator coordinator) {
        super.registerRuleArbitrator(coordinator);
        for (TimePeriodRule tpr : this.tpRuleList) {
            tpr.registerRuleArbitrator(coordinator);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof RouteActionRule) {
            return ((Object)this.tpRuleList).equals(((RouteActionRule)object).tpRuleList);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.tpRuleList).hashCode();
    }

    public String toString() {
        return RouteActionRule.class.getName() + '#' + System.identityHashCode(this) + '[' + this.tpRuleList + ']';
    }

    public void setDestroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDestroy()");
        }
        for (TimePeriodRule tpr : this.tpRuleList) {
            tpr.setDestroy();
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.5 ");
        }
    }
}

