/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;

public class IdentityMapping {
    private static final TraceComponent tc = Tr.register(IdentityMapping.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private static final String SCOPE_IDENTIFIER = "Scope";
    private static final String SCOPE_VALUE = "App";
    private static final String CELL_IDENTIFIER = "cell";
    private static final String NAME_IDENTIFIER = "name";
    private static final String MODULE_IDENTIFIER = "module";
    public static final String CFENDPOINT_CACHE_KEY = "CFEndPoint_Cache_Key";

    public long getUID(Identity identity) {
        long result = ((Object)identity.getProperties()).hashCode();
        result <<= 16;
        result |= (long)identity.hashCode();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "getUID " + result, identity);
        }
        return result;
    }

    public static String getClusterNameFromClusterIdentity(Identity clusterIdentity) {
        Map name2 = clusterIdentity.getProperties();
        String clusterName = (String)name2.get("CLUSTERNAME");
        return clusterName;
    }

    public static Identity getClusterIdentityFromClusterName(String cellName, String clusterName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentityFromClusterName", new Object[]{cellName, clusterName});
        }
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put("CELLNAME", cellName);
        name2.put("CLUSTERNAME", clusterName);
        Identity result = clusterService.getIdentity(name2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterIdentityFromClusterName", result);
        }
        return result;
    }

    public static Identity getApplicationCluster(String cellName, String j2eeAppName) {
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put(SCOPE_IDENTIFIER, SCOPE_VALUE);
        name2.put(CELL_IDENTIFIER, cellName);
        name2.put(NAME_IDENTIFIER, j2eeAppName);
        Identity result = clusterService.getIdentity(name2);
        return result;
    }

    public static Identity getApplicationCluster(String cellName, String appName, String moduleName) {
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put(SCOPE_IDENTIFIER, SCOPE_VALUE);
        name2.put(CELL_IDENTIFIER, cellName);
        name2.put(NAME_IDENTIFIER, appName);
        name2.put(MODULE_IDENTIFIER, moduleName);
        Identity result = clusterService.getIdentity(name2);
        return result;
    }

    public static Identity getApplicationServerCluster(String cellName, String clusterName) {
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put("CELLNAME", cellName);
        name2.put("CLUSTERNAME", clusterName);
        Identity result = clusterService.getIdentity(name2);
        return result;
    }

    public static Identity getSessionCluster(String sessionIdentifier) {
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put("jsession", sessionIdentifier);
        return clusterService.getIdentity(name2);
    }

    public static Identity getGenericClusterIdentityFromClusterName(String cellName, String clusterName) {
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put("CELLNAME", cellName);
        name2.put("CLUSTERNAME", clusterName);
        name2.put("CLUSTER_TYPE", "GENERIC");
        Identity result = clusterService.getIdentity(name2);
        return result;
    }

    public static Identity stringToIdentity(String identity) {
        return clusterService.stringToIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFEndPoint getCFEndPoint(Identity endPoint) {
        CFEndPoint cfep;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndPoint", endPoint);
        }
        DescriptionManager descMan = DescriptionManagerFactory.getDescriptionManager();
        Description description = descMan.getDescription((DescriptionKey)endPoint);
        EndPoint ePoint = null;
        if (description == null || !(description instanceof EndPoint)) {
            throw new IllegalArgumentException("The Identity object passed did not identify an endpoint.");
        }
        ePoint = (EndPoint)((Object)description);
        Object object = ((EndPointImpl)ePoint).getSyncObject();
        synchronized (object) {
            cfep = (CFEndPoint)((EndPointImpl)ePoint).getCachedData(CFENDPOINT_CACHE_KEY);
        }
        if (cfep != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "found cached " + cfep);
            }
            return cfep;
        }
        byte[] myBytes = ePoint.getData();
        if (myBytes == null || myBytes.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "zero length myBytes, returning null");
            }
            return null;
        }
        WsObjectInputStream ois = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(myBytes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "The ByteArrayInputStream is " + bais.available() + " bytes long and is: ", bais);
        }
        try {
            ois = new WsObjectInputStream(bais);
            ois.readByte();
            cfep = (CFEndPoint)ois.readObject();
            ((EndPointImpl)ePoint).putCachedData(CFENDPOINT_CACHE_KEY, cfep);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", cfep);
            }
            return cfep;
        }
        catch (IOException e) {
            FFDCFilter.processException(e, IdentityMapping.class.getName() + ".getCFEndPoint", "221");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception ", e);
            }
            IllegalArgumentException iae = new IllegalArgumentException("An internal error occurred while trying to serialize the CFEndPoint object.");
            iae.initCause(e);
            throw iae;
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException(e, IdentityMapping.class.getName() + ".getCFEndPoint", "229");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception ", e);
            }
            IllegalArgumentException iae = new IllegalArgumentException("A required class could not be found while serailizing a CFEndPoint object.");
            iae.initCause(e);
            throw iae;
        }
        catch (ClassCastException cce) {
            IllegalArgumentException iae = new IllegalArgumentException("The object identified by the passed in Identity is not a CFEndPoint object.");
            iae.initCause(cce);
            throw iae;
        }
    }

    public static CFEndPoint getCFEndPoint(Identity containingMember, CFEndPointCriteria criteria) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndPoint", new Object[]{containingMember, criteria});
        }
        EndPoint[] endPoints = clusterService.matchEndPoints(containingMember, ChannelTargetImpl.distinction);
        CFEndPoint[] cfEndPoints = new CFEndPoint[endPoints.length];
        boolean gotOne = false;
        for (int i = 0; i < endPoints.length; ++i) {
            cfEndPoints[i] = IdentityMapping.getCFEndPoint(endPoints[i].getIdentity());
            if (cfEndPoints[i] == null) continue;
            gotOne = true;
        }
        if (!gotOne) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "containing member had no endpoints available, returning null");
            }
            return null;
        }
        try {
            ChannelFrameworkService cfService = AccessController.doPrivileged(new PrivilegedExceptionAction<ChannelFrameworkService>(){

                @Override
                public ChannelFrameworkService run() throws Exception {
                    ChannelFrameworkService cfs = WsServiceRegistry.getService(IdentityMapping.class, ChannelFrameworkService.class);
                    return cfs;
                }
            });
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                StringBuffer debugBuffer = new StringBuffer(criteria.toString());
                debugBuffer.append("[");
                if (criteria instanceof DetailedCFEndPointCriteria) {
                    debugBuffer.append(((DetailedCFEndPointCriteria)criteria).getChainProperties() + ":");
                } else {
                    debugBuffer.append("Not DetailedCFEndPointCriteria:");
                }
                debugBuffer.append(criteria.getChainName() + ":");
                debugBuffer.append(criteria.getChannelAccessor() + ":");
                debugBuffer.append(String.valueOf(criteria.isSSLRequired()));
                debugBuffer.append("]");
                Tr.debug(tc, "getCFEndPoint CFEndPointCriteria= ", debugBuffer);
                Tr.debug(tc, "getCFEndPoint CFEndpoints= ", cfEndPoints);
            }
            CFEndPoint cfep = cfService.determineBestEndPoint(cfEndPoints, criteria);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "the determined best endpoint is: " + cfep);
            }
            return cfep;
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to retrieve the Channel Framework service.");
            ise.initCause(e);
            throw ise;
        }
    }

    public static Identity getServerInstanceCluster(String cellName, String nodeName, String processName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerInstanceCluster", new Object[]{cellName, nodeName, processName});
        }
        Identity result = null;
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put("CELLNAME", cellName);
        name2.put("CLUSTERNAME", nodeName + ":" + processName);
        result = clusterService.getIdentity(name2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerInstanceCluster", result);
        }
        return result;
    }

    public static String getCellNameFromIdentity(Identity identity) {
        String cellName = null;
        Map name2 = identity.getProperties();
        cellName = (String)name2.get("CELLNAME");
        if (cellName == null) {
            cellName = (String)name2.get(CELL_IDENTIFIER);
        }
        if (cellName == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity passed in must be an identity of a cluster or cluster member");
            }
            throw new IllegalArgumentException("Identity passed in must be an identity of a cluster or cluster member");
        }
        return cellName;
    }

    public static Identity getMemberIdentityFromMemberName(String cellName, String nodeName, String memberName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberIdentityFromMemberName", new Object[]{cellName, memberName, nodeName});
        }
        HashMap<String, String> name2 = new HashMap<String, String>();
        name2.put("CELLNAME", cellName);
        name2.put("NODENAME", nodeName);
        name2.put("MEMBERNAME", memberName);
        Identity result = clusterService.getIdentity(name2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberIdentityFromMemberName", result);
        }
        return result;
    }

    public static Identity getMemberIdentityFromEndPointIdentity(Identity endPointIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberIdentityFromEndPointIdentity", new Object[]{endPointIdentity});
        }
        HashMap<String, String> name2 = new HashMap<String, String>();
        Map endPointName = endPointIdentity.getProperties();
        String cellName = (String)endPointName.get("CELL");
        name2.put("CELLNAME", cellName);
        String nodeName = (String)endPointName.get("NODE");
        name2.put("NODENAME", nodeName);
        String memberName = (String)endPointName.get("SERVER");
        name2.put("MEMBERNAME", memberName);
        Identity result = clusterService.getIdentity(name2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberIdentityFromEndPointIdentity", result);
        }
        return result;
    }

    public static String getNodeNameFromClusterMemberIdentity(Identity clusterMemberIdentity) throws IllegalArgumentException {
        String nodeName = null;
        Map name2 = clusterMemberIdentity.getProperties();
        nodeName = (String)name2.get("NODENAME");
        if (nodeName == null) {
            throw new IllegalArgumentException("Identity passed in must be an identity of a cluster or cluster member");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "nodeName " + nodeName);
        }
        return nodeName;
    }

    public static String getServerNameFromClusterMemberIdentity(Identity clusterMemberIdentity) throws IllegalArgumentException {
        String serverName = null;
        Map name2 = clusterMemberIdentity.getProperties();
        serverName = (String)name2.get("MEMBERNAME");
        if (serverName == null) {
            throw new IllegalArgumentException("Identity passed in must be an identity of a cluster or cluster member");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "serverName " + serverName);
        }
        return serverName;
    }

    public static Identity getGenericClusterMemberIdentityFromHostAndPort(Identity genericCluster, String host, int port2) {
        InetAddress passedInMember;
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getGenericClusterMemberIdentityFromHostAndPort", new Object[]{genericCluster, host, port2});
            }
            passedInMember = null;
            try {
                passedInMember = InetAddress.getByName(host);
            }
            catch (UnknownHostException uhe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                Tr.event(tc, "getGenericClusterMemberIdentityFromHostAndPort", new Object[]{"unexpected exception on member: " + host, uhe});
            }
        }
        if (passedInMember != null) {
            Identity[] members = clusterService.getMemberIdentities(genericCluster);
            for (int i = 0; i < members.length; ++i) {
                InetAddress member;
                Map props;
                block10: {
                    props = members[i].getProperties();
                    member = null;
                    try {
                        member = InetAddress.getByName((String)props.get("NODENAME"));
                    }
                    catch (UnknownHostException uhe) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block10;
                        Tr.event(tc, "getGenericClusterMemberIdentityFromHostAndPort", new Object[]{"unexpected exception, skipping member: " + (String)props.get("NODENAME"), uhe});
                    }
                }
                if (member == null || !member.equals(passedInMember) || !props.get("MEMBERNAME").equals(String.valueOf(port2))) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGenericClusterMemberIdentityFromHostAndPort", members[i]);
                }
                return members[i];
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericClusterMemberIdentityFromHostAndPort", "null");
        }
        return null;
    }

    public static Identity getClusterMemberIdentityFromCellNodeAndName(Identity cluster, String cell, String node, String name2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterMemberIdentityFromCellNodeAndName", new Object[]{cluster, cell, node, name2});
        }
        Identity[] members = clusterService.getMemberIdentities(cluster);
        for (int i = 0; i < members.length; ++i) {
            Map props = members[i].getProperties();
            if (!props.get("CELLNAME").equals(cell) || !props.get("NODENAME").equals(node) || !props.get("MEMBERNAME").equals(name2)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterMemberIdentityFromCellNodeAndName", members[i]);
            }
            return members[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterMemberIdentityFromCellNodeAndName", "null");
        }
        return null;
    }

    public static boolean isGenericCluster(Identity clusterIdentity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenericCluster", clusterIdentity);
        }
        boolean result = false;
        if (clusterIdentity != null) {
            String clusterType = (String)clusterIdentity.getProperties().get("CLUSTER_TYPE");
            result = "GENERIC".equals(clusterType);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isGenericCluster", result);
        }
        return result;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.25.1.7 ");
        }
    }
}

