/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.bootstrap;

import com.ibm.ws.bootstrap.ClassLoaderGateway;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.bootstrap.StopWatch;
import com.ibm.ws.bootstrap.TimeBomb;
import com.ibm.wsspi.bootstrap.InvocationHandler;
import com.ibm.wsspi.bootstrap.WSPreLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class WSLauncher
implements IPlatformRunnable {
    private static final StopWatch stopwatch = StopWatch.instance();
    private static Object[] handlers = null;
    private static final boolean isZOS;
    private static final boolean overrideZOS;
    private static final boolean isIseries;

    public Object run(Object arg0) throws Exception {
        WSLauncher.debug("#######################################################");
        WSLauncher.debug("  WebSphere Bootstrap Bundle V7");
        WSLauncher.debug("#######################################################");
        WSLauncher.main((String[])arg0);
        return null;
    }

    public static void main(String[] args) {
        WSLauncher.parseArgs(args);
        args = WSPreLauncher.processArgsOut(args);
        WSLauncher.checkTimeBomb(args);
        WSLauncher.createExtClassLoader();
        WSLauncher.launchMain(args);
    }

    private static void createExtClassLoader() {
        ClassLoader gwcl = ClassLoaderGateway.instance().getClassLoader();
        ExtClassLoader ecl = null;
        ecl = gwcl != null ? new ExtClassLoader(System.getProperty("ws.ext.dirs"), gwcl) : new ExtClassLoader(System.getProperty("ws.ext.dirs"));
        ecl.installGateway(ClassLoaderGateway.instance());
        Thread.currentThread().setContextClassLoader(ecl);
    }

    private static void parseArgs(String[] args) {
        if (args.length < 1) {
            LoggingServices.out.println("usage: WSLauncher <className>");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchMain(String[] args) {
        IConfigurationElement run;
        String applicationName = args[0];
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        args = newArgs;
        Class<?> mainClass = null;
        WSLauncher.debug("ws.ext.main.class=" + applicationName);
        String APPL_EPID = "org.eclipse.core.runtime.applications";
        String APPLICATION = "application";
        String RUN = "run";
        String CLASS = "class";
        IExtension applicationExtension = WSLauncher.getExtension("org.eclipse.core.runtime.applications", applicationName);
        IConfigurationElement application = applicationExtension != null ? WSLauncher.getElement(applicationExtension.getConfigurationElements(), "application") : null;
        IConfigurationElement iConfigurationElement = run = application != null ? WSLauncher.getElement(application.getChildren("run"), "run") : null;
        if (run != null) {
            try {
                mainClass = run.createExecutableExtension("class").getClass();
            }
            catch (Throwable t) {
                WSLauncher.debug("WARNING: couldnt locate application: " + run.getAttribute("class"));
                t.printStackTrace(LoggingServices.out);
            }
        }
        if (mainClass == null) {
            WSLauncher.debug("application not found");
            System.exit(-1);
        }
        String MANUAL_START_EPID = "com.ibm.ws.bootstrap.manual-bundle-start";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.ws.bootstrap.manual-bundle-start");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                String bundleName = extensions[i].getNamespace();
                Bundle bundle = Platform.getBundle((String)bundleName);
                if (bundle == null || bundle.getState() == 32) continue;
                try {
                    bundle.start();
                    continue;
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
        }
        Method main = null;
        Object ret = null;
        try {
            main = mainClass.getMethod("main", String[].class);
            args = WSLauncher.preInvoke(applicationName, args);
            args = WSLauncher.removeProfileName(applicationName, args);
            ret = main.invoke(null, new Object[]{args});
        }
        catch (Exception ex) {
            ex.printStackTrace(LoggingServices.out);
        }
        finally {
            WSLauncher.postInvoke();
        }
    }

    private static IExtension getExtension(String extensionPointName, String uid) {
        IExtension result = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(extensionPointName);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            for (int i = 0; i < extensions.length && result == null; ++i) {
                if (extensions[i].getUniqueIdentifier().equals(uid)) {
                    result = extensions[i];
                    continue;
                }
                WSLauncher.debug("  no match: " + extensions[i].getUniqueIdentifier());
            }
        }
        WSLauncher.debug("getExtension(epid=" + extensionPointName + ", uid=" + uid + ") -> " + result);
        return result;
    }

    private static IConfigurationElement getElement(IConfigurationElement[] elements, String name2) {
        IConfigurationElement result = null;
        if (elements != null) {
            for (int i = 0; i < elements.length && result == null; ++i) {
                if (!elements[i].getName().equals(name2)) continue;
                result = elements[i];
            }
        }
        WSLauncher.debug("getElement(list=" + elements + ", name=" + name2 + ") --> " + result);
        return result;
    }

    private static void debug(String msg) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("[WSLauncher]: " + msg);
        }
    }

    private static String[] preInvoke(String mainClass, String[] args) throws Exception {
        Vector handlersVec = new Vector();
        WSLauncher.processBootFile(mainClass, handlersVec);
        handlers = new Object[handlersVec.size()];
        Class[] argTypes = new Class[]{String.class, String[].class};
        String HANDLER_EPID = "com.ibm.ws.bootstrap.invocationHandlers";
        String HANDLER = "handler";
        String CLASS = "class";
        for (int i = 0; i < handlers.length; ++i) {
            IConfigurationElement handler2;
            IExtension handlerExtension = WSLauncher.getExtension("com.ibm.ws.bootstrap.invocationHandlers", (String)handlersVec.get(i));
            IConfigurationElement iConfigurationElement = handler2 = handlerExtension != null ? WSLauncher.getElement(handlerExtension.getConfigurationElements(), "handler") : null;
            if (handler2 == null) continue;
            try {
                WSLauncher.handlers[i] = handler2.createExecutableExtension("class");
                args = ((InvocationHandler)handlers[i]).preInvoke(args);
                continue;
            }
            catch (Throwable t) {
                WSLauncher.debug("Error processing handler " + handlersVec.get(i));
                t.printStackTrace(LoggingServices.out);
            }
        }
        return args;
    }

    private static void processBootFile(String name2, Vector handlers) {
        try {
            StringBuffer bootFileName = new StringBuffer();
            bootFileName.append(System.getProperty("was.install.root"));
            bootFileName.append(File.separator);
            bootFileName.append("bin");
            bootFileName.append(File.separator);
            bootFileName.append("boot");
            bootFileName.append(File.separator);
            bootFileName.append(name2);
            bootFileName.append(".boot");
            File bootFile = new File(bootFileName.toString());
            if (!bootFile.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(bootFile));
            String INCLUDE_TAG = "include ";
            String next = null;
            while ((next = reader.readLine()) != null) {
                if ((next = next.trim()).startsWith("include ")) {
                    WSLauncher.processBootFile(next.substring("include ".length()), handlers);
                    continue;
                }
                handlers.add(next);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void postInvoke() {
        if (handlers == null) {
            return;
        }
        for (int i = handlers.length - 1; i >= 0; --i) {
            if (handlers[i] == null) continue;
            Object method = null;
            try {
                ((InvocationHandler)handlers[i]).postInvoke();
                continue;
            }
            catch (Exception e) {
                System.out.println("caught " + e);
                e.printStackTrace(LoggingServices.out);
            }
        }
    }

    private static String[] removeProfileName(String mainClass, String[] args) {
        String[] newArgs = args;
        String name2 = mainClass.substring(mainClass.lastIndexOf(46) + 1, mainClass.length()).trim();
        if (!(name2.equals("WSProfileCLI") || name2.equals("WsProfile") || Boolean.getBoolean("KeepProfileName"))) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-profileName")) continue;
                int numArgsToRemove = 1;
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    numArgsToRemove = 2;
                }
                newArgs = new String[args.length - numArgsToRemove];
                System.arraycopy(args, 0, newArgs, 0, i);
                System.arraycopy(args, i + numArgsToRemove, newArgs, i, newArgs.length - i);
                break;
            }
        }
        return newArgs;
    }

    private static void checkTimeBomb(String[] args) {
        if (!(isIseries || isZOS || TimeBomb.checkLicense(true) || args[0].indexOf("WsServerStop") >= 0)) {
            System.exit(-1);
        }
    }

    static {
        overrideZOS = Boolean.getBoolean("com.ibm.websphere.zos.forcedist");
        String os = System.getProperty("os.name").trim();
        isZOS = (os.equals("OS/390") || os.equals("z/OS")) && !overrideZOS;
        isIseries = os.equals("OS/400");
    }
}

