/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.wsaddressing.integration.EndpointMapService;
import com.ibm.ws.wsaddressing.urimap.service.EndpointKey;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class EndpointMapImpl
implements EndpointMapService {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointMapImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private HashMap applicationNameToKeyListMap = new HashMap();
    private HashMap applicationNameToDataListMap = new HashMap();
    private HashMap keyToDataListMap = new HashMap();

    private EndpointMapService.EndpointData getEndpointData(String webServiceName, QName endpoint) throws MultipleEntriesException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointInformation", new Object[]{webServiceName, endpoint});
        }
        EndpointMapService.EndpointData result = null;
        QName service = new QName(endpoint.getNamespaceURI(), webServiceName);
        List information = (List)this.keyToDataListMap.get(new EndpointKey(service, endpoint.getLocalPart()));
        if (information == null || information.size() == 0) {
            result = null;
        } else if (information.size() == 1) {
            try {
                result = (EndpointMapService.EndpointData)information.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getEndpointInformation", "List modified by another thread so will return null.");
                }
            }
        } else {
            MultipleEntriesException mee = new MultipleEntriesException();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getEndpointInformation", mee);
            }
            throw mee;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointInformation", result);
        }
        return result;
    }

    private void putToListMap(Object key, Object value2, Map map) {
        ArrayList<Object> list;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "putToListMap", new Object[]{key, value2, map});
        }
        if ((list = (ArrayList<Object>)map.get(key)) == null) {
            list = new ArrayList<Object>();
            map.put(key, list);
        }
        list.add(value2);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "putToListMap");
        }
    }

    public URI getSOAPAddressForPort(String webServiceName, QName endpointName) throws URIGenerationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPAddressForPort", new Object[]{webServiceName, endpointName});
        }
        try {
            EndpointMapService.EndpointData ed = this.getEndpointData(webServiceName, endpointName);
            if (ed == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", null);
                }
                return null;
            }
            URI result = new URI(ed.getAddress());
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", result);
            }
            return result;
        }
        catch (MultipleEntriesException e) {
            throw new URIGenerationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{webServiceName, endpointName}, null), e);
        }
        catch (URISyntaxException e) {
            throw new URIGenerationException(nls.getString("INVALID_ADDRESS_CWWAR0200"), e);
        }
    }

    public String getVirtualHostForPort(String webServiceName, QName endpointName) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForPort", new Object[]{webServiceName, endpointName});
        }
        try {
            EndpointMapService.EndpointData ed = this.getEndpointData(webServiceName, endpointName);
            if (ed == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", null);
                }
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", ed.getVirtualHost());
            }
            return ed.getVirtualHost();
        }
        catch (MultipleEntriesException e) {
            throw new EndpointReferenceCreationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{webServiceName, endpointName}, null), e);
        }
    }

    public boolean intermediaryConfigured(String serviceName, QName endpointName) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intermediaryConfigured", new Object[]{serviceName, endpointName});
        }
        try {
            EndpointMapService.EndpointData ed = this.getEndpointData(serviceName, endpointName);
            if (ed == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", Boolean.FALSE);
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", ed.isIntermediaryPresent());
            }
            return ed.isIntermediaryPresent();
        }
        catch (MultipleEntriesException e) {
            throw new EndpointReferenceCreationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{serviceName, endpointName}, null), e);
        }
    }

    public boolean workLoadManaged(String serviceName, QName endpointName) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "workLoadManaged", new Object[]{serviceName, endpointName});
        }
        EndpointMapService.EndpointData ed = null;
        try {
            ed = this.getEndpointData(serviceName, endpointName);
        }
        catch (MultipleEntriesException e) {
            throw new EndpointReferenceCreationException(nls.getFormattedMessage("MULTIPLE_ENTRIES_CWWAR0201", new Object[]{serviceName, endpointName}, null), e);
        }
        if (ed == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "workLoadManaged", Boolean.FALSE);
            }
            return true;
        }
        boolean result = ed.isWLMable();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "workLoadManaged", result);
        }
        return result;
    }

    public synchronized void addEndpointData(EndpointMapService.EndpointData endpointData) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEndpointMapping", new Object[]{endpointData});
        }
        EndpointKey ek = new EndpointKey(endpointData.getWebServiceName(), endpointData.getEndpointName());
        this.putToListMap(endpointData.getApplicationName(), ek, this.applicationNameToKeyListMap);
        this.putToListMap(endpointData.getApplicationName(), endpointData, this.applicationNameToDataListMap);
        this.putToListMap(ek, endpointData, this.keyToDataListMap);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEndpointMapping");
        }
    }

    public synchronized void removeEndpointData(String applicationName) {
        List pairs;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeEndpointMappings", applicationName);
        }
        if ((pairs = (List)this.applicationNameToDataListMap.get(applicationName)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "removeEndpointMappings", "No pairs found");
            }
            return;
        }
        for (EndpointMapService.EndpointData endpointData : pairs) {
            EndpointKey ek = new EndpointKey(endpointData.getWebServiceName(), endpointData.getEndpointName());
            List eis = (List)this.keyToDataListMap.get(ek);
            eis.remove(endpointData);
            if (!eis.isEmpty()) continue;
            this.keyToDataListMap.remove(ek);
        }
        this.applicationNameToKeyListMap.remove(applicationName);
        this.applicationNameToDataListMap.remove(applicationName);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeEndpointMappings");
        }
    }

    private static class MultipleEntriesException
    extends Exception {
        private MultipleEntriesException() {
        }
    }
}

