/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportChannelServiceHelper {
    private static TraceComponent _tc = Tr.register(TransportChannelServiceHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    public static final String secure_http_protocol = "https";
    public static final String http_protocol = "http";

    private static ConfigObject findTransportChannelService(String nodeName, String serverName) {
        ConfigObject s_tcs;
        block8: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "findTransportChannelService", new Object[]{nodeName, serverName});
            }
            s_tcs = null;
            try {
                ConfigService configService = WsServiceRegistry.getService(TransportChannelServiceHelper.class, ConfigService.class);
                ConfigScope cscope = configService.createScope(4);
                if (nodeName != null) {
                    cscope.set(3, nodeName);
                }
                if (serverName != null) {
                    cscope.set(4, serverName);
                }
                ConfigObject s = (ConfigObject)configService.getDocumentObjects(cscope, "server.xml", false).get(0);
                List s_servicesList = s.getObjectList("services");
                for (ConfigObject s_service : s_servicesList) {
                    if (!s_service.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.xmi", "TransportChannelService")) continue;
                    List transportChannelsList = s_service.getObjectList("transportChannels");
                    if (!transportChannelsList.isEmpty()) {
                        s_tcs = s_service;
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, TransportChannelServiceHelper.class.toString(), "1:84:1.2");
                if (!_tc.isDebugEnabled()) break block8;
                Tr.debug(_tc, "findTransportChannelService caught exeption ", e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findTransportChannelService", s_tcs);
        }
        return s_tcs;
    }

    static Map<String, String> getLocalWebContainerEndPointMap() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndPointMap");
        }
        ConfigObject transportChannelService = TransportChannelServiceHelper.findTransportChannelService(null, null);
        HashMap<String, String> endPointMap = new HashMap<String, String>();
        List chains = transportChannelService.getObjectList("chains");
        for (int ii = 0; ii < chains.size(); ++ii) {
            ConfigObject aChain = (ConfigObject)chains.get(ii);
            if (!TransportChannelServiceHelper.isTCPInbound(aChain) || !TransportChannelServiceHelper.isWebContainerInbound(aChain)) continue;
            if (TransportChannelServiceHelper.isSSLInbound(aChain)) {
                endPointMap.put(TransportChannelServiceHelper.getEndPointName(aChain), secure_http_protocol);
                continue;
            }
            endPointMap.put(TransportChannelServiceHelper.getEndPointName(aChain), http_protocol);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndPointMap", endPointMap);
        }
        return endPointMap;
    }

    public static Map<String, String> getLocalNodeProxyEndPointMap(String serverName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getProxyEndPointMap");
        }
        HashMap<String, String> endPointMap = new HashMap<String, String>();
        ConfigObject transportChannelService = TransportChannelServiceHelper.findTransportChannelService(null, serverName);
        if (transportChannelService == null) {
            endPointMap.put("PROXY_HTTP_ADDRESS", http_protocol);
            endPointMap.put("PROXY_HTTPS_ADDRESS", secure_http_protocol);
        } else {
            List chains = transportChannelService.getObjectList("chains");
            for (int ii = 0; ii < chains.size(); ++ii) {
                ConfigObject aChain = (ConfigObject)chains.get(ii);
                if (!TransportChannelServiceHelper.isTCPInbound(aChain) || !TransportChannelServiceHelper.isProxyInbound(aChain)) continue;
                if (TransportChannelServiceHelper.isSSLInbound(aChain)) {
                    endPointMap.put(TransportChannelServiceHelper.getEndPointName(aChain), secure_http_protocol);
                    continue;
                }
                endPointMap.put(TransportChannelServiceHelper.getEndPointName(aChain), http_protocol);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getProxyEndPointMap", endPointMap);
        }
        return endPointMap;
    }

    public static Map<String, String> getRemoteNodeProxyEndPointMap() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRemoteNodeProxyEndPointMap");
        }
        HashMap<String, String> endPointMap = new HashMap<String, String>();
        endPointMap.put("PROXY_HTTP_ADDRESS", http_protocol);
        endPointMap.put("PROXY_HTTPS_ADDRESS", secure_http_protocol);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRemoteNodeProxyEndPointMap", endPointMap);
        }
        return endPointMap;
    }

    private static ConfigObject getFirstChannel(ConfigObject chain) {
        List tcs;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getFirstChannel", new Object[]{chain});
        }
        ConfigObject result = null;
        if (chain != null && (tcs = chain.getObjectList("transportChannels")) != null && !tcs.isEmpty()) {
            result = (ConfigObject)tcs.get(0);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getFirstChannel", result);
        }
        return result;
    }

    private static ConfigObject getLastChannel(ConfigObject chain) {
        List channels;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLastChannel", new Object[]{chain});
        }
        ConfigObject result = null;
        if (chain != null && (channels = chain.getObjectList("transportChannels")) != null && !channels.isEmpty()) {
            result = (ConfigObject)channels.get(channels.size() - 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getLastChannel", result);
        }
        return result;
    }

    private static boolean isTCPInbound(ConfigObject chain) {
        ConfigObject first = TransportChannelServiceHelper.getFirstChannel(chain);
        return first != null && first.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "TCPInboundChannel");
    }

    private static boolean isWebContainerInbound(ConfigObject chain) {
        ConfigObject last = TransportChannelServiceHelper.getLastChannel(chain);
        return last != null && last.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "WebContainerInboundChannel");
    }

    private static boolean isProxyInbound(ConfigObject chain) {
        ConfigObject last = TransportChannelServiceHelper.getLastChannel(chain);
        return last != null && last.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/proxy.xmi", "ProxyInboundChannel");
    }

    private static String getEndPointName(ConfigObject tcpChain) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndPointMap", new Object[]{tcpChain});
        }
        String endPointName = "";
        ConfigObject first = TransportChannelServiceHelper.getFirstChannel(tcpChain);
        if (first != null && first.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "TCPInboundChannel")) {
            endPointName = first.getString("endPointName", "__null__");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndPointMap", endPointName);
        }
        return endPointName;
    }

    private static boolean isSSLInbound(ConfigObject chain) {
        List channels;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isSSLIbbound", new Object[]{chain});
        }
        boolean result = false;
        if (chain != null && (channels = chain.getObjectList("transportChannels")) != null && !channels.isEmpty()) {
            for (ConfigObject aChannel : channels) {
                if (!aChannel.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "SSLInboundChannel")) continue;
                result = true;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isSSLInbound", result);
        }
        return result;
    }
}

