/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.integration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.wsaddressing.integration.EndpointMap;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class CombinedEndpointMap
implements EndpointMap {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(CombinedEndpointMap.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String MULTIPLE_SOAP_ADDRESS_TRACE_STRING = "Multiple mappings found. Cannot determine one soap address for this webServiceName and port pair.";
    private static final String MULTIPLE_SOAP_ADDRESS_EXCEPTION_STRING = "The desired target endpoint has been deployed with multiple addresses. Unable to determine a unique address URI for EndpointReference creation.";
    private static final String MULTIPLE_VIRTUAL_HOST_TRACE_STRING = "Multiple mappings found. Cannot determine one virtual host for this webServiceName and port pair.";
    private static final String MULTIPLE_VIRTUAL_HOST_EXCEPTION_STRING = "The desired target endpoint has been deployed with multiple addresses. Unable to determine a unique virtual host for EndpointReference creation.";
    private static final String MULTIPLE_INTEMEDIARY_INFO_TRACE_STRING = "Multiple mappings found. Cannot determine unique intemediary status for this webServiceName and port pair.";
    private static final String MULTIPLE_INTEMEDIARY_INFO_EXCEPTION_STRING = "The desired target endpoint has been deployed with multiple addresses. Unable to determine a unique intemediary status for EndpointReference creation.";
    ArrayList maps = new ArrayList();

    public URI getSOAPAddressForPort(String webServiceName, QName port2) throws URIGenerationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPAddressForPort", new Object[]{webServiceName, port2});
        }
        URI result = null;
        for (EndpointMap wsim : this.maps) {
            URI address = wsim.getSOAPAddressForPort(webServiceName, port2);
            if (address == null) continue;
            if (result == null) {
                result = address;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] params = new Object[]{MULTIPLE_SOAP_ADDRESS_TRACE_STRING, webServiceName, port2};
                Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", params);
            }
            throw new URIGenerationException(MULTIPLE_SOAP_ADDRESS_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPAddressForPort", result);
        }
        return result;
    }

    public String getVirtualHostForPort(String webServiceName, QName port2) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForPort", new Object[]{webServiceName, port2});
        }
        String result = null;
        for (EndpointMap wsim : this.maps) {
            String vHost = wsim.getVirtualHostForPort(webServiceName, port2);
            if (vHost == null) continue;
            if (result == null) {
                result = vHost;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] params = new Object[]{MULTIPLE_VIRTUAL_HOST_TRACE_STRING, webServiceName, port2};
                Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", params);
            }
            throw new EndpointReferenceCreationException(MULTIPLE_VIRTUAL_HOST_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVirtualHostForPort", result);
        }
        return result;
    }

    public boolean intermediaryConfigured(String serviceName, QName endpointName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intermediaryConfigured", new Object[]{serviceName, endpointName});
        }
        boolean result = false;
        for (EndpointMap wsim : this.maps) {
            boolean intemediary = wsim.intermediaryConfigured(serviceName, endpointName);
            if (!intemediary) continue;
            if (!result) {
                result = true;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] params = new Object[]{MULTIPLE_INTEMEDIARY_INFO_TRACE_STRING, serviceName, endpointName};
                Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", params);
            }
            throw new EndpointReferenceCreationException(MULTIPLE_INTEMEDIARY_INFO_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intermediaryConfigured", result);
        }
        return result;
    }

    void addEndpointMap(EndpointMap map) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEndpointMap", map);
        }
        this.maps.add(map);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEndpointMap");
        }
    }

    void removeEndpointMap(EndpointMap map) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeEndpointMap", map);
        }
        this.maps.remove(map);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeEndpointMap");
        }
    }

    public boolean workLoadManaged(String serviceName, QName endpointName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "workLoadManaged", new Object[]{serviceName, endpointName});
        }
        boolean result = true;
        for (EndpointMap epm : this.maps) {
            boolean wlmable = epm.workLoadManaged(serviceName, endpointName);
            if (wlmable) continue;
            if (result) {
                result = false;
                continue;
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] params = new Object[]{MULTIPLE_INTEMEDIARY_INFO_TRACE_STRING, serviceName, endpointName};
                Tr.exit(TRACE_COMPONENT, "workLoadManaged", params);
            }
            throw new EndpointReferenceCreationException(MULTIPLE_INTEMEDIARY_INFO_EXCEPTION_STRING);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "workLoadManaged", result);
        }
        return result;
    }
}

