/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.wsaddressing.handlers.ActionSpecifier;
import com.ibm.ws.wsaddressing.handlers.InboundWSAProcessor;
import com.ibm.ws.wsaddressing.handlers.MAPWriter;
import com.ibm.ws.wsaddressing.handlers.MessagePivot;
import com.ibm.ws.wsaddressing.handlers.ReplyHelper;
import com.ibm.ws.wsaddressing.handlers.UsingAddressingHelper;
import com.ibm.ws.wsaddressing.handlers.WSACommonHandler;
import com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties;
import com.ibm.ws.wsaddressing.integration.EndpointReference;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class WSAddressingServerHandler
extends WSACommonHandler {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingServerHandler.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private boolean wsAddressingDisabled = false;
    private static final QName[] headerElementQNames = new QName[7];

    public boolean handleRequest(MessageContext jaxRpcMsgContext) {
        if (this.isAddressingDisabled(jaxRpcMsgContext)) {
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleRequest", jaxRpcMsgContext);
        }
        boolean wsaddressingMandatedByUsingAddressing = UsingAddressingHelper.wsaddressingMandatedByUsingAddressing(jaxRpcMsgContext);
        SOAPMessageContext soapMessageContext = null;
        if (!(jaxRpcMsgContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "No SoapMessageContext, return true;");
            }
            return true;
        }
        soapMessageContext = (SOAPMessageContext)jaxRpcMsgContext;
        InboundWSAProcessor processor = new InboundWSAProcessor();
        boolean wsaPresent = processor.setMessageContext(soapMessageContext);
        if (!wsaPresent && wsaddressingMandatedByUsingAddressing) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest");
            }
            throw this.generateSFE();
        }
        if (wsaPresent && !processor.isAddressingValid()) {
            String message = "An invalid WSA Header was encountered";
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.warning(TRACE_COMPONENT, message);
            }
            SOAPFaultException sfe = processor.getSoapFaultException();
            throw sfe;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleRequest:[true]");
        }
        return true;
    }

    public boolean handleResponse(MessageContext jaxRpcMsgContext) {
        Object flag;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleResponse", jaxRpcMsgContext);
        }
        if ((flag = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.WsaFoundInbound")) == null || flag instanceof Boolean && !((Boolean)flag).booleanValue()) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", jaxRpcMsgContext);
            }
            return true;
        }
        if (this.isAddressingDisabled(jaxRpcMsgContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", "WSA Disabled, return true;");
            }
            return true;
        }
        if (!(jaxRpcMsgContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", "MessageContext not instanceof SOAPMessageContext, return true;");
            }
            return true;
        }
        if (((SOAPMessageContext)jaxRpcMsgContext).getMessage() == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleResponse", "SOAPMessageContext has no message set, return true;");
            }
            return true;
        }
        EndpointReference inboundReplyToEPR = (EndpointReference)jaxRpcMsgContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        NamespaceData namespaceData = NamespaceData.getNamespaceDataFromContext(jaxRpcMsgContext);
        ReplyHelper rh = new ReplyHelper(inboundReplyToEPR, null, namespaceData);
        MessagePivot msgPivot = new MessagePivot();
        msgPivot.requestBecomesResponse(rh, jaxRpcMsgContext);
        this.addWSAddressingToResponseOrFaultMessage(jaxRpcMsgContext, ActionSpecifier.MessageType.RESPONSE);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext jaxRpcMsgContext) {
        Object flag;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleFault", jaxRpcMsgContext);
        }
        if (this.isAddressingDisabled(jaxRpcMsgContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", "WSA Disabled, return true;");
            }
            return true;
        }
        if (!(jaxRpcMsgContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", "MessageContext not SOAPMessageContext, return true;");
            }
            return true;
        }
        if (((SOAPMessageContext)jaxRpcMsgContext).getMessage() == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", "SOAPMessageContext has no message set, return true;");
            }
            return true;
        }
        NamespaceData namespaceData = NamespaceData.getNamespaceDataFromContext(jaxRpcMsgContext);
        if (jaxRpcMsgContext.containsProperty("com.ibm.ws.wsaddressing.soapfault.detail")) {
            String faultDetail = (String)jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.soapfault.detail");
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "FaultDetail string found: " + faultDetail);
            }
            jaxRpcMsgContext.setProperty("com.ibm.wsspi.wsaddressing.action", WSAddressingFactory.createAttributedURI(namespaceData.getFaultActionURI()));
            try {
                SOAPFactory soapFactory = new SOAPFactory();
                SOAPElement faultDetailSE = soapFactory.createElement(namespaceData.getwsaFaultDetailName());
                SOAPElement se = soapFactory.createElement(namespaceData.getwsaProblemHeaderQN());
                faultDetailSE.addChildElement(se);
                se.addTextNode(se.getPrefix() + ":" + faultDetail);
                SOAPMessage sm = ((SOAPMessageContext)jaxRpcMsgContext).getMessage();
                SOAPHeader sh = sm.getSOAPHeader();
                sh.addChildElement(faultDetailSE);
            }
            catch (SOAPException e) {
                String message = "SOAPException encountered when setting soapHeader.";
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.handleFault", message);
                }
                FFDCFilter.processException(e, CLASSNAME, "1:311:1.108");
            }
        }
        if ((flag = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.WsaFoundInbound")) == null || flag instanceof Boolean && !((Boolean)flag).booleanValue()) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleFault", jaxRpcMsgContext);
            }
            return true;
        }
        EndpointReference inboundReplyToEPR = (EndpointReference)jaxRpcMsgContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        EndpointReference inboundFaultToEPR = (EndpointReference)jaxRpcMsgContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
        ReplyHelper rh = new ReplyHelper(inboundReplyToEPR, inboundFaultToEPR, namespaceData);
        MessagePivot msgPivot = new MessagePivot();
        msgPivot.requestBecomesFault(rh, jaxRpcMsgContext);
        this.addWSAddressingToResponseOrFaultMessage(jaxRpcMsgContext, ActionSpecifier.MessageType.FAULT);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleFault");
        }
        return true;
    }

    private void addWSAddressingToResponseOrFaultMessage(MessageContext jaxRpcMsgContext, ActionSpecifier.MessageType messageType) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", jaxRpcMsgContext);
        }
        SOAPMessageContext soapMessageContext = (SOAPMessageContext)jaxRpcMsgContext;
        WSAOutboundProperties wsaOutboundProperties = new WSAOutboundProperties();
        if (wsaOutboundProperties.setMessageContext(jaxRpcMsgContext)) {
            wsaOutboundProperties.setupWSAProperties();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", "WSAddressing properties were found on the context");
            }
            if (jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null) {
                this.completeRedirectionChanges(jaxRpcMsgContext);
            }
            if (jaxRpcMsgContext.containsProperty("com.ibm.ws.wsaddressing.NoneURI")) {
                this.completeNoneURI(jaxRpcMsgContext);
            }
            AttributedURI wsaAction = wsaOutboundProperties.getWsaddressingAction();
            RPCContext rpcContext = (RPCContext)((Object)jaxRpcMsgContext);
            ActionSpecifier actionSpecifier = new ActionSpecifier(rpcContext);
            if (wsaAction == null) {
                if (ActionSpecifier.MessageType.RESPONSE.equals((Object)messageType)) {
                    wsaAction = actionSpecifier.getActionForOutputMessageFromWSDL();
                } else if (ActionSpecifier.MessageType.FAULT.equals((Object)messageType)) {
                    boolean isWSAFault = jaxRpcMsgContext.containsProperty("com.ibm.ws.wsaddressing.soapfault.detail");
                    wsaAction = actionSpecifier.getActionForFaultMessageFromWSDL(wsaOutboundProperties.getNamespaceData(), isWSAFault);
                }
                wsaOutboundProperties.setWsaddressingAction(wsaAction);
            }
            MAPWriter writer = new MAPWriter();
            SOAPHeader soapHeader = null;
            try {
                soapHeader = writer.getSOAPHeaderFromMessageContext(soapMessageContext);
            }
            catch (SOAPException e1) {
                FFDCFilter.processException((Throwable)e1, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.addWSAddressingToResponseOrFaultMessage", "1:447:1.108", (Object)e1);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", "SOAPException whilst trying to retrieve or add a SOAPHeader to this SOAPMessage.");
                }
                throw new JAXRPCException(e1);
            }
            NamespaceData namespaceData = wsaOutboundProperties.getNamespaceData();
            jaxRpcMsgContext.setProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace", namespaceData.getNamespace());
            try {
                writer.addNamespaceDeclarationToSOAPEnvelope(soapMessageContext, namespaceData);
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.addWSAddressingToResponseOrFaultMessage", "1:461:1.108", (Object)e);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage", "SOAPException whilst trying to add namespace declaration to SOAPEnvelope.");
                }
                throw new JAXRPCException(e);
            }
            writer.addPropertiesToSoapHeader(soapHeader, wsaOutboundProperties);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "addWSAddressingToResponseOrFaultMessage");
            }
        }
    }

    public QName[] getHeaders() {
        return headerElementQNames;
    }

    private void completeNoneURI(MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "completeNoneURI", jaxRpcMsgContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "completeNoneURI", "Need to close client connection as response is targeted to the WSAddressing NoneURI indicating it should be discarded.");
        }
        com.ibm.ws.webservices.engine.MessageContext msgCtxImpl = (com.ibm.ws.webservices.engine.MessageContext)jaxRpcMsgContext;
        try {
            msgCtxImpl.oneWayEvent();
        }
        catch (Throwable t) {
            String message = "Runtime exception when closing connection with client.";
            Tr.warning(TRACE_COMPONENT, "completeNoneURI", message);
            FFDCFilter.processException(t, CLASSNAME, "1:510:1.108");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "completeNoneURI");
        }
    }

    private void completeRedirectionChanges(MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "completeRedirectionChanges", jaxRpcMsgContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "completeRedirectionChanges", "This response is being redirected, need to set it as the request message outbound.");
        }
        com.ibm.ws.webservices.engine.MessageContext msgCtxImpl = (com.ibm.ws.webservices.engine.MessageContext)jaxRpcMsgContext;
        msgCtxImpl.setRequestMessage(msgCtxImpl.getResponseMessage());
        msgCtxImpl.setSOAPActionURI("");
        try {
            if (jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse") != null && jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault") != null) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "completeRedirectionChanges", "Client connection will have been closed by SoapRPCProcessor");
                }
            } else {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "completeRedirectionChanges", "Need to close client connection as response is targeted to a different endpoint.");
                }
                msgCtxImpl.oneWayEvent();
            }
        }
        catch (Throwable t) {
            String message = "Runtime exception when closing connection with client.";
            Tr.warning(TRACE_COMPONENT, "completeRedirectionChanges", message);
            FFDCFilter.processException(t, CLASSNAME, "1:562:1.108");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "completeRedirectionChanges");
        }
    }

    protected boolean addressingDisabledGlobally() {
        return this.wsAddressingDisabled;
    }

    protected void setAddressingDisabledGlobally(boolean active) {
        this.wsAddressingDisabled = active;
    }

    private SOAPFaultException generateSFE() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "generateSFE");
        }
        String message = "A message conforming to WS-Addressing standards was expected but not found";
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.warning(TRACE_COMPONENT, message);
        }
        SOAPFault fault2 = null;
        SOAPFactory sf = new SOAPFactory();
        try {
            fault2 = sf.createSOAPFault();
            fault2.setFaultCode(NamespaceData.getDefaultNamespaceInstance().getMessageAddressingPropertyRequired().toString());
            fault2.setFaultString(message);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.handleRequest", "1:608:1.108", (Object)e);
        }
        String actor = fault2.getFaultActor();
        String faultString = fault2.getFaultString();
        Detail detail = fault2.getDetail();
        QName faultCode = fault2.getFaultCodeAsQName();
        SOAPFaultException sfe = new SOAPFaultException(faultCode, faultString, actor, detail);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "generateSFE");
        }
        return sfe;
    }

    static {
        WSAddressingServerHandler.headerElementQNames[0] = new QName("http://www.w3.org/2005/08/addressing", "MessageID");
        WSAddressingServerHandler.headerElementQNames[1] = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo");
        WSAddressingServerHandler.headerElementQNames[2] = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo");
        WSAddressingServerHandler.headerElementQNames[3] = new QName("http://www.w3.org/2005/08/addressing", "FaultTo");
        WSAddressingServerHandler.headerElementQNames[4] = new QName("http://www.w3.org/2005/08/addressing", "From");
        WSAddressingServerHandler.headerElementQNames[5] = new QName("http://www.w3.org/2005/08/addressing", "To");
        WSAddressingServerHandler.headerElementQNames[6] = new QName("http://www.w3.org/2005/08/addressing", "Action");
    }
}

