/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl;
import com.ibm.ws.wsaddressing.handlers.MessageIDGenerator;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200408;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200508;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import com.ibm.wsspi.wsaddressing.Relationship;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;

public class WSAOutboundProperties {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAOutboundProperties.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private EndpointReference _wsaddressingDestinationEpr = null;
    private EndpointReference _wsaddressingFromEpr = null;
    private EndpointReference _wsaddressingReplyToEpr = null;
    private EndpointReference _wsaddressingFaultToEpr = null;
    private Set _wsaddressingRelationshipSet = null;
    private AttributedURI _wsaddressingAction = null;
    private AttributedURI _wsaddressingMessageId = null;
    private MessageContext _messageContext = null;
    private boolean _wsaPropertyExists = false;
    private NamespaceData _namespaceData = null;
    private AttributedURI _wsaddressingDestinationURI = null;
    private boolean _mustUnderstand = false;

    public boolean wsaPropertyExists() {
        return this._wsaPropertyExists;
    }

    public boolean setMessageContext(MessageContext messageContext) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMessageContextandWSAProperties", messageContext);
        }
        this._messageContext = messageContext;
        if (this._messageContext == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "setMessageContextandWSAProperties", Boolean.FALSE);
            }
            return false;
        }
        this.checkWSAPropertiesExist();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMessageContextandWSAProperties", this._wsaPropertyExists);
        }
        return this._wsaPropertyExists;
    }

    private void checkWSAPropertiesExist() {
        Object destinationObject = this._messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        Object relations = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.relationshipSet");
        Object msgId = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.messageId");
        Object action = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.action");
        Object from = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.fromEPR");
        Object faultTo = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
        Object replyTo = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.replyToEPR");
        this._wsaPropertyExists = destinationObject != null || relations != null || msgId != null || action != null || from != null || faultTo != null || replyTo != null;
    }

    public void setupWSAProperties() throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setupWSAProperties");
        }
        this.setNamespaceData(NamespaceData.addOutboundNamespaceDataToContext(this._messageContext));
        this.instantiateAndValidateReplyToEpr();
        this.instantiateAndValidateFaultToEpr();
        this.instantiateAndValidateFromEpr();
        this.instantiateAndValidateActionAuri();
        this.instantiateAndValidateMessageId();
        this.instantiateAndValidateRelationshipSet();
        this.instantiateAndValidateDestinationEpr();
        this.instantiateAndValidateMustUnderstand();
        if (this._wsaPropertyExists) {
            this.ensureDefaultMAPsOnContext(this._messageContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setupWSAProperties");
        }
    }

    private void ensureDefaultMAPsOnContext(MessageContext msgCtx) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "ensureDefaultMAPsOnContext", msgCtx);
        }
        if (this._wsaddressingReplyToEpr != null) {
            msgCtx.setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._wsaddressingReplyToEpr);
        }
        if (this._wsaddressingDestinationEpr != null) {
            msgCtx.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._wsaddressingDestinationEpr);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "ensureDefaultMAPsOnContext", msgCtx);
        }
    }

    public NamespaceData getNamespaceData() {
        return this._namespaceData;
    }

    private void setNamespaceData(NamespaceData nsd) {
        this._namespaceData = nsd;
    }

    public EndpointReference getWsaddressingReplyToEpr() {
        return this._wsaddressingReplyToEpr;
    }

    public void setWsaddressingReplyToEpr(EndpointReference epr) {
        this._wsaddressingReplyToEpr = epr;
        if (epr != null) {
            this._messageContext.setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", epr);
        }
    }

    protected void setWsaddressingAction(AttributedURI wsaAction) {
        this._wsaddressingAction = wsaAction;
        if (wsaAction != null) {
            this._messageContext.setProperty("com.ibm.wsspi.wsaddressing.action", wsaAction);
        }
    }

    protected void unsetWsaddressingFaultToEpr() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", this._wsaddressingFaultToEpr);
        }
        if (((com.ibm.ws.wsaddressing.integration.EndpointReference)this._wsaddressingFaultToEpr).getReferenceParameters().hasNext()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", "wsaddressingFaultToEpr contains ReferenceParameters.");
            }
            AttributedURI auri = WSAddressingFactory.createAttributedURI(this._namespaceData.getAnonymousURI());
            this._wsaddressingFaultToEpr.setAddress(auri);
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", "wsaddressingFaultToEpr has no ReferenceParameters.");
            }
            this._wsaddressingFaultToEpr = null;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", this._wsaddressingFaultToEpr);
        }
    }

    public AttributedURI getWsaddressingAction() {
        return this._wsaddressingAction;
    }

    public EndpointReference getWsaddressingDestinationEpr() {
        return this._wsaddressingDestinationEpr;
    }

    public AttributedURI getWsaddressingDestinationURI() {
        return this._wsaddressingDestinationURI;
    }

    public EndpointReference getWsaddressingFaultToEpr() {
        return this._wsaddressingFaultToEpr;
    }

    public EndpointReference getWsaddressingFromEpr() {
        return this._wsaddressingFromEpr;
    }

    public AttributedURI getWsaddressingMessageId() {
        return this._wsaddressingMessageId;
    }

    public Set getWsaddressingRelationshipSet() {
        return this._wsaddressingRelationshipSet;
    }

    public boolean mustUnderstand() {
        return this._mustUnderstand;
    }

    /*
     * Unable to fully structure code
     */
    private void instantiateAndValidateDestinationEpr() {
        if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr");
        }
        if ((destinationObject = this._messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR")) == null) {
            messageContext = (com.ibm.ws.webservices.engine.MessageContext)this._messageContext;
            targetURL = messageContext.getTargetEndpointAddressAsURL();
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "WSADDRESSING_DESTINATION_EPR not set.  Attempting to use destination " + targetURL);
            }
            candidateURI = null;
            if (targetURL != null) {
                try {
                    candidateURI = new URI(targetURL.toString());
                }
                catch (URISyntaxException e) {
                    if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Syntax exception setting WSADDRESSING_DESTINATION_EPR for " + targetURL);
                    }
                    candidateURI = this.getAnonIf200408();
                }
            } else {
                candidateURI = this.getAnonIf200408();
            }
            if (candidateURI != null) {
                this._wsaddressingDestinationURI = WSAddressingFactory.createAttributedURI(candidateURI);
                try {
                    this._wsaddressingDestinationEpr = EndpointReferenceManagerImpl.createEndpointReference(this._wsaddressingDestinationURI);
                    if (this._namespaceData == null) ** GOTO lbl36
                    this._wsaddressingDestinationEpr.setNamespace(this._namespaceData.getNamespace());
                }
                catch (EndpointReferenceCreationException e) {
                    if (!WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) ** GOTO lbl36
                    Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Unexpected Syntax exception setting WSADDRESSING_DESTINATION_EPR" + this._wsaddressingDestinationEpr);
                }
                catch (NamespaceNotSupportedException e) {
                    if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Unable to set namespace on detinationEPR");
                    }
                    throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_DESTINATION_EPR namespace not recognized");
                }
            } else if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Allowing null WSADDRESSING_DESTINATION_EPR");
            }
lbl36:
            // 7 sources

            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "instantiateAndValidateDestinationEpr" + candidateURI);
            }
            return;
        }
        if (!(destinationObject instanceof EndpointReference)) {
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "WSADDRESSING_DESTINATION_EPR set by application of type " + destinationObject.getClass().getName());
            }
            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_DESTINATION_EPR not of type EndpointReference");
        }
        destinationEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)destinationObject;
        if (!destinationEPR.validate()) {
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "WSADDRESSING_DESTINATION_EPR is not a valid EndpointReference" + destinationEPR);
            }
            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_DESTINATION_EPR");
        }
        this._wsaddressingDestinationEpr = destinationEPR;
        this._wsaddressingDestinationURI = this._wsaddressingDestinationEpr.getAddress();
        this._wsaPropertyExists = true;
        if (this._wsaddressingDestinationURI == null || this._wsaddressingDestinationURI.getURI() == null) {
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                if (this._wsaddressingDestinationURI == null) {
                    Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Destination is null.");
                } else {
                    Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Destination URL is null.");
                }
            }
            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", null);
            }
            throw new JAXRPCException("WSAddressing Configuration Error: Destination EPR has null URI");
        }
        if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", destinationEPR);
        }
    }

    private void instantiateAndValidateReplyToEpr() {
        Object replyTo;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr");
        }
        if ((replyTo = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.replyToEPR")) == null) {
            if (this._namespaceData instanceof NamespaceData200508 && this._messageContext.containsProperty("com.ibm.ws.wsaddressing.RedirectRequired")) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Using 200508 and async response. No ReplyTo set so setting to the none URI");
                }
                try {
                    EndpointReference epr;
                    URI noneURI = this._namespaceData.getNoneURI();
                    this._wsaddressingReplyToEpr = epr = EndpointReferenceManager.createEndpointReference(noneURI);
                }
                catch (NamespaceNotSupportedException e) {
                    String message = "Caught a NamespaceNotSupportedException: " + e.getMessage();
                    Tr.warning(TRACE_COMPONENT, message);
                    FFDCFilter.processException(e, CLASSNAME, "1:541:1.39");
                }
                catch (EndpointReferenceCreationException e) {
                    String message = "Caught a EndpointReferenceCreationException: " + e.getMessage();
                    Tr.warning(TRACE_COMPONENT, message);
                    FFDCFilter.processException(e, CLASSNAME, "1:546:1.39");
                }
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr", "No ReplyTo EPR found. The None URI may have been added if appropriate.");
            }
            return;
        }
        if (!(replyTo instanceof EndpointReference)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_REPLYTO_EPR set by application of type " + replyTo.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_REPLYTO_EPR not of type EndpointReference");
        }
        com.ibm.ws.wsaddressing.integration.EndpointReference replyToEpr = (com.ibm.ws.wsaddressing.integration.EndpointReference)replyTo;
        if (!replyToEpr.validate()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_REPLYTO_EPR is not a valid EndpointReference", replyToEpr);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_REPLYTO_EPR");
        }
        this._wsaddressingReplyToEpr = replyToEpr;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr", replyToEpr);
        }
    }

    private void instantiateAndValidateFaultToEpr() {
        Object faultTo;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr");
        }
        if ((faultTo = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.faultToEPR")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr", null);
            }
            return;
        }
        if (!(faultTo instanceof EndpointReference)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FAULTTO_EPR set by application of type " + faultTo.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_FAULTTO_EPR not of type EndpointReference");
        }
        com.ibm.ws.wsaddressing.integration.EndpointReference faultToEpr = (com.ibm.ws.wsaddressing.integration.EndpointReference)faultTo;
        if (!faultToEpr.validate()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FAULTTO_EPR is not a valid EndpointReference", faultToEpr);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_FAULTTO_EPR");
        }
        this._wsaddressingFaultToEpr = faultToEpr;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr", faultToEpr);
        }
    }

    private void instantiateAndValidateFromEpr() {
        Object from;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateFromEpr");
        }
        if ((from = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.fromEPR")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", null);
            }
            return;
        }
        if (!(from instanceof EndpointReference)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FROM_EPR set by application of type ", from.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", from);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_FROM_EPR not of type EndpointReference");
        }
        com.ibm.ws.wsaddressing.integration.EndpointReference fromEpr = (com.ibm.ws.wsaddressing.integration.EndpointReference)from;
        if (!fromEpr.validate()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FROM_EPR is not a valid EndpointReference");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", fromEpr);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_FROM_EPR");
        }
        this._wsaddressingFromEpr = fromEpr;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", fromEpr);
        }
    }

    private void instantiateAndValidateActionAuri() {
        Object action;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateActionUri");
        }
        if ((action = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.action")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionAuri", null);
            }
            return;
        }
        if (!(action instanceof AttributedURI)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_ACTION set by application of type ", action.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionAuri", action);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_ACTION not of type AttributedURI");
        }
        AttributedURI actionAuri = (AttributedURI)action;
        if (actionAuri.getURI() == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_ACTION does not contain a URI");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionUri", actionAuri);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_ACTION");
        }
        this._wsaddressingAction = actionAuri;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionUri", actionAuri);
        }
    }

    private void instantiateAndValidateMessageId() {
        Object msgId;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateMessageId");
        }
        if ((msgId = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.messageId")) == null) {
            msgId = WSAddressingFactory.createAttributedURI(URI.create(MessageIDGenerator.newMessageIDAsString()));
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "instantiateAndValidateMessageId. No messageId - found creating own ", msgId);
            }
        } else {
            if (!(msgId instanceof AttributedURI)) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSADDRESSING_MESSAGE_ID set by application of type ", msgId.getClass().getName());
                }
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "instantiateAndValidateMessageId", msgId);
                }
                throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_MESSAGE_ID not of type URI");
            }
            this._wsaPropertyExists = true;
        }
        this._wsaddressingMessageId = (AttributedURI)msgId;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateMessageId", msgId);
        }
    }

    private void instantiateAndValidateRelationshipSet() {
        Object relations;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet");
        }
        if ((relations = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.relationshipSet")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", null);
            }
            return;
        }
        if (!(relations instanceof Set)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_RELATIONSHIP_SET set by application not of type Set");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", relations);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_RELATIONSHIP_SET not of type Set");
        }
        this._wsaddressingRelationshipSet = (Set)relations;
        for (Object rel : this._wsaddressingRelationshipSet) {
            if (rel instanceof Relationship) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_RELATIONSHIP_SET entry set by application not of type Relationship");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", rel);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_RELATIONSHIP_SET entry set by application not of type Relationship");
        }
        this._wsaddressingRelationshipSet = (Set)relations;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", relations);
        }
    }

    private void instantiateAndValidateMustUnderstand() {
        Object mustUnderstand;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand", this._mustUnderstand ? "true" : "false");
        }
        if ((mustUnderstand = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.mustunderstand")) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand. No mustUnderstand found");
            }
        } else if (!(mustUnderstand instanceof Boolean)) {
            Tr.warning(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand.  MustUnderstand not of type Boolean");
        } else {
            this._mustUnderstand = (Boolean)mustUnderstand;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand", this._mustUnderstand ? "true" : "false");
        }
    }

    private URI getAnonIf200408() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAnonIf200408");
        }
        URI result = null;
        if (this._namespaceData instanceof NamespaceData200408) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAnonIf200408", "Setting WSADDRESSING_DESTINATION_EPR to " + this._namespaceData.getAnonymousURI());
            }
            result = this._namespaceData.getAnonymousURI();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAnonIf200408 result[" + result + "]");
        }
        return result;
    }
}

