/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.net.URI;

public class WSAHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    private WSAHelper() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSAHelper");
        }
    }

    public static String getEndpointAddress(EndpointReference epr) {
        URI uri;
        AttributedURI auri;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointAddress", epr);
        }
        if (epr != null && (auri = epr.getAddress()) != null && (uri = auri.getURI()) != null) {
            String s = uri.toString();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getEndpointAddress", s);
            }
            return s;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointAddress");
        }
        return "";
    }

    public static String getAction(AttributedURI auri) {
        URI uri;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getAction", auri);
        }
        if (auri != null && (uri = auri.getURI()) != null) {
            String s = uri.toString();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getAction", s);
            }
            return s;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAction");
        }
        return "";
    }
}

