/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.PersistableSOAPElement;
import com.ibm.ws.wsaddressing.util.IdentityHashCodeComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceParameterHolder
implements Cloneable,
Serializable {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(ReferenceParameterHolder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private ReferenceParameterMap _referenceParameters = new ReferenceParameterMap();

    public Iterator<PersistableSOAPElement> getReferenceParameters() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameters");
        }
        Iterator<PersistableSOAPElement> itForParameters = this._referenceParameters.asList().iterator();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameters", itForParameters);
        }
        return itForParameters;
    }

    public void addReferenceParameter(PersistableSOAPElement referenceParameter) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParameter", referenceParameter);
        }
        this._referenceParameters.put(referenceParameter.getSOAPElement().getElementQName(), referenceParameter);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParameter");
        }
    }

    public void setReferenceParameter(QName name2, String value2) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setReferenceParameter", new Object[]{name2, value2});
        }
        this._referenceParameters.removeAll(name2);
        try {
            SOAPFactory sf = new SOAPFactory();
            SOAPElement element = sf.createElement(name2);
            element.addTextNode(value2);
            this.addReferenceParameter(new PersistableSOAPElement(element));
        }
        catch (SOAPException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "addReferenceParameter");
            }
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".addReferenceParameter", "1:198:1.1", this);
            String msg = "The ReferenceParameter to be created defined by parameters QName : " + name2 + ", and String : " + value2 + ", resulted in a SOAP Exception whilst trying to build an associated SOAPElement";
            throw new ReferenceParameterCreationException(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setReferenceParameter");
        }
    }

    public void setReferenceParameter(QName name2, SOAPElement value2) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{name2, value2};
            Tr.entry(TRACE_COMPONENT, "setReferenceParameter", params);
        }
        this._referenceParameters.removeAll(name2);
        try {
            SOAPFactory sf = new SOAPFactory();
            SOAPElement element = sf.createElement(name2);
            element.addChildElement(value2);
            this.addReferenceParameter(new PersistableSOAPElement(element));
        }
        catch (SOAPException e) {
            Object[] fail = new Object[]{name2, value2};
            String msg = "The ReferenceParameter defined by parameters QName : " + name2 + ", and SOAPElement : " + value2 + ", could not be set as the WName was invalid for creating a ReferenceParameter.";
            Tr.error(TRACE_COMPONENT, msg + e.getMessage(), fail);
            FFDCFilter.processException(e, this.getClass().getName() + ".setReferenceParameter", "1:241:1.1", this, fail);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setReferenceParameter");
        }
    }

    public SOAPElement getSOAPElementReferenceParameter(QName referenceParameterName) {
        SOAPElement nextRefParmSE;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterSOAPElement", referenceParameterName);
        }
        PersistableSOAPElement referenceParameter = this._referenceParameters.getFirst(referenceParameterName);
        SOAPElement referenceParameterValue = null;
        if (referenceParameter != null && (nextRefParmSE = referenceParameter.getSOAPElement()) != null) {
            Iterator childIterator = nextRefParmSE.getChildElements();
            if (childIterator.hasNext()) {
                referenceParameterValue = (SOAPElement)childIterator.next();
            }
            if (childIterator.hasNext() && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "More than one child element found in Reference Parameter");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterSOAPElement", referenceParameterValue);
        }
        return referenceParameterValue;
    }

    public void removeAll(QName key) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeAll", key);
        }
        this._referenceParameters.removeAll(key);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeAll");
        }
    }

    public String getReferenceParameter(QName referenceParameterName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameter", referenceParameterName);
        }
        String referenceParameterValue = null;
        PersistableSOAPElement pse = this._referenceParameters.getFirst(referenceParameterName);
        if (pse != null) {
            referenceParameterValue = pse.getStringValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameter", referenceParameterValue);
        }
        return referenceParameterValue;
    }

    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "clone");
        }
        ReferenceParameterHolder newHolder = (ReferenceParameterHolder)super.clone();
        for (PersistableSOAPElement element : this._referenceParameters.asList()) {
            newHolder.addReferenceParameter(element);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "clone", newHolder);
        }
        return newHolder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReferenceParams[");
        for (PersistableSOAPElement element : this._referenceParameters.asList()) {
            builder.append(element.toString());
        }
        builder.append("]");
        String result = builder.toString();
        return result;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this._referenceParameters == null ? 0 : this._referenceParameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceParameterHolder other = (ReferenceParameterHolder)obj;
        return !(this._referenceParameters == null ? other._referenceParameters != null : !this._referenceParameters.equals(other._referenceParameters));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceParameterMap
    implements Serializable {
        HashMap<QName, ArrayList<PersistableSOAPElement>> map = new HashMap();
        IdentityHashCodeComparator comparator = new IdentityHashCodeComparator();

        private ReferenceParameterMap() {
        }

        public void put(QName key, PersistableSOAPElement value2) {
            ArrayList<PersistableSOAPElement> values;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "put", new Object[]{key, value2});
            }
            if ((values = this.map.get(key)) == null) {
                values = new ArrayList();
                this.map.put(key, values);
            }
            values.add(value2);
            Collections.sort(values, this.comparator);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "put");
            }
        }

        public PersistableSOAPElement getFirst(QName key) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getFirst", new Object[]{key});
            }
            PersistableSOAPElement result = null;
            ArrayList<PersistableSOAPElement> values = this.map.get(key);
            if (values != null && !values.isEmpty()) {
                result = values.get(0);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getFirst", result);
            }
            return result;
        }

        public void removeAll(QName key) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "removeAll", new Object[]{key});
            }
            this.map.remove(key);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "removeAll");
            }
        }

        public List<PersistableSOAPElement> asList() {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "asList");
            }
            ArrayList<PersistableSOAPElement> values = new ArrayList<PersistableSOAPElement>();
            for (ArrayList<PersistableSOAPElement> list : this.map.values()) {
                values.addAll(list);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "asList", values);
            }
            return values;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceParameterMap other = (ReferenceParameterMap)obj;
            return !(this.map == null ? other.map != null : !this.map.equals(other.map));
        }
    }
}

