/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.xml;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.xml.BaseType;
import com.ibm.ws.webservices.xml.ComplexType;
import com.ibm.ws.webservices.xml.DOMWriter;
import com.ibm.ws.webservices.xml.SimpleType;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Factory
implements Serializable {
    private static final TraceComponent _tc = Tr.register(BaseType.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    protected String xmlFile;
    protected String packageName;
    protected Document document;
    protected String encoding;
    protected String encodingTag;
    protected String dtdFileName;
    protected String dtdPublicId;
    protected String xsdFileName;
    protected String xsdNamespaceURI;
    protected Hashtable importedFileHashtable = new Hashtable();
    protected String rootElementName;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setXMLFilename(String filename) {
        this.xmlFile = filename;
    }

    public String getXMLFilename() {
        return this.xmlFile;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncodingTag(String encodingTag) {
        this.encodingTag = encodingTag;
    }

    public String getEncodingTag(String encodingTag) {
        return encodingTag;
    }

    public void setDTDFileName(String dtdFilename) {
        this.dtdFileName = dtdFilename;
    }

    public String getDTDFileName() {
        return this.dtdFileName;
    }

    public void setPublicId(String publicId) {
        this.dtdPublicId = publicId;
    }

    public String getPublicId() {
        return this.dtdPublicId;
    }

    public void setXSDFileName(String xsdFilename) {
        this.xsdFileName = xsdFilename;
    }

    public String getXSDFileName() {
        return this.xsdFileName;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.xsdNamespaceURI = namespaceURI;
    }

    public String getNamespaceURI() {
        return this.xsdNamespaceURI;
    }

    public void addImportedFileInfo(String filename, String nsprefix, String nsURI) {
        this.importedFileHashtable.put(nsprefix, nsURI + " " + filename);
    }

    public BaseType loadDocument(String classname, String xmlFile) {
        this.xmlFile = xmlFile;
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Object doc = null;
        try {
            docBuilder = factory.newDocumentBuilder();
            this.document = docBuilder.parse(xmlFile);
            Element rootElement = this.document.getDocumentElement();
            return this.newInstance(rootElement, classname);
        }
        catch (ParserConfigurationException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.Factory.loadDocument", "208", this);
            Tr.error(_tc, "internal.error", ex);
            return null;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.xml.Factory.loadDocument", "212", this);
            Tr.error(_tc, "internal.error", e);
            return null;
        }
    }

    public BaseType loadDocument(String classname, InputSource source) {
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Object doc = null;
        try {
            docBuilder = factory.newDocumentBuilder();
            this.document = docBuilder.parse(source);
            Element rootElement = this.document.getDocumentElement();
            return this.newInstance(rootElement, classname);
        }
        catch (ParserConfigurationException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.Factory.loadDocument", "232", this);
            Tr.error(_tc, "internal.error", ex);
            return null;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.xml.Factory.loadDocument", "236", this);
            Tr.error(_tc, "internal.error", e);
            return null;
        }
    }

    public BaseType loadDocument(String classname, Element element) {
        try {
            ComplexType domElement = (ComplexType)this.newInstance(element, classname);
            return domElement;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.xml.Factory.loadDocument", "250", this);
            Tr.error(_tc, "internal.error", e);
            return null;
        }
    }

    public void save(String filename) {
        String outputEncoding = this.encoding != null && !this.encoding.equals("") ? this.encoding : "UTF8";
        new DOMWriter(this.document, filename, outputEncoding, this.encodingTag, this.getDocTypeString());
    }

    public void save() {
        if (this.xmlFile != null) {
            String outputEncoding = this.encoding != null && !this.encoding.equals("") ? this.encoding : "UTF8";
            new DOMWriter(this.document, this.xmlFile, outputEncoding, this.encodingTag, this.getDocTypeString());
        }
    }

    public ComplexType createRootDOMFromComplexType(String classname, String rootElementName) {
        return (ComplexType)this.createRootDOMHelper(classname, rootElementName);
    }

    public SimpleType createRootDOMFromSimpleType(String classname, String rootElementName) {
        return (SimpleType)this.createRootDOMHelper(classname, rootElementName);
    }

    private Object createRootDOMHelper(String classname, String rootElementName) {
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Object doc = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.Factory.createRootDOMHelper", "319", this);
            Tr.error(_tc, "internal.error", ex);
            return null;
        }
        this.document = docBuilder.newDocument();
        this.rootElementName = rootElementName;
        Element childElement = this.document.createElement(rootElementName);
        this.document.appendChild(childElement);
        if (this.xsdFileName != null && !this.xsdFileName.equals("")) {
            childElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (this.xsdNamespaceURI != null && !this.xsdNamespaceURI.equals("")) {
                int index = rootElementName.indexOf(":");
                if (index > 0) {
                    String prefix = ":" + rootElementName.substring(0, index);
                    childElement.setAttribute("xmlns" + prefix, this.xsdNamespaceURI);
                } else {
                    childElement.setAttribute("xmlns", this.xsdNamespaceURI);
                }
                Enumeration vEnum = this.importedFileHashtable.keys();
                String importedFileValidation = "";
                while (vEnum.hasMoreElements()) {
                    Object nsprefix = vEnum.nextElement();
                    String nsURI = (String)this.importedFileHashtable.get(nsprefix);
                    int blank = nsURI.indexOf(32);
                    childElement.setAttribute("xmlns:" + nsprefix, nsURI.substring(0, blank));
                    importedFileValidation = importedFileValidation + " " + nsURI;
                }
                childElement.setAttribute("xsi:schemaLocation", this.xsdNamespaceURI + " " + this.xsdFileName + importedFileValidation);
            } else {
                childElement.setAttribute("xsi:noNamespaceSchemaLocation", this.xsdFileName);
            }
        }
        return this.newInstance(childElement, classname);
    }

    public ComplexType createDOMElementFromComplexType(String classname, String elementName) {
        Element childElement = this.document.createElement(elementName);
        return (ComplexType)this.newInstance(childElement, classname);
    }

    public SimpleType createDOMElementFromSimpleType(String classname, String elementName) {
        Element childElement = this.document.createElement(elementName);
        return (SimpleType)this.newInstance(childElement, classname);
    }

    protected BaseType newInstance(Node node, String className) {
        try {
            String fullname = className;
            if (this.packageName != null && !this.packageName.equals("")) {
                fullname = this.packageName + "." + className;
            }
            Class<?> javaClass = Class.forName(fullname);
            BaseType object = (BaseType)javaClass.newInstance();
            if (node instanceof Element) {
                object.setXMLElement((Element)node);
            } else {
                object.setXMLAttribute((Attr)node);
            }
            object.setFactory(this);
            return object;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.xml.Factory.newInstance", "432", this);
            Tr.error(_tc, "internal.error", e);
            return null;
        }
    }

    protected Element createXMLElementAndText(String elementName, String elementValue) {
        Element item = this.document.createElement(elementName);
        Text text = this.document.createTextNode(elementValue);
        item.appendChild(text);
        return item;
    }

    protected Attr createAttribute(String name2, Element parentElement) {
        Attr attrNode = this.document.createAttribute(name2);
        parentElement.setAttributeNode(attrNode);
        return attrNode;
    }

    protected Text createText(Element parentElement, String value2) {
        Text textNode = this.document.createTextNode(value2);
        parentElement.appendChild(textNode);
        return textNode;
    }

    protected String getDocTypeString() {
        String docType = "";
        if (this.dtdFileName != null && !this.dtdFileName.equals("")) {
            if (this.dtdPublicId == null || this.dtdPublicId.equals("")) {
                this.dtdPublicId = this.rootElementName + "Id";
            }
            docType = "<!DOCTYPE " + this.rootElementName + " PUBLIC \"" + this.dtdPublicId + "\"" + " \"" + this.dtdFileName + "\"" + ">";
        }
        return docType;
    }
}

