/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;

public class JavaServiceImplWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "Locator", "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        return "extends com.ibm.ws.webservices.multiprotocol.AgnosticService ";
    }

    protected String getImplementsText() {
        return "implements com.ibm.ws.webservices.multiprotocol.GeneratedService, " + this.sEntry.getName() + ' ';
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(pw, service.getDocumentationElement());
        this.writeConstructor(pw, this.className, service.getQName());
        Vector<String> getPortIfaces = new Vector<String>();
        Vector<String> getPortStubClasses = new Vector<String>();
        Vector<String> getPortPortNames = new Vector<String>();
        Vector<String> getPortLocalNames = new Vector<String>();
        boolean printGetPortNotice = false;
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            Boolean isNonBoundWSDL;
            String address;
            PortEntry pe = this.sEntry.getPort(i);
            Port p = pe.getPort();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            String wsdlPortName = pe.getQName().getLocalPart();
            String javifiedPortName = JavaUtils.xmlNameToJava(wsdlPortName);
            String stubClass = bEntry.getName() + "Stub";
            String seiName = (String)bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
            if (getPortIfaces.contains(seiName)) {
                printGetPortNotice = true;
            }
            if ((address = pe.getAddress()) == null && ((isNonBoundWSDL = (Boolean)this.sEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL)) == null || !isNonBoundWSDL.booleanValue())) continue;
            getPortIfaces.add(seiName);
            getPortStubClasses.add(stubClass);
            getPortPortNames.add(javifiedPortName);
            getPortLocalNames.add(p.getName());
            this.writeAddressInfo(pw, javifiedPortName, address, p);
            String fieldPortName = JavaUtils.xmlNameToJava(wsdlPortName) + "PortName";
            this.writePortNameInfo(pw, fieldPortName, wsdlPortName);
            String wsddPortName = javifiedPortName + "WSDDPortName";
            this.writeWSDDPortNameInfo(pw, wsddPortName, wsdlPortName);
            this.writeGetPortName(pw, seiName, javifiedPortName);
            this.writeGetPortNameURL(pw, seiName, javifiedPortName, stubClass, wsddPortName, fieldPortName);
        }
        this.writeGetPortClass(pw, getPortIfaces, getPortStubClasses, getPortPortNames, printGetPortNotice);
        this.writeGetPortQNameClass(pw, getPortPortNames, getPortLocalNames);
        this.writeSetPortNamePrefix(pw, getPortPortNames, getPortLocalNames);
        this.writeGetServiceName(pw, this.sEntry.getQName());
        this.writeGetPort2NamespaceMap(pw, this.sEntry);
        this.writeGetPorts(pw);
        this.writeGetCalls(pw);
    }

    protected void writeConstructor(PrintWriter pw, String className, QName serviceName) {
        pw.println();
        pw.println("    public " + className + "() {");
        pw.println("        super(com.ibm.ws.webservices.engine.utils.QNameTable.createQName(");
        pw.println("           \"" + serviceName.getNamespaceURI() + "\",");
        pw.println("           \"" + serviceName.getLocalPart() + "\"));");
        pw.println();
        pw.println("        context.setLocatorName(\"" + this.packageName + "." + className + "\");");
        pw.println("    }");
        pw.println();
        pw.println("    public " + className + "(com.ibm.ws.webservices.multiprotocol.ServiceContext ctx) {");
        pw.println("        super(ctx);");
        pw.println("        context.setLocatorName(\"" + this.packageName + "." + className + "\");");
        pw.println("    }");
    }

    protected void writeAddressInfo(PrintWriter pw, String portName, String address, Port p) {
        boolean addressIsValid = true;
        try {
            new URL(address);
        }
        catch (MalformedURLException e) {
            addressIsValid = false;
        }
        pw.println();
        pw.println("    // " + Messages.getMessage("getProxy00", portName));
        this.writeComment(pw, p.getDocumentationElement());
        if (!addressIsValid) {
            pw.println("    // NOTE: The following address is INVALID.  It MUST be overridden by either specifying a URL on the getPort calls");
            pw.println("    //       or by specifing an overriddenEndpointURI on a portQnameBindings element in the webservices client binding file");
        }
        pw.println("    private final java.lang.String " + portName + "_address = \"" + address + "\";");
        pw.println();
        pw.println("    public java.lang.String get" + JavaUtils.capitalizeFirstChar(portName) + "Address() {");
        pw.println("        if (context.getOverriddingEndpointURIs() == null) {");
        pw.println("            return " + portName + "_address;");
        pw.println("        }");
        pw.println("        String overriddingEndpoint = (String) context.getOverriddingEndpointURIs().get(\"" + p.getName() + "\");");
        pw.println("        if (overriddingEndpoint != null) {");
        pw.println("            return overriddingEndpoint;");
        pw.println("        }");
        pw.println("        else {");
        pw.println("            return " + portName + "_address;");
        pw.println("        }");
        pw.println("    }");
        pw.println();
    }

    protected void writePortNameInfo(PrintWriter pw, String fieldName, String portName) {
        pw.println("    private java.lang.String " + fieldName + " = \"" + portName + "\";");
        pw.println();
    }

    protected void writeWSDDPortNameInfo(PrintWriter pw, String wsddPortName, String portName) {
        pw.println("    // " + Messages.getMessage("wsddPortName00"));
        pw.println("    private java.lang.String " + wsddPortName + " = \"" + portName + "\";");
        pw.println();
        String cappedWSDDPortName = JavaUtils.capitalizeFirstChar(wsddPortName);
        pw.println("    public java.lang.String get" + cappedWSDDPortName + "() {");
        pw.println("        return " + wsddPortName + ";");
        pw.println("    }");
        pw.println();
        pw.println("    public void set" + cappedWSDDPortName + "(java.lang.String name) {");
        pw.println("        " + wsddPortName + " = name;");
        pw.println("    }");
        pw.println();
    }

    protected void writeSetPortNamePrefix(PrintWriter pw, Vector getPortPortNames, Vector getPortLocalNames) {
        pw.println("    public void setPortNamePrefix(java.lang.String prefix) {");
        for (int i = 0; i < getPortPortNames.size(); ++i) {
            String javifiedPortName = (String)getPortPortNames.get(i);
            String wsddPortName = javifiedPortName + "WSDDPortName";
            String portName = javifiedPortName + "PortName";
            pw.println("        " + wsddPortName + " = prefix + \"/\" + " + portName + ";");
        }
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortName(PrintWriter pw, String seiName, String portName) {
        String cappedPortName = JavaUtils.capitalizeFirstChar(portName);
        pw.println("    public " + seiName + " get" + cappedPortName + "() throws " + ServiceException.class.getName() + " {");
        pw.println("       java.net.URL endpoint;");
        pw.println("        try {");
        pw.println("            endpoint = new java.net.URL(get" + JavaUtils.capitalizeFirstChar(portName) + "Address());");
        pw.println("        }");
        pw.println("        catch (java.net.MalformedURLException e) {");
        pw.println("            return null; // " + Messages.getMessage("unlikely00"));
        pw.println("        }");
        pw.println("        return get" + cappedPortName + "(endpoint);");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortNameURL(PrintWriter pw, String seiName, String jPortName, String stubClass, String wsddPortName, String fieldPortName) {
        jPortName = JavaUtils.capitalizeFirstChar(jPortName);
        pw.println("    public " + seiName + " get" + jPortName + "(java.net.URL portAddress) throws " + ServiceException.class.getName() + " {");
        pw.println("        " + seiName + " _stub =");
        pw.println("            (" + seiName + ") getStub(");
        pw.println("                " + fieldPortName + ",");
        pw.println("                (String) getPort2NamespaceMap().get(" + fieldPortName + "),");
        pw.println("                " + seiName + ".class,");
        pw.println("                \"" + stubClass + "\",");
        pw.println("                portAddress.toString());");
        pw.println("        if (_stub instanceof com.ibm.ws.webservices.engine.client.Stub) {");
        pw.println("            ((com.ibm.ws.webservices.engine.client.Stub) _stub).setPortName(" + wsddPortName + ");");
        pw.println("        }");
        pw.println("        return _stub;");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortClass(PrintWriter pw, Vector getPortIfaces, Vector getPortStubClasses, Vector getPortPortNames, boolean printGetPortNotice) {
        pw.println("    /**");
        pw.println("     * " + Messages.getMessage("getPortDoc00"));
        pw.println("     * " + Messages.getMessage("getPortDoc01"));
        pw.println("     * " + Messages.getMessage("getPortDoc02"));
        if (printGetPortNotice) {
            pw.println("     * " + Messages.getMessage("getPortDoc03"));
            pw.println("     * " + Messages.getMessage("getPortDoc04"));
        }
        pw.println("     */");
        pw.println("    public java.rmi.Remote getPort(Class serviceEndpointInterface) throws " + ServiceException.class.getName() + " {");
        if (getPortIfaces.size() == 0) {
            pw.println("        throw new " + ServiceException.class.getName() + "(\"" + Messages.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        } else {
            pw.println("        try {");
            HashSet ifacesSet = new HashSet(getPortIfaces);
            Iterator i = ifacesSet.iterator();
            while (i.hasNext()) {
                String iface = (String)i.next();
                pw.println("            if (" + iface + ".class.isAssignableFrom(serviceEndpointInterface)) {");
                ArrayList<Integer> al = new ArrayList<Integer>();
                for (int j = 0; j < getPortIfaces.size(); ++j) {
                    if (!getPortIfaces.elementAt(j).equals(iface)) continue;
                    al.add(new Integer(j));
                }
                if (al.size() == 1) {
                    int k = (Integer)al.get(0);
                    String portName = (String)getPortPortNames.get(k);
                    pw.println("                return get" + JavaUtils.capitalizeFirstChar(portName) + "();");
                } else {
                    if (al.size() == getPortIfaces.size()) {
                        pw.println("                javax.xml.namespace.QName portName = getDefaultPortQName(serviceEndpointInterface, getPort2NamespaceMap());");
                    } else {
                        pw.println("                java.util.Map m = new java.util.HashMap();");
                        Iterator j = al.iterator();
                        while (j.hasNext()) {
                            int k = (Integer)j.next();
                            String portName = (String)getPortPortNames.elementAt(k);
                            pw.println("                m.put(\"" + portName + "\", getPort2NamespaceMap().get(\"" + portName + "\"));");
                        }
                        pw.println("                javax.xml.namespace.QName portName = getDefaultPortQName(serviceEndpointInterface, m);");
                    }
                    pw.println("                return getPort(portName, serviceEndpointInterface);");
                }
                pw.println("            }");
            }
            pw.println("        }");
            pw.println("        catch (java.lang.Throwable t) {");
            pw.println("            throw new " + ServiceException.class.getName() + "(t);");
            pw.println("        }");
            pw.println("        throw new " + ServiceException.class.getName() + "(\"" + Messages.getMessage("noStub") + "  \" + (serviceEndpointInterface == null ? \"null\" : serviceEndpointInterface.getName()));");
        }
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPortQNameClass(PrintWriter pw, Vector getPortPortNames, Vector getPortLocalNames) {
        pw.println("    /**");
        pw.println("     * " + Messages.getMessage("getPortDoc00"));
        pw.println("     * " + Messages.getMessage("getPortDoc01"));
        pw.println("     * " + Messages.getMessage("getPortDoc02"));
        pw.println("     */");
        pw.println("    public java.rmi.Remote getPort(javax.xml.namespace.QName portName, Class serviceEndpointInterface) throws javax.xml.rpc.ServiceException {");
        pw.println("        String inputPortName = portName.getLocalPart();");
        pw.print("        ");
        for (int i = 0; i < getPortPortNames.size(); ++i) {
            String portName = (String)getPortLocalNames.get(i);
            String javifiedPortName = (String)getPortPortNames.get(i);
            pw.println("if (\"" + portName + "\".equals(inputPortName)) {");
            pw.println("            return get" + JavaUtils.capitalizeFirstChar(javifiedPortName) + "();");
            pw.println("        }");
            pw.print("        else ");
        }
        pw.println(" {");
        pw.println("            throw new javax.xml.rpc.ServiceException();");
        pw.println("        }");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetServiceName(PrintWriter pw, QName qname) {
        pw.println("    public javax.xml.namespace.QName getServiceName() {");
        pw.println("        return " + Utils.getNewQName(qname) + ";");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPort2NamespaceMap(PrintWriter pw, ServiceEntry sEntry) {
        pw.println("    private java.util.Map port2NamespaceMap = null;");
        pw.println();
        pw.println("    protected synchronized java.util.Map getPort2NamespaceMap() {");
        pw.println("        if (port2NamespaceMap == null) {");
        pw.println("            port2NamespaceMap = new java.util.HashMap();");
        for (int i = 0; i < sEntry.numPorts(); ++i) {
            PortEntry pe = sEntry.getPort(i);
            Boolean isNonBoundWSDL = (Boolean)sEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL);
            if (pe.getAddress() == null && (isNonBoundWSDL == null || !isNonBoundWSDL.booleanValue())) continue;
            Port port2 = pe.getPort();
            Binding binding = port2.getBinding();
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            String namespace = null;
            if (bEntry != null) {
                namespace = (String)bEntry.getDynamicVar(BindingEntry.BINDING_NAMESPACE);
            }
            pw.println("            port2NamespaceMap.put(");
            pw.println("               \"" + pe.getQName().getLocalPart() + "\",");
            pw.println("               \"" + namespace + "\");");
        }
        pw.println("        }");
        pw.println("        return port2NamespaceMap;");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetPorts(PrintWriter pw) {
        pw.println("    private java.util.HashSet ports = null;");
        pw.println();
        pw.println("    public java.util.Iterator getPorts() {");
        pw.println("        if (ports == null) {");
        pw.println("            ports = new java.util.HashSet();");
        pw.println("            String serviceNamespace = getServiceName().getNamespaceURI();");
        pw.println("            for (java.util.Iterator i = getPort2NamespaceMap().keySet().iterator(); i.hasNext(); ) {");
        pw.println("                ports.add(");
        pw.println("                    com.ibm.ws.webservices.engine.utils.QNameTable.createQName(");
        pw.println("                        serviceNamespace,");
        pw.println("                        (String) i.next()));");
        pw.println("            }");
        pw.println("        }");
        pw.println("        return ports.iterator();");
        pw.println("    }");
        pw.println();
    }

    protected void writeGetCalls(PrintWriter pw) {
        pw.println("    public javax.xml.rpc.Call[] getCalls(javax.xml.namespace.QName portName) throws javax.xml.rpc.ServiceException {");
        pw.println("        if (portName == null) {");
        pw.println("            throw new javax.xml.rpc.ServiceException(\"" + Messages.getMessage("badPort00") + "\");");
        pw.println("        }");
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            Boolean isNonBoundWSDL;
            PortEntry pe = this.sEntry.getPort(i);
            if (pe.getAddress() == null && ((isNonBoundWSDL = (Boolean)this.sEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL)) == null || !isNonBoundWSDL.booleanValue())) continue;
            Port port2 = pe.getPort();
            if (i == 0) {
                pw.print("        if ");
            } else {
                pw.print("        else if ");
            }
            pw.println(" (portName.getLocalPart().equals(\"" + port2.getName() + "\")) {");
            pw.println("            return new javax.xml.rpc.Call[] {");
            Iterator operations = port2.getBinding().getBindingOperations().iterator();
            while (operations.hasNext()) {
                BindingOperation bOp = (BindingOperation)operations.next();
                Input input = bOp.getOperation().getInput();
                if (input == null) {
                    pw.println("                createCall(portName, \"" + bOp.getName() + "\"),");
                    continue;
                }
                pw.println("                createCall(portName, \"" + bOp.getName() + "\", \"" + input.getName() + "\"),");
            }
            pw.println("            };");
            pw.println("        }");
        }
        pw.println("        else {");
        pw.println("            throw new javax.xml.rpc.ServiceException(\"" + Messages.getMessage("badPort00") + "\");");
        pw.println("        }");
        pw.println("    }");
    }
}

