/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Scenario;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.rpc.holders.BooleanHolder;

public class JavaImplWriter
extends JavaClassWriter {
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, (String)symbolTable.getPortTypeEntry(bEntry.getBinding().getPortType().getQName()).getDynamicVar(JavaGeneratorFactory.IMPL_NAME), "templateImpl");
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bEntry;
    }

    public void generate() throws IOException {
        if (this.emitter.getScenario() == Scenario.WRD_BOTTOM_UP_SERVER) {
            return;
        }
        if (!this.isFileGenerated(this.getFileName())) {
            super.generate();
        }
    }

    protected void writeHeaderComments(PrintWriter pw) throws IOException {
        super.writeHeaderComments(pw);
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            Binding binding = this.bEntry.getBinding();
            Definition definition = this.emitter.getCurrentDefinition();
            pw.println("/**");
            pw.print(" * @WebSphere.WebService wsdlLocation=\"" + this.emitter.getWSDLURI() + "\"");
            pw.print(" targetNamespace=\"" + definition.getTargetNamespace() + "\"");
            pw.print(" name=\"" + binding.getPortType().getQName().getLocalPart() + "\"");
            Map serviceMap = this.symbolTable.getServices();
            boolean foundService = false;
            Iterator serviceIterator = serviceMap.values().iterator();
            block0: while (serviceIterator.hasNext() && !foundService) {
                Service myService = (Service)serviceIterator.next();
                Map portMap = myService.getPorts();
                Iterator portIterator = portMap.values().iterator();
                while (portIterator.hasNext()) {
                    Port p = (Port)portIterator.next();
                    if (p.getBinding() != binding) continue;
                    pw.println(" serviceName=\"" + myService.getQName().getLocalPart() + "\"");
                    foundService = true;
                    break;
                }
                if (!foundService) continue;
                boolean bindingWritten = false;
                PortType bindingPortType = binding.getPortType();
                Iterator portIterator2 = portMap.values().iterator();
                while (portIterator2.hasNext()) {
                    Port p = (Port)portIterator2.next();
                    if (p.getBinding().getPortType() == bindingPortType) {
                        bindingWritten = this.writeBindingAnnotation(pw, p);
                    }
                    if (!bindingWritten) continue;
                    continue block0;
                }
            }
            if (this instanceof JavaEJBImplWriter) {
                pw.print(" * @ejb.bean name=\"");
                pw.print(binding.getPortType().getQName().getLocalPart());
                pw.print('\"');
                pw.println(" type=StateLess");
            }
            pw.println(" */");
            pw.println();
        }
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        List operations = this.binding.getBindingOperations();
        for (int i = 0; i < operations.size(); ++i) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            BindingOperationEntry boe = this.bEntry.getOperation(ptOperation);
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                pw.println();
                continue;
            }
            this.writeOperation(pw, boe);
        }
    }

    protected String getImplementsText() {
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            return "";
        }
        String portTypeName = (String)this.bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        String implementsText = "implements " + portTypeName;
        return implementsText;
    }

    protected void writeOperation(PrintWriter pw, BindingOperationEntry boe) throws IOException {
        String signature = (String)boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        if (this.emitter.getScenario() == Scenario.WRD_TOP_DOWN_SERVER) {
            pw.println("    /**");
            pw.println("     * @WebSphere.WebMethod");
            pw.println("     */");
            String toRemove = " throws java.rmi.RemoteException";
            if (signature.endsWith(toRemove)) {
                signature = signature.substring(0, signature.length() - toRemove.length());
            } else {
                int rpos;
                String throwsString = "throws ";
                String remoteString = "java.rmi.RemoteException, ";
                int tpos = signature.lastIndexOf(throwsString);
                if (tpos != -1 && (rpos = signature.lastIndexOf(remoteString)) > tpos) {
                    signature = signature.substring(0, tpos += throwsString.length()) + signature.substring(rpos += remoteString.length());
                }
            }
        }
        pw.println(signature + " {");
        for (int i = 0; i < boe.numParameters(); ++i) {
            BindingParamEntry param = boe.getParameter(i);
            if (param.getMode() != 2) continue;
            BooleanHolder bThrow = new BooleanHolder(false);
            String constructorString = Utils.getConstructorForParam(param, this.symbolTable, bThrow, this.emitter);
            if (bThrow.value) {
                pw.println("        try {");
            }
            pw.println("        " + param.getName() + ".value = " + constructorString + ";");
            if (!bThrow.value) continue;
            pw.println("        } catch (Exception e) {");
            pw.println("        }");
        }
        if (boe.getReturn() != null) {
            pw.print("        return ");
            if (boe.getReturn().getMIMEType() != null) {
                pw.println("null;");
            } else {
                String paramType = (String)boe.getReturn().getDynamicVar("parameterType");
                if (Utils.isPrimitiveType(paramType)) {
                    if ("boolean".equals(paramType)) {
                        pw.println("false;");
                    } else if ("byte".equals(paramType)) {
                        pw.println("(byte)-3;");
                    } else if ("short".equals(paramType)) {
                        pw.println("(short)-3;");
                    } else {
                        pw.println("-3;");
                    }
                } else {
                    pw.println("null;");
                }
            }
        }
        pw.println("    }");
        pw.println();
    }

    protected boolean writeBindingAnnotation(PrintWriter pw, Port port2) {
        Binding binding_ = port2.getBinding();
        BindingEntry bEntry_ = this.symbolTable.getBindingEntry(binding_.getQName());
        int bt = bEntry_.getBindingType();
        if (bt == 0) {
            String bindingName = binding_.getQName().getLocalPart();
            pw.print(" * @WebSphere.SOAPBinding");
            pw.print(" bindingName=\"" + bindingName + "\"");
            if (port2 != null) {
                pw.print(" portName=\"" + port2.getName() + "\"");
            }
            BindingOperationEntry boe = this.findRepresentativeOperation(bEntry_);
            pw.print(" style=");
            if (bEntry_.getBindingStyle() == Style.DOCUMENT) {
                pw.print("DOCUMENT");
                if (boe != null && !boe.isWrapped()) {
                    pw.print(" parameterStyle=BARE");
                }
            } else {
                pw.print("RPC");
                if (boe != null) {
                    pw.print(" use=");
                    if (boe.getInputBodyUse() == Use.ENCODED) {
                        pw.print("ENCODED");
                    } else {
                        pw.print("LITERAL");
                    }
                }
            }
            pw.println();
            return true;
        }
        return false;
    }

    protected BindingOperationEntry findRepresentativeOperation(BindingEntry bEntry_) {
        List operations = this.binding.getBindingOperations();
        for (int i = 0; i < operations.size(); ++i) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            BindingOperationEntry boe = bEntry_.getOperation(ptOperation);
            if (type != OperationType.REQUEST_RESPONSE && type != OperationType.ONE_WAY) continue;
            return boe;
        }
        return null;
    }
}

