/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class JavaFaultWriter
extends JavaClassWriter {
    private MessageEntry faultMessage;
    private SymbolTable symbolTable;

    protected JavaFaultWriter(Emitter emitter, SymbolTable symbolTable, MessageEntry faultMessage) {
        super(emitter, faultMessage.getName(), "fault");
        this.symbolTable = symbolTable;
        this.faultMessage = faultMessage;
    }

    protected String getExtendsText() {
        return "extends java.lang.Exception";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        ChildEntry ce;
        int i;
        Vector childEntrys = new Vector();
        Vector partNames = new Vector();
        JavaFaultWriter.getTypesAndNames(this.faultMessage, childEntrys, partNames, this.emitter);
        for (i = 0; i < childEntrys.size(); ++i) {
            ce = (ChildEntry)childEntrys.elementAt(i);
            String typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
            String variable = (String)partNames.elementAt(i);
            pw.println("    private " + typeName + " " + variable + ";");
            pw.println("    public " + typeName + " " + JavaBeanWriter.getterMethodName(ce) + "() {");
            pw.println("        return this." + variable + ";");
            pw.println("    }");
        }
        pw.println();
        pw.println("    public " + this.className + "() {");
        pw.println("    }");
        pw.println();
        if (childEntrys.size() > 0) {
            pw.print("    public " + this.className + "(");
            for (i = 0; i < childEntrys.size(); ++i) {
                if (i != 0) {
                    pw.print(", ");
                }
                ce = (ChildEntry)childEntrys.elementAt(i);
                String variable = (String)partNames.elementAt(i);
                pw.print(ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE) + " " + variable);
            }
            pw.println(") {");
            for (i = 0; i < partNames.size(); ++i) {
                String variable = (String)partNames.elementAt(i);
                pw.println("        this." + variable + " = " + variable + ";");
            }
            pw.println("    }");
        }
    }

    static void getTypesAndNames(MessageEntry me, Vector childEntrys, Vector paramNames, Emitter emitter) {
        ArrayList order;
        HashMap<String, ChildFaultPartEntry> childEntryMap = new HashMap<String, ChildFaultPartEntry>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        Vector children = me.getFaultParts();
        if (children != null) {
            for (int j = 0; j < children.size(); ++j) {
                ChildFaultPartEntry child = (ChildFaultPartEntry)children.get(j);
                String key = child.getQName().getLocalPart();
                childEntryMap.put(key, child);
                nameMap.put(key, child.getName());
            }
        }
        if ((order = (ArrayList)me.getDynamicVar("constructorOrder")) != null) {
            for (int i = 0; i < order.size(); ++i) {
                if (nameMap.get(order.get(i)) == null) {
                    emitter.getToolEnv().reportFatalErr(Messages.getMessage("faultParam00", (String)order.get(i), me.getName()));
                    continue;
                }
                childEntrys.add(childEntryMap.get(order.get(i)));
                paramNames.add(nameMap.get(order.get(i)));
            }
        }
    }
}

