/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class JavaDeployGenerator
implements Generator {
    protected Emitter emitter;
    protected Definition definition;
    protected SymbolTable symbolTable;
    private Vector typeMappings;
    private Vector operations;
    private HashMap typeMappingsByPort = new HashMap();
    private HashMap operationsByPort = new HashMap();
    public static final String QUERY_TYPEMAPPINGS = "queryTypeMappings";
    public static final String QUERY_OPERATIONS = "queryOperations";
    private boolean isDeploy = true;

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean deployOnly) {
        this.isDeploy = deployOnly;
    }

    public JavaDeployGenerator(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        this.processServices();
    }

    private void processServices() throws IOException {
        Map serviceMap = this.symbolTable.getServices();
        Iterator mapIterator = serviceMap.values().iterator();
        while (mapIterator.hasNext()) {
            Service myService = (Service)mapIterator.next();
            Iterator portIterator = myService.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port myPort = (Port)portIterator.next();
                BindingEntry bEntry = this.symbolTable.getBindingEntry(myPort.getBinding().getQName());
                if (bEntry.getBindingType() != 0) continue;
                this.processPort(myPort, myService, bEntry);
            }
        }
    }

    private void processPort(Port port2, Service service, BindingEntry bEntry) throws IOException {
        this.typeMappings = new Vector();
        this.operations = new Vector();
        PortType portType = bEntry.getBinding().getPortType();
        String portName = port2.getName();
        this.typeMappingsByPort.put(portName, this.typeMappings);
        this.operationsByPort.put(portName, this.operations);
        this.emitter.setDynamicVar(QUERY_TYPEMAPPINGS, this.typeMappingsByPort);
        this.emitter.setDynamicVar(QUERY_OPERATIONS, this.operationsByPort);
        this.processTypes(bEntry);
        this.processBinding(bEntry);
    }

    private void processTypes(BindingEntry bEntry) throws IOException {
        Vector types = this.symbolTable.getTypes();
        Binding binding = bEntry.getBinding();
        for (int i = 0; i < types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)types.elementAt(i);
            if (!JavaStubWriter.needTypeMapping(typeEntry, this.emitter)) continue;
            this.deployTypeMapping((Type)typeEntry, bEntry);
        }
    }

    private void deployTypeMapping(Type type, BindingEntry bEntry) throws IOException {
        String javaType = type.getName();
        if (javaType.endsWith("[]")) {
            String wrapper = JavaUtils.getWrapper(javaType = javaType.substring(0, javaType.length() - 2));
            if (wrapper != null) {
                this.deployTypeMapping(type, wrapper + "[]", bEntry);
            }
        } else {
            String wrapper = JavaUtils.getWrapper(javaType);
            if (wrapper != null) {
                this.deployTypeMapping(type, wrapper, bEntry);
            }
        }
        this.deployTypeMapping(type, type.getName(), bEntry);
    }

    private void deployTypeMapping(Type type, String javaType, BindingEntry bEntry) throws IOException {
        String namespaceURI = type.getQName().getNamespaceURI();
        String localPart = type.getQName().getLocalPart();
        String serializerFactory = JavaStubWriter.getSerializerFactoryName(type, javaType, this.emitter);
        String deserializerFactory = JavaStubWriter.getDeserializerFactoryName(type, javaType, this.emitter);
        String encodingStyle = "";
        if (!bEntry.hasLiteral()) {
            encodingStyle = Constants.URI_DEFAULT_SOAP_ENC;
        }
        QName componentQName = null;
        QName componentTypeQName = null;
        if (type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN) != null) {
            componentQName = ((Entry)type.getChildren().get(0)).getQName();
            componentTypeQName = ((TypeEntry)type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN)).getQName();
        } else if (type.isList()) {
            Type listType = type;
            while (listType.getRefType() != null && ((Type)listType.getRefType()).isList()) {
                listType = (Type)listType.getRefType();
            }
            componentTypeQName = listType.getRefType().getQName();
        } else if (type.getDimensions().length() > 0 && serializerFactory.equals("com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory")) {
            TypeEntry compType = type.getRefType();
            if (compType != null) {
                while (compType.getRefType() != null && !(compType instanceof Type)) {
                    compType = compType.getRefType();
                }
                componentTypeQName = compType.getQName();
            }
        } else if (type.isSimpleTypeOrSimpleContent()) {
            Type resType;
            for (resType = type.getRestrictionBase(); resType != null && resType.getRestrictionBase() != null; resType = resType.getRestrictionBase()) {
            }
            componentTypeQName = resType != null ? resType.getQName() : null;
        }
        QName legacyQName = (QName)type.getDynamicVar(SymbolTable.LEGACY_QNAME);
        if (legacyQName != null) {
            this.generateTypeMapping(legacyQName.getNamespaceURI(), legacyQName.getLocalPart(), javaType, serializerFactory, deserializerFactory, encodingStyle, (String)type.getDynamicVar("CustomBinderName"), componentQName, componentTypeQName);
        }
        this.generateTypeMapping(namespaceURI, localPart, javaType, serializerFactory, deserializerFactory, encodingStyle, (String)type.getDynamicVar("CustomBinderName"), componentQName, componentTypeQName);
    }

    private void generateTypeMapping(String namespaceURI, String localPart, String javaType, String serializerFactory, String deserializerFactory, String encodingStyle, String binderName, QName componentQName, QName componentTypeQName) throws IOException {
        WSDDTypeMapping tm = new WSDDTypeMapping();
        tm.setEncodingStyle(encodingStyle);
        tm.setLanguageSpecificType(javaType);
        tm.setQName(new QName(namespaceURI, localPart));
        tm.setSerializer(serializerFactory);
        tm.setDeserializer(deserializerFactory);
        tm.setBinderName(binderName);
        tm.setComponentQName(componentQName);
        tm.setComponentTypeQName(componentTypeQName);
        this.typeMappings.add(tm);
    }

    private void processBinding(BindingEntry bEntry) throws IOException {
        Binding binding = bEntry.getBinding();
        Iterator operationsIterator = binding.getBindingOperations().iterator();
        while (operationsIterator.hasNext()) {
            BindingOperation bindingOper = (BindingOperation)operationsIterator.next();
            Operation operation = bindingOper.getOperation();
            OperationType type = operation.getStyle();
            BindingOperationEntry boe = bEntry.getOperation(operation);
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE || boe == null) continue;
            this.processOperation(bEntry, boe);
        }
    }

    private void processOperation(BindingEntry bEntry, BindingOperationEntry boe) {
        OperationDescBuilder odb = OperationDescBuilder.create(boe, bEntry, this.symbolTable);
        OperationDesc oper = odb.getOperationDesc(false);
        this.operations.add(oper);
    }

    private String getModeString(byte mode) {
        if (mode == 1) {
            return "IN";
        }
        if (mode == 3) {
            return "INOUT";
        }
        return "OUT";
    }
}

