/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanBaseWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Node;

public class JavaBeanWriter
extends JavaBeanBaseWriter {
    protected PrintWriter pw;
    protected boolean enableDefaultConstructor = true;
    protected boolean enableFullConstructor = false;
    protected boolean enableSimpleConstructors = false;
    protected boolean enableToString = false;
    protected boolean enableSetters = true;
    protected boolean enableGetters = true;
    protected boolean enableEquals = true;
    protected boolean enableHashCode = true;

    protected JavaBeanWriter(Emitter emitter, Type type) {
        this(emitter, type, type.getName(), "complexType");
    }

    protected JavaBeanWriter(Emitter emitter, Type type, String name2, String description) {
        super(emitter, type, name2, description);
        if (type.isSimpleTypeOrSimpleContent()) {
            this.enableSimpleConstructors = type.getRestrictionBase() != null;
            this.enableToString = type.getRestrictionBase() != null;
        }
        this.enableEquals = emitter.isGenEquals();
        this.enableHashCode = emitter.isGenEquals();
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.pw = pw;
        this.writeMemberFields();
        if (this.enableDefaultConstructor) {
            this.writeDefaultConstructor();
        }
        if (this.enableFullConstructor) {
            this.writeFullConstructor();
        }
        if (this.enableSimpleConstructors) {
            this.writeSimpleConstructors();
        }
        if (this.enableToString) {
            this.writeToStringMethod();
        }
        this.writeAccessMethods();
        if (this.enableEquals) {
            this.writeEqualsMethod();
        }
        if (this.enableHashCode) {
            this.writeHashCodeMethod();
        }
    }

    protected String getClassModifiers() {
        Node node = this.type.getNode();
        if (node != null && this.type.isAbstract()) {
            return super.getClassModifiers() + "abstract ";
        }
        return super.getClassModifiers();
    }

    protected String getExtendsText() {
        String extendsText = "";
        if (!this.isBaseClass()) {
            extendsText = " extends " + this.extendType.getName() + " ";
        }
        return extendsText;
    }

    protected String getImplementsText() {
        String implementsText = "";
        if (this.emitter.isGenImplSer()) {
            implementsText = " implements java.io.Serializable";
            if (this.type.isSimpleType() && this.type.getRestrictionBase() != null) {
                implementsText = implementsText + ", com.ibm.ws.webservices.engine.encoding.SimpleType";
            }
        } else if (this.type.isSimpleType() && this.type.getRestrictionBase() != null) {
            implementsText = " implements com.ibm.ws.webservices.engine.encoding.SimpleType";
        }
        implementsText = implementsText + " ";
        return implementsText;
    }

    protected void writeMemberFields() {
        Vector children = this.type.getChildren();
        for (int i = 0; children != null && i < children.size(); ++i) {
            ChildEntry ce = (ChildEntry)children.get(i);
            String visibility = "private";
            if (JavaBeanWriter.isDataMember(ce)) {
                visibility = "public";
            }
            this.pw.print("    " + visibility + " " + ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE) + " " + ce.getName() + ";");
            if (ce instanceof ChildAttribute) {
                this.pw.println("  // attribute");
                continue;
            }
            this.pw.println();
        }
        this.pw.println();
    }

    protected void writeDefaultConstructor() {
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("    }");
        this.pw.println();
    }

    protected void writeFullConstructor() {
        Vector childEntrys = new Vector();
        Vector paramNames = new Vector();
        this.getTypesAndNames(this.type, childEntrys, paramNames, false, true, false);
        if (childEntrys.size() > 0) {
            int j;
            this.pw.println("    public " + this.className + "(");
            for (int i = 0; i < childEntrys.size(); ++i) {
                ChildEntry cEntry = (ChildEntry)childEntrys.elementAt(i);
                this.pw.print("           " + cEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE) + " " + paramNames.elementAt(i));
                if (i + 1 < childEntrys.size()) {
                    this.pw.println(",");
                    continue;
                }
                this.pw.println(") {");
            }
            if (this.extendType != null) {
                Vector extChildEntrys = new Vector();
                Vector extParamNames = new Vector();
                this.getTypesAndNames(this.extendType, extChildEntrys, extParamNames, true, true, false);
                if (!this.isBaseClass()) {
                    if (extChildEntrys.size() > 0) {
                        this.pw.println("        super(");
                        for (j = 0; j < extChildEntrys.size(); ++j) {
                            this.pw.print("            " + extParamNames.elementAt(j));
                            if (j + 1 < extChildEntrys.size()) {
                                this.pw.println(",");
                                continue;
                            }
                            this.pw.println(");");
                        }
                    } else {
                        this.pw.println("        super();");
                    }
                }
            }
            Vector baseChildEntrys = new Vector();
            Vector baseParamNames = new Vector();
            this.getTypesAndNames(this.type, baseChildEntrys, baseParamNames, false, true, true);
            for (j = 0; j < baseParamNames.size(); ++j) {
                this.pw.println("        this." + baseParamNames.elementAt(j) + " = " + baseParamNames.elementAt(j) + ";");
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void getTypesAndNames(Type type, Vector childEntrys, Vector paramNames, boolean mangleBase, boolean mangleExt, boolean ignoreExtensions) {
        Vector<Type> extendList = new Vector<Type>();
        if (ignoreExtensions) {
            extendList.add(type);
        } else {
            Type next = type;
            while (next != null) {
                extendList.add(next);
                if (next.getExtensionBase() != null) {
                    next = next.getExtensionBase();
                    continue;
                }
                next = next.getRestrictionBase();
            }
        }
        HashMap<String, ChildEntry> childEntryMap = new HashMap<String, ChildEntry>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (int i = extendList.size() - 1; i >= 0; --i) {
            Vector children;
            Type te = (Type)extendList.elementAt(i);
            String mangle = "";
            if (i > 0 && mangleExt || i == 0 && mangleBase) {
                String name2 = te.getName();
                name2 = name2.substring(name2.lastIndexOf(".") + 1);
                mangle = "_" + name2 + "_";
            }
            if ((children = te.getChildren()) == null) continue;
            for (int j = 0; j < children.size(); ++j) {
                ChildEntry child = (ChildEntry)children.get(j);
                String key = child.getQName().getLocalPart();
                childEntryMap.put(key, child);
                nameMap.put(key, mangle + child.getName());
            }
        }
        ArrayList order = (ArrayList)type.getDynamicVar("constructorOrder");
        if (order != null) {
            for (int i = 0; i < order.size(); ++i) {
                if (childEntryMap.get(order.get(i)) == null) continue;
                childEntrys.add(childEntryMap.get(order.get(i)));
                paramNames.add(nameMap.get(order.get(i)));
            }
        }
    }

    protected void writeSimpleConstructors() {
        if (this.type.isSimpleType() && this.baseSimpleType != null) {
            if (!this.extendType.getName().equals("java.lang.String")) {
                this.pw.println("    public " + this.className + "(" + this.extendType.getName() + " value) {");
                if (!this.isBaseClass()) {
                    this.pw.println("        super(value);");
                } else {
                    this.pw.println("        this.value = value;");
                }
                this.pw.println("    }");
                this.pw.println();
            }
            this.pw.println("    // " + Messages.getMessage("needStringCtor"));
            this.pw.println("    public " + this.className + "(java.lang.String value) {");
            if (!this.isBaseClass()) {
                this.pw.println("        super(value);");
            } else if (this.extendType.isEnumeration()) {
                this.pw.println("        this.value = " + this.extendType.getName() + ".fromString(value);");
            } else {
                String wrapper = JavaUtils.getWrapper(this.baseSimpleType.getName());
                if (wrapper != null) {
                    this.pw.println("        this.value = new " + wrapper + "(value)." + this.baseSimpleType.getName() + "Value();");
                } else if (this.baseSimpleType.getName().equals("byte[]")) {
                    this.pw.println("        this.value = com.ibm.ws.webservices.engine.types.HexBinary.decode(value);");
                } else if (this.baseSimpleType.getName().equals("com.ibm.ws.webservices.engine.types.URI")) {
                    this.pw.println("        try {");
                    this.pw.println("            this.value = new com.ibm.ws.webservices.engine.types.URI(value);");
                    this.pw.println("        }");
                    this.pw.println("        catch (com.ibm.ws.webservices.engine.types.URI.MalformedURIException mue) {");
                    this.pw.println("            this.value = new com.ibm.ws.webservices.engine.types.URI();");
                    this.pw.println("       }");
                } else if (this.baseSimpleType.getName().equals("java.net.URI")) {
                    this.pw.println("        try {");
                    this.pw.println("            this.value = new java.net.URI(value);");
                    this.pw.println("        }");
                    this.pw.println("        catch (java.net.URISyntaxException use) {");
                    this.pw.println("            throw new java.lang.RuntimeException(use);");
                    this.pw.println("       }");
                } else if (this.baseSimpleType.getName().equals("java.util.Date")) {
                    this.pw.println("        try {");
                    this.pw.println("            this.value = (java.text.DateFormat.getDateTimeInstance()).parse(value);");
                    this.pw.println("        }");
                    this.pw.println("        catch (java.text.ParseException e){");
                    this.pw.println("            throw new java.lang.RuntimeException(e.toString());");
                    this.pw.println("        }");
                } else if (this.baseSimpleType.getName().equals("java.util.Calendar")) {
                    this.pw.println("        java.util.Calendar cal = java.util.Calendar.getInstance();");
                    this.pw.println("        try {");
                    this.pw.println("          java.util.Date dt = (java.text.DateFormat.getDateTimeInstance()).parse(value);");
                    this.pw.println("          cal.setTime(dt);");
                    this.pw.println("          this.value = cal;");
                    this.pw.println("        }");
                    this.pw.println("        catch (java.text.ParseException e){");
                    this.pw.println("            throw new java.lang.RuntimeException(e.toString());");
                    this.pw.println("        }");
                } else {
                    this.pw.println("        this.value = new " + this.baseSimpleType.getName() + "(value);");
                }
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeToStringMethod() {
        if (this.type.isSimpleType() && this.isBaseClass()) {
            this.pw.println("    // " + Messages.getMessage("needToString"));
            String wrapper = JavaUtils.getWrapper(this.extendType.getName());
            this.pw.println("    public java.lang.String toString() {");
            if (wrapper != null) {
                this.pw.println("        return new " + wrapper + "(value).toString();");
            } else if (this.extendType.getName().equals("byte[]")) {
                this.pw.println("        return value == null ? null : com.ibm.ws.webservices.engine.types.HexBinary.encode(value);");
            } else {
                this.pw.println("        return value == null ? null : value.toString();");
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeAccessMethods() {
        Vector children = this.type.getChildren();
        for (int i = 0; children != null && i < children.size(); ++i) {
            ChildEntry ce = (ChildEntry)children.get(i);
            if (JavaBeanWriter.isDataMember(ce)) continue;
            String typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
            String name2 = ce.getName();
            if (this.enableGetters) {
                this.pw.println("    public " + typeName + " " + JavaBeanWriter.getterMethodName(ce) + "() {");
                this.pw.println("        return " + name2 + ";");
                this.pw.println("    }");
                this.pw.println();
            }
            if (this.enableSetters) {
                this.pw.println("    public void " + JavaBeanWriter.setterMethodName(ce) + "(" + typeName + " " + name2 + ") {");
                this.pw.println("        this." + name2 + " = " + name2 + ";");
                this.pw.println("    }");
                this.pw.println();
            }
            if (!(ce instanceof ChildElement) || !ce.getType().isCollectionTypeEntry()) continue;
            ChildElement elem = (ChildElement)ce;
            String compName = typeName.substring(0, typeName.lastIndexOf("["));
            if (this.enableGetters) {
                this.pw.println("    public " + compName + " " + JavaBeanWriter.getterMethodName(ce) + "(int i) {");
                this.pw.println("        return this." + name2 + "[i];");
                this.pw.println("    }");
                this.pw.println();
            }
            if (!this.enableSetters) continue;
            this.pw.println("    public void " + JavaBeanWriter.setterMethodName(ce) + "(int i, " + compName + " value) {");
            this.pw.println("        this." + name2 + "[i] = value;");
            this.pw.println("    }");
            this.pw.println();
        }
    }

    public static String getterMethodName(ChildEntry ce) {
        if (ce.getDynamicVar(JavaGeneratorFactory.GET_METHOD_NAME) != null) {
            return (String)ce.getDynamicVar(JavaGeneratorFactory.GET_METHOD_NAME);
        }
        String typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
        String name2 = ce.getName();
        String capName = JavaUtils.capitalizeFirstChar(name2);
        String get = "get";
        if (typeName.equals("boolean")) {
            get = "is";
        }
        return get + capName;
    }

    protected static String setterMethodName(ChildEntry ce) {
        if (ce.getDynamicVar(JavaGeneratorFactory.SET_METHOD_NAME) != null) {
            return (String)ce.getDynamicVar(JavaGeneratorFactory.SET_METHOD_NAME);
        }
        String typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
        String name2 = ce.getName();
        String capName = JavaUtils.capitalizeFirstChar(name2);
        return "set" + capName;
    }

    protected void writeEqualsMethod() {
        String otherReadAccess;
        String get;
        String variable;
        String variableType;
        ChildEntry ce;
        int i;
        boolean found;
        if (this.isBaseClass()) {
            this.pw.println("    private transient java.lang.ThreadLocal __history;");
            this.pw.println("    private synchronized void _getHistory() {");
            this.pw.println("        if (__history == null) { ");
            this.pw.println("            __history = new java.lang.ThreadLocal();");
            this.pw.println("        }");
            this.pw.println("    }");
        }
        this.pw.println("    public boolean equals(java.lang.Object obj) {");
        this.pw.println("        if (obj == null) { return false; }");
        this.pw.println("        if (obj.getClass() != this.getClass()) { return false;}");
        boolean emitOtherDef = false;
        Vector children = this.type.getChildren();
        if (children != null && children.size() != 0) {
            found = false;
            for (i = 0; i < children.size(); ++i) {
                ce = (ChildEntry)children.get(i);
                variableType = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                variable = ce.getName();
                get = "get";
                otherReadAccess = "other." + JavaBeanWriter.readAccess(ce);
                if (variableType.equals("int") || variableType.equals("long") || variableType.equals("short") || variableType.equals("float") || variableType.equals("double") || variableType.equals("boolean") || variableType.equals("char") || variableType.equals("byte")) {
                    if (!emitOtherDef) {
                        this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
                        this.pw.println("        boolean _equals;");
                        emitOtherDef = true;
                    }
                    if (!found) {
                        this.pw.println("        _equals = true");
                        found = true;
                    } else {
                        this.pw.println("");
                    }
                    this.pw.print("            && this." + variable + " == " + otherReadAccess);
                    continue;
                }
                if (!variableType.startsWith("java.lang.")) continue;
                if (!emitOtherDef) {
                    this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
                    this.pw.println("        boolean _equals;");
                    emitOtherDef = true;
                }
                if (!found) {
                    this.pw.println("        _equals = true");
                    found = true;
                } else {
                    this.pw.println("");
                }
                if (variableType.indexOf("[") >= 0) {
                    this.pw.println("            && ((this." + variable + "==null && " + otherReadAccess + "==null) || ");
                    this.pw.println("             (this." + variable + "!=null &&");
                    this.pw.print("              java.util.Arrays.equals(this." + variable + ", " + otherReadAccess + ")))");
                    continue;
                }
                this.pw.println("            && ((this." + variable + "==null && " + otherReadAccess + "==null) || ");
                this.pw.println("             (this." + variable + "!=null &&");
                this.pw.print("              this." + variable + ".equals(" + otherReadAccess + ")))");
            }
            if (found) {
                this.pw.println(";");
                this.pw.println("        if (!_equals) { return false; }");
            }
        }
        if (this.isBaseClass()) {
            this.pw.println("        _getHistory();");
            this.pw.println("        " + this.className + " history = (" + this.className + ") __history.get();");
            this.pw.println("        if (history != null) { return (history == obj); }");
            this.pw.println("        if (this == obj) return true;");
            this.pw.println("        __history.set(obj);");
        } else {
            this.pw.println("        if (!super.equals(obj)) { return false; }");
        }
        if (children != null && children.size() != 0) {
            found = false;
            for (i = 0; i < children.size(); ++i) {
                ce = (ChildEntry)children.get(i);
                variableType = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                variable = ce.getName();
                get = "get";
                otherReadAccess = "other." + JavaBeanWriter.readAccess(ce);
                if (variableType.equals("int") || variableType.equals("long") || variableType.equals("short") || variableType.equals("float") || variableType.equals("double") || variableType.equals("boolean") || variableType.equals("char") || variableType.equals("byte") || variableType.startsWith("java.lang.")) continue;
                if (!emitOtherDef) {
                    this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
                    this.pw.println("        boolean _equals;");
                    emitOtherDef = true;
                }
                if (!found) {
                    this.pw.println("        _equals = true");
                    found = true;
                } else {
                    this.pw.println("");
                }
                if (variableType.indexOf("[") >= 0) {
                    this.pw.println("            && ((this." + variable + "==null && " + otherReadAccess + "==null) || ");
                    this.pw.println("             (this." + variable + "!=null &&");
                    this.pw.print("              java.util.Arrays.equals(this." + variable + ", " + otherReadAccess + ")))");
                    continue;
                }
                this.pw.println("            && ((this." + variable + "==null && " + otherReadAccess + "==null) || ");
                this.pw.println("             (this." + variable + "!=null &&");
                this.pw.print("              this." + variable + ".equals(" + otherReadAccess + ")))");
            }
            if (found) {
                this.pw.println(";");
                this.pw.println("        if (!_equals) {");
                if (this.isBaseClass()) {
                    this.pw.println("            __history.set(null);");
                }
                this.pw.println("            return false;");
                this.pw.println("        };");
            }
        }
        if (this.isBaseClass()) {
            this.pw.println("        __history.set(null);");
        }
        this.pw.println("        return true;");
        this.pw.println("    }");
        this.pw.println("");
    }

    protected void writeHashCodeMethod() {
        if (this.isBaseClass()) {
            this.pw.println("    private transient java.lang.ThreadLocal __hashHistory;");
            this.pw.println("    private synchronized void _getHashHistory() {");
            this.pw.println("        if (__hashHistory == null) { ");
            this.pw.println("            __hashHistory = new java.lang.ThreadLocal();");
            this.pw.println("        }");
            this.pw.println("    }");
        }
        this.pw.println("    public int hashCode() {");
        if (this.isBaseClass()) {
            this.pw.println("        _getHashHistory();");
            this.pw.println("        " + this.className + " history = (" + this.className + ") __hashHistory.get();");
            this.pw.println("        if (history != null) { return 0; }");
            this.pw.println("        __hashHistory.set(this);");
        }
        String start = "1";
        if (!this.isBaseClass()) {
            start = "super.hashCode()";
        }
        this.pw.println("        int _hashCode = " + start + ";");
        Vector children = this.type.getChildren();
        for (int i = 0; children != null && i < children.size(); ++i) {
            ChildEntry ce = (ChildEntry)children.get(i);
            String variableType = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
            String access = JavaBeanWriter.readAccess(ce);
            if (variableType.equals("int") || variableType.equals("short") || variableType.equals("byte")) {
                this.pw.println("        _hashCode += " + access + ";");
                continue;
            }
            if (variableType.equals("boolean")) {
                this.pw.println("        _hashCode += new Boolean(" + access + ").hashCode();");
                continue;
            }
            if (variableType.equals("char")) {
                this.pw.println("        _hashCode += new Character(" + access + ").hashCode();");
                continue;
            }
            if (variableType.equals("long")) {
                this.pw.println("        _hashCode += new Long(" + access + ").hashCode();");
                continue;
            }
            if (variableType.equals("float")) {
                this.pw.println("        _hashCode += new Float(" + access + ").hashCode();");
                continue;
            }
            if (variableType.equals("double")) {
                this.pw.println("        _hashCode += new Double(" + access + ").hashCode();");
                continue;
            }
            if (variableType.indexOf("[") >= 0) {
                this.pw.println("        if (" + access + " != null) {");
                this.pw.println("            for (int i=0;");
                this.pw.println("                 i<java.lang.reflect.Array.getLength(" + access + ");");
                this.pw.println("                 i++) {");
                this.pw.println("                java.lang.Object obj = java.lang.reflect.Array.get(" + access + ", i);");
                this.pw.println("                if (obj != null &&");
                this.pw.println("                    !obj.getClass().isArray()) {");
                this.pw.println("                    _hashCode += obj.hashCode();");
                this.pw.println("                }");
                this.pw.println("            }");
                this.pw.println("        }");
                continue;
            }
            this.pw.println("        if (" + access + " != null) {");
            this.pw.println("            _hashCode += " + access + ".hashCode();");
            this.pw.println("        }");
        }
        if (this.isBaseClass()) {
            this.pw.println("        __hashHistory.set(null);");
        }
        this.pw.println("        return _hashCode;");
        this.pw.println("    }");
        this.pw.println("");
    }

    static boolean isDataMember(ChildEntry ce) {
        Boolean isDataMember = (Boolean)ce.getDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER);
        if (isDataMember == null) {
            return false;
        }
        return isDataMember;
    }

    public static String readAccess(ChildEntry ce) {
        String text = "";
        text = !JavaBeanWriter.isDataMember(ce) ? JavaBeanWriter.getterMethodName(ce) + "()" : ce.getName();
        return text;
    }
}

