/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.Resolver;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class WSIUtils {
    protected static Log log = LogFactory.getLog(Resolver.class.getName());
    private ToolEnv env;
    private boolean wsiCheck = true;

    WSIUtils() {
    }

    public void setEnv(ToolEnv environment) {
        this.env = environment;
    }

    public void enableWSIChecking(boolean wsiChecking) {
        this.wsiCheck = wsiChecking;
    }

    protected void checkNamespaceTargetNamespace(String namespace, String targetNamespace, String parentFileName, String importedFile) {
        if (this.wsiCheck) {
            if (namespace == null && targetNamespace == null) {
                return;
            }
            if (namespace == null || targetNamespace == null || !namespace.equals(targetNamespace)) {
                this.env.reportWarning(Messages.getMessage("notWSINamespaceTargetNamespace01", parentFileName, importedFile, namespace, targetNamespace));
            }
        }
    }

    protected void checkValidWSDLImport(Document doc, String importedDoc, String fromFile) {
        if (this.wsiCheck) {
            int i;
            if (doc == null) {
                return;
            }
            NodeList children = doc.getChildNodes();
            for (i = 0; i < children.getLength() && children.item(i).getNodeName().indexOf("schema") == -1 && children.item(i).getNodeName().indexOf("definitions") == -1; ++i) {
            }
            if (i >= children.getLength()) {
                this.env.reportFatalErr(Messages.getMessage("notValidImportDoc00", importedDoc, fromFile));
            } else if (children.item(i).getNodeName().equals("schema")) {
                this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportSchema00", importedDoc, fromFile));
            }
        }
    }

    protected String getTargetNamespace(Node node) {
        if (node != null && node.getAttributes() != null && node.getAttributes().getNamedItem("targetNamespace") != null) {
            return node.getAttributes().getNamedItem("targetNamespace").getNodeValue();
        }
        return null;
    }

    protected Node getRootSchema(Node docNode, String url, boolean xsd) {
        if (docNode != null) {
            if (((Document)docNode).getDocumentElement().getTagName().indexOf("schema") == -1) {
                int i;
                if (this.wsiCheck && xsd) {
                    this.env.reportWarning(Messages.getMessage("notWSICompliantNotSchemaRoot00", url));
                }
                NodeList children = docNode.getChildNodes();
                for (i = 0; i < children.getLength() && children.item(i).getNodeName().indexOf("schema") == -1; ++i) {
                }
                return children.item(i);
            }
            return ((Document)docNode).getDocumentElement();
        }
        return null;
    }

    protected Node getRootDoc(Node docNode, String url) {
        if (docNode != null) {
            if (((Document)docNode).getDocumentElement().getTagName().indexOf("definitions") == -1) {
                int i;
                NodeList children = docNode.getChildNodes();
                for (i = 0; i < children.getLength() && children.item(i).getNodeName().indexOf("definitions") == -1; ++i) {
                }
                if (children.item(i) == null) {
                    return this.getRootSchema(docNode, url, false);
                }
                return children.item(i);
            }
            return ((Document)docNode).getDocumentElement();
        }
        return null;
    }
}

