/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.wsdl.symbolTable.AttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.Group;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SchemaUtils {
    private static final boolean SUPPORT_GROUPS = false;
    private static String[] schemaTypes = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "anySimpleType", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};
    private static String[] supportEnum = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "Name", "NCName", "language", "ID", "IDREF", "NMTOKEN"};
    private static String[] emitEnum = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "Name", "NCName", "ID", "IDREF", "NMTOKEN"};

    SchemaUtils() {
    }

    static Vector getContainedElementDeclarations(Node node, SymbolTable symbolTable, List nodeStack) {
        Type simpleType;
        QName simpleQName;
        NodeList children;
        QName nodeKind;
        if (node == null) {
            return null;
        }
        if (Utils.getScopedAttribute(node, "substitutionGroup", nodeStack) != null) {
            QName nodeName = Utils.getNodeNameQName(node, nodeStack, symbolTable.getToolEnv(), false);
            symbolTable.getToolEnv().reportWarning(Messages.getMessage("w2junsup00", nodeName.toString()));
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind == null || !complexKind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(complexKind.getNamespaceURI())) continue;
                node = complexNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && (nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) || nodeKind.getLocalPart().equals("group") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()))) {
            QName extensionKind;
            int j;
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && complexContent == null; ++j) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind == null || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) continue;
                if (complexContentKind.getLocalPart().equals("complexContent")) {
                    complexContent = children.item(j);
                    continue;
                }
                if (!complexContentKind.getLocalPart().equals("simpleContent")) continue;
                simpleContent = children.item(j);
            }
            if (complexContent != null) {
                children = complexContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("extension") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI())) continue;
                    extension = children.item(j);
                }
            }
            if (simpleContent != null) {
                children = simpleContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    QName extendsType;
                    Type baseType;
                    extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("extension") && !extensionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI()) || (baseType = symbolTable.getType(extendsType = Utils.getTypeQName(children.item(j), new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv()))) == null) continue;
                    Vector<ChildElement> v = new Vector<ChildElement>();
                    ChildElement elem = new ChildElement(QNameTable.createQName("", "_value"), baseType, symbolTable);
                    v.add(elem);
                    return v;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            Vector v = new Vector();
            for (int j2 = 0; j2 < children.getLength(); ++j2) {
                QName subNodeKind = Utils.getNodeQName(children.item(j2));
                if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
                if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j2), symbolTable, nodeStack, false));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("all")) {
                    v.addAll(SchemaUtils.processAllNode(children.item(j2), symbolTable, nodeStack, false));
                    continue;
                }
                if (!subNodeKind.getLocalPart().equals("choice")) continue;
                v.addAll(SchemaUtils.processChoiceNode(children.item(j2), symbolTable, nodeStack, false));
            }
            return v;
        }
        if (nodeKind != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) && (simpleQName = SchemaUtils.getSimpleTypeBase(node, symbolTable, nodeStack)) != null && (simpleType = symbolTable.getType(simpleQName)) != null && simpleType.getExtensionBase() == null && simpleType.getRestrictionBase() == null) {
            Vector<ChildElement> v = new Vector<ChildElement>();
            ChildElement elem = new ChildElement(QNameTable.createQName("", "value"), simpleType, symbolTable);
            v.add(elem);
            return v;
        }
        return null;
    }

    private static Vector processChoiceNode(Node choiceNode, SymbolTable symbolTable, List nodeStack, boolean findGroups) {
        Vector<ChildEntry> v = new Vector<ChildEntry>();
        NodeList children = choiceNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ChildGroup childGroup;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("choice")) {
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable, nodeStack, findGroups));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("sequence")) {
                v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable, nodeStack, findGroups));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("element") && !findGroups) {
                ChildElement elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable, nodeStack);
                if (elem == null) continue;
                v.add(elem);
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("group") || !findGroups || (childGroup = SchemaUtils.processChildGroupNode(children.item(j), symbolTable, nodeStack)) == null) continue;
            v.add(childGroup);
        }
        return v;
    }

    private static Vector processSequenceNode(Node sequenceNode, SymbolTable symbolTable, List nodeStack, boolean findGroups) {
        Vector<ChildEntry> v = new Vector<ChildEntry>();
        NodeList children = sequenceNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ChildGroup childGroup;
            ChildElement elem;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("choice")) {
                v.addAll(SchemaUtils.processChoiceNode(children.item(j), symbolTable, nodeStack, findGroups));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("sequence")) {
                v.addAll(SchemaUtils.processSequenceNode(children.item(j), symbolTable, nodeStack, findGroups));
                continue;
            }
            if (subNodeKind.getLocalPart().equals("any") && !findGroups) {
                elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable, nodeStack);
                if (elem == null) continue;
                elem.setAnyElement(true);
                v.add(elem);
                continue;
            }
            if (subNodeKind.getLocalPart().equals("element") && !findGroups) {
                elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable, nodeStack);
                if (elem == null) continue;
                v.add(elem);
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("group") || !findGroups || (childGroup = SchemaUtils.processChildGroupNode(children.item(j), symbolTable, nodeStack)) == null) continue;
            v.add(childGroup);
        }
        return v;
    }

    private static Vector processAllNode(Node allNode, SymbolTable symbolTable, List nodeStack, boolean findGroups) {
        Vector<ChildEntry> v = new Vector<ChildEntry>();
        NodeList children = allNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            ChildGroup childGroup;
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("element") && !findGroups) {
                ChildElement elem = SchemaUtils.processChildElementNode(children.item(j), symbolTable, nodeStack);
                if (elem == null) continue;
                v.add(elem);
                continue;
            }
            if (!subNodeKind.getLocalPart().equals("group") || !findGroups || (childGroup = SchemaUtils.processChildGroupNode(children.item(j), symbolTable, nodeStack)) == null) continue;
            v.add(childGroup);
        }
        return v;
    }

    private static ChildElement processChildElementNode(Node elementNode, SymbolTable symbolTable, List nodeStack) {
        QName nodeName = Utils.getNodeNameQName(elementNode, nodeStack, symbolTable.getToolEnv(), false);
        BooleanHolder forElement = new BooleanHolder();
        QName nodeType = Utils.getTypeQName(elementNode, forElement, false, nodeStack, symbolTable.getToolEnv());
        TypeEntry type = null;
        type = forElement.value ? symbolTable.getElement(nodeType) : symbolTable.getType(nodeType);
        if (!forElement.value && !Constants.equals(nodeName, Constants.XSD_ANY)) {
            String def;
            String form = Utils.getAttribute(elementNode, "form");
            if (form != null && form.equals("unqualified")) {
                nodeName = QNameTable.createQName("", nodeName.getLocalPart());
            } else if (form == null && ((def = Utils.getScopedAttribute(elementNode, "elementFormDefault", nodeStack)) == null || def.equals("unqualified"))) {
                nodeName = QNameTable.createQName("", nodeName.getLocalPart());
            }
        }
        if (type != null) {
            String maxOccurs;
            ChildElement elem = new ChildElement(nodeName, type, symbolTable);
            String minOccurs = Utils.getAttribute(elementNode, "minOccurs");
            if (minOccurs != null && minOccurs.equals("0")) {
                elem.setMinOccursIs0(true);
            }
            if ((maxOccurs = Utils.getAttribute(elementNode, "maxOccurs")) != null && !maxOccurs.equals("1")) {
                elem.setMaxOccurs(true);
            }
            String nillable = Utils.getAttribute(elementNode, "nillable");
            elem.setNillable(JavaUtils.isTrueExplicitly(nillable));
            return elem;
        }
        return null;
    }

    private static ChildGroup processChildGroupNode(Node node, SymbolTable symbolTable, List nodeStack) {
        Group group;
        QName qName = Utils.getTypeQNameFromAttr(node, "ref", nodeStack, symbolTable.getToolEnv());
        if (qName != null && (group = symbolTable.getGroup(qName)) != null) {
            return new ChildGroup(qName, group, symbolTable);
        }
        return null;
    }

    static Vector getContainedGroupRefs(Node node, SymbolTable symbolTable, List nodeStack) {
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind == null || !complexKind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(complexKind.getNamespaceURI())) continue;
                node = complexNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && (nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) || nodeKind.getLocalPart().equals("group") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()))) {
            int j;
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && complexContent == null; ++j) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind == null || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) continue;
                if (complexContentKind.getLocalPart().equals("complexContent")) {
                    complexContent = children.item(j);
                    continue;
                }
                if (!complexContentKind.getLocalPart().equals("simpleContent")) continue;
                simpleContent = children.item(j);
            }
            if (complexContent != null) {
                children = complexContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    QName extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("extension") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI())) continue;
                    extension = children.item(j);
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            Vector v = new Vector();
            for (int j2 = 0; j2 < children.getLength(); ++j2) {
                QName subNodeKind = Utils.getNodeQName(children.item(j2));
                if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
                if (subNodeKind.getLocalPart().equals("sequence")) {
                    v.addAll(SchemaUtils.processSequenceNode(children.item(j2), symbolTable, nodeStack, true));
                    continue;
                }
                if (subNodeKind.getLocalPart().equals("all")) {
                    v.addAll(SchemaUtils.processAllNode(children.item(j2), symbolTable, nodeStack, true));
                    continue;
                }
                if (!subNodeKind.getLocalPart().equals("choice")) continue;
                v.addAll(SchemaUtils.processChoiceNode(children.item(j2), symbolTable, nodeStack, true));
            }
            return v;
        }
        return null;
    }

    static boolean isComplexType(Node node, List nodeStack) {
        if (node == null) {
            return false;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            return true;
        }
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind == null || !kind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(kind.getNamespaceURI())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isSimpleType(Node node, List nodeStack) {
        if (node == null) {
            return false;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind != null && kind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    return false;
                }
                if (kind == null || !kind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(kind.getNamespaceURI())) continue;
                return true;
            }
        }
        return nodeKind != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI());
    }

    static boolean isSimpleContent(Node node, List nodeStack) {
        NodeList children;
        if (node == null) {
            return false;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName kind = Utils.getNodeQName(children.item(j));
                if (kind != null && kind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(kind.getNamespaceURI())) {
                    node = complexNode = children.item(j);
                }
                if (kind == null || !kind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(kind.getNamespaceURI())) continue;
                return false;
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            return false;
        }
        if (nodeKind != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            for (int j = 0; j < children.getLength() && complexContent == null; ++j) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind == null || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) continue;
                if (complexContentKind.getLocalPart().equals("complexContent")) {
                    complexContent = children.item(j);
                    continue;
                }
                if (!complexContentKind.getLocalPart().equals("simpleContent")) continue;
                simpleContent = children.item(j);
            }
            if (complexContent != null) {
                return false;
            }
            if (simpleContent != null) {
                return true;
            }
        }
        return false;
    }

    static Type getComplexElementExtensionBase(Node node, SymbolTable symbolTable, List nodeStack) {
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind == null || !complexKind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(complexKind.getNamespaceURI())) continue;
                node = complexNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            int j;
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && content == null; ++j) {
                QName contentKind = Utils.getNodeQName(children.item(j));
                if (contentKind != null && contentKind.getLocalPart().equals("complexContent") && Constants.isSchemaXSD(contentKind.getNamespaceURI())) {
                    content = children.item(j);
                }
                if (contentKind == null || !contentKind.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(contentKind.getNamespaceURI())) continue;
                content = children.item(j);
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    QName extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("extension") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI())) continue;
                    extension = children.item(j);
                }
            }
            if (extension == null) {
                return null;
            }
            QName extendsType = Utils.getTypeQName(extension, new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv());
            if (extendsType == null) {
                return null;
            }
            return symbolTable.getType(extendsType);
        }
        return null;
    }

    static QName getSimpleTypeBase(Node node, SymbolTable symbolTable, List nodeStack) {
        int j;
        NodeList children;
        QName baseQName = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            for (j = 0; j < children.getLength() && simpleNode == null; ++j) {
                QName simpleKind = Utils.getNodeQName(children.item(j));
                if (simpleKind == null || !simpleKind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(simpleKind.getNamespaceURI())) continue;
                node = simpleNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node restrictionNode = null;
            for (j = 0; j < children.getLength() && restrictionNode == null; ++j) {
                QName restrictionKind = Utils.getNodeQName(children.item(j));
                if (restrictionKind == null || !restrictionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) continue;
                restrictionNode = children.item(j);
            }
            if (restrictionNode != null) {
                baseQName = Utils.getTypeQName(restrictionNode, new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv());
            }
        }
        return baseQName;
    }

    static Node getRestrictionOrExtensionNode(Node node) {
        int j;
        NodeList children;
        Node re = null;
        if (node == null) {
            return re;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node node2 = null;
            for (j = 0; j < children.getLength() && node2 == null; ++j) {
                QName kind2 = Utils.getNodeQName(children.item(j));
                if (kind2 == null || !kind2.getLocalPart().equals("simpleType") && !kind2.getLocalPart().equals("complexType") && !kind2.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(kind2.getNamespaceURI())) continue;
                node = node2 = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && (nodeKind.getLocalPart().equals("simpleType") || nodeKind.getLocalPart().equals("complexType")) && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContent = null;
            if (nodeKind.getLocalPart().equals("complexType")) {
                for (j = 0; j < children.getLength() && complexContent == null; ++j) {
                    QName complexContentKind = Utils.getNodeQName(children.item(j));
                    if (complexContentKind == null || !complexContentKind.getLocalPart().equals("complexContent") && !complexContentKind.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) continue;
                    complexContent = children.item(j);
                }
                node = complexContent;
            }
            if (node != null) {
                children = node.getChildNodes();
                for (j = 0; j < children.getLength() && re == null; ++j) {
                    QName reKind = Utils.getNodeQName(children.item(j));
                    if (reKind == null || !reKind.getLocalPart().equals("extension") && !reKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(reKind.getNamespaceURI())) continue;
                    re = children.item(j);
                }
            }
        }
        return re;
    }

    static QName getArrayComponentQName(Node node, IntHolder dims, List nodeStack, SymbolTable symbolTable) {
        dims.value = 1;
        QName qName = SchemaUtils.getCollectionComponentQName(node, nodeStack, symbolTable);
        if (qName == null) {
            qName = SchemaUtils.getListComponentQName(node, dims, nodeStack, symbolTable);
        }
        if (qName == null) {
            qName = SchemaUtils.getArrayComponentQName_JAXRPC(node, dims, nodeStack, symbolTable);
        }
        return qName;
    }

    private static QName getCollectionComponentQName(Node node, List nodeStack, SymbolTable symbolTable) {
        QName fullQName;
        BooleanHolder forElement;
        QName componentQName;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) && (componentQName = Utils.getTypeQName(node, forElement = new BooleanHolder(), true, nodeStack, symbolTable.getToolEnv())) != null && !componentQName.equals(fullQName = Utils.getTypeQName(node, forElement, false, nodeStack, symbolTable.getToolEnv()))) {
            return componentQName;
        }
        return null;
    }

    private static QName getArrayComponentQName_JAXRPC(Node node, IntHolder dims, List nodeStack, SymbolTable symbolTable) {
        int j;
        NodeList children;
        dims.value = 0;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind == null || !complexKind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(complexKind.getNamespaceURI())) continue;
                node = complexNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexContentNode = null;
            for (j = 0; j < children.getLength() && complexContentNode == null; ++j) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind == null || !complexContentKind.getLocalPart().equals("complexContent") && !complexContentKind.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) continue;
                complexContentNode = children.item(j);
            }
            Node restrictionNode = null;
            if (complexContentNode != null) {
                children = complexContentNode.getChildNodes();
                for (int j2 = 0; j2 < children.getLength() && restrictionNode == null; ++j2) {
                    QName restrictionKind = Utils.getNodeQName(children.item(j2));
                    if (restrictionKind == null || !restrictionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) continue;
                    restrictionNode = children.item(j2);
                }
            }
            QName baseType = null;
            if (!(restrictionNode == null || (baseType = Utils.getTypeQName(restrictionNode, new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv())) != null && baseType.getLocalPart().equals("Array") && Constants.isSOAP_ENC(baseType.getNamespaceURI()))) {
                baseType = null;
            }
            Node groupNode = null;
            Node attributeNode = null;
            if (baseType != null) {
                children = restrictionNode.getChildNodes();
                for (int j3 = 0; j3 < children.getLength() && groupNode == null && attributeNode == null; ++j3) {
                    QName kind = Utils.getNodeQName(children.item(j3));
                    if (kind != null && (kind.getLocalPart().equals("sequence") || kind.getLocalPart().equals("all")) && Constants.isSchemaXSD(kind.getNamespaceURI()) && (groupNode = children.item(j3)).getChildNodes().getLength() == 0) {
                        groupNode = null;
                    }
                    if (kind == null || !kind.getLocalPart().equals("attribute") || !Constants.isSchemaXSD(kind.getNamespaceURI())) continue;
                    BooleanHolder isRef = new BooleanHolder();
                    QName refQName = Utils.getTypeQName(children.item(j3), isRef, false, nodeStack, symbolTable.getToolEnv());
                    if (refQName == null || !isRef.value || !refQName.getLocalPart().equals("arrayType") || !Constants.isSOAP_ENC(refQName.getNamespaceURI())) continue;
                    attributeNode = children.item(j3);
                }
            }
            if (attributeNode != null) {
                int i;
                String wsdlArrayTypeValue = null;
                Vector attrs = Utils.getAttributesWithLocalName(attributeNode, "arrayType");
                for (i = 0; i < attrs.size() && wsdlArrayTypeValue == null; ++i) {
                    Node attrNode = (Node)attrs.elementAt(i);
                    String attrName = attrNode.getNodeName();
                    QName attrQName = Utils.getQNameFromPrefixedName(attributeNode, attrName, nodeStack, symbolTable.getToolEnv());
                    if (!Constants.isWSDL(attrQName.getNamespaceURI())) continue;
                    wsdlArrayTypeValue = attrNode.getNodeValue();
                }
                if (wsdlArrayTypeValue != null && (i = wsdlArrayTypeValue.indexOf(91)) > 0) {
                    String prefixedName = wsdlArrayTypeValue.substring(0, i);
                    String mangledString = wsdlArrayTypeValue.replace(',', '[');
                    dims.value = 0;
                    int index = mangledString.indexOf(91);
                    while (index > 0) {
                        ++dims.value;
                        index = mangledString.indexOf(91, index + 1);
                    }
                    return Utils.getQNameFromPrefixedName(restrictionNode, prefixedName, nodeStack, symbolTable.getToolEnv());
                }
            } else if (groupNode != null) {
                String maxOccursValue;
                NodeList elements = groupNode.getChildNodes();
                Node elementNode = null;
                for (int i = 0; i < elements.getLength() && elementNode == null; ++i) {
                    QName elementKind = Utils.getNodeQName(elements.item(i));
                    if (elementKind == null || !elementKind.getLocalPart().equals("element") || !Constants.isSchemaXSD(elementKind.getNamespaceURI())) continue;
                    elementNode = elements.item(i);
                }
                if (elementNode != null && (maxOccursValue = Utils.getAttribute(elementNode, "maxOccurs")) != null && maxOccursValue.equalsIgnoreCase("unbounded")) {
                    dims.value = 1;
                    return Utils.getTypeQName(elementNode, new BooleanHolder(), true, nodeStack, symbolTable.getToolEnv());
                }
            }
        }
        return null;
    }

    static Vector getContainedAttributeTypes(Node node, SymbolTable symbolTable, List nodeStack) {
        NodeList children;
        Vector<ChildAttribute> v = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind == null || !complexKind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(complexKind.getNamespaceURI())) continue;
                node = complexNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && (nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) || nodeKind.getLocalPart().equals("group") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) || nodeKind.getLocalPart().equals("attributeGroup") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()))) {
            int j;
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && content == null; ++j) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind == null || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI()) || !complexContentKind.getLocalPart().equals("complexContent") && !complexContentKind.getLocalPart().equals("simpleContent")) continue;
                content = children.item(j);
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    QName extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("extension") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI())) continue;
                    extension = children.item(j);
                    break;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                nodeKind = Utils.getNodeQName(child);
                if (nodeKind == null) continue;
                if (nodeKind.getLocalPart().equals("attribute")) {
                    if (v == null) {
                        v = new Vector<ChildAttribute>();
                    }
                    SchemaUtils.addChildAttribute(v, child, nodeStack, symbolTable);
                    continue;
                }
                if (!nodeKind.getLocalPart().equals("anyAttribute")) continue;
                if (v == null) {
                    v = new Vector();
                }
                v.add(new ChildAttribute(QNameTable.createQName("", "anyAttribute"), symbolTable.getUnmappableType(), symbolTable));
            }
        }
        return v;
    }

    private static void addChildAttribute(Vector v, Node child, List nodeStack, SymbolTable symbolTable) {
        QName attributeQName = Utils.getNodeNameQName(child, nodeStack, symbolTable.getToolEnv(), false);
        BooleanHolder forElement = new BooleanHolder();
        QName attributeType = Utils.getTypeQName(child, forElement, false, nodeStack, symbolTable.getToolEnv());
        if (!forElement.value) {
            String def;
            String form = Utils.getAttribute(child, "form");
            if (form != null && form.equals("unqualified")) {
                attributeQName = QNameTable.createQName("", attributeQName.getLocalPart());
            } else if (form == null && ((def = Utils.getScopedAttribute(child, "attributeFormDefault", nodeStack)) == null || def.equals("unqualified"))) {
                attributeQName = QNameTable.createQName("", attributeQName.getLocalPart());
            }
        } else {
            attributeQName = attributeType;
        }
        String use = Utils.getAttribute(child, "use");
        TypeEntry type = null;
        type = forElement.value ? symbolTable.getAttribute(attributeType) : symbolTable.getType(attributeType);
        if (type != null && attributeQName != null && !"prohibited".equals(use)) {
            ChildAttribute childAttribute = new ChildAttribute(attributeQName, type, "optional".equals(use), symbolTable);
            v.add(childAttribute);
        }
    }

    static Vector getContainedAttributeGroupRefs(Node node, SymbolTable symbolTable, List nodeStack) {
        NodeList children;
        Vector<ChildAttributeGroup> v = null;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind == null || !complexKind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(complexKind.getNamespaceURI())) continue;
                node = complexNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && (nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) || nodeKind.getLocalPart().equals("group") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()) || nodeKind.getLocalPart().equals("attributeGroup") && Constants.isSchemaXSD(nodeKind.getNamespaceURI()))) {
            int j;
            children = node.getChildNodes();
            Node content = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && content == null; ++j) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind == null || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI()) || !complexContentKind.getLocalPart().equals("complexContent") && !complexContentKind.getLocalPart().equals("simpleContent")) continue;
                content = children.item(j);
            }
            if (content != null) {
                children = content.getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    QName extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("extension") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI())) continue;
                    extension = children.item(j);
                    break;
                }
            }
            if (extension != null) {
                node = extension;
            }
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                AttributeGroup attrGroup;
                QName qName;
                Node child = children.item(i);
                nodeKind = Utils.getNodeQName(child);
                if (nodeKind == null || !nodeKind.getLocalPart().equals("attributeGroup")) continue;
                if (v == null) {
                    v = new Vector<ChildAttributeGroup>();
                }
                if ((qName = Utils.getTypeQNameFromAttr(child, "ref", nodeStack, symbolTable.getToolEnv())) == null || (attrGroup = symbolTable.getAttributeGroup(qName)) == null) continue;
                v.add(new ChildAttributeGroup(qName, attrGroup, symbolTable));
            }
        }
        return v;
    }

    static QName getListComponentQName(Node node, IntHolder dims, List nodeStack, SymbolTable symbolTable) {
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            for (int j = 0; j < children.getLength() && simpleNode == null; ++j) {
                QName simpleKind = Utils.getNodeQName(children.item(j));
                if (simpleKind == null || !simpleKind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(simpleKind.getNamespaceURI())) continue;
                node = simpleNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node listNode = null;
            boolean isList = false;
            for (int j = 0; j < children.getLength() && listNode == null; ++j) {
                QName tempQName = Utils.getNodeQName(children.item(j));
                if (tempQName != null && tempQName.getLocalPart().equals("list") && Constants.isSchemaXSD(tempQName.getNamespaceURI())) {
                    if (Utils.getAttribute(children.item(j), "itemType") != null || SchemaUtils.getEnumerationBaseAndValuesToEmit(children.item(j), symbolTable, nodeStack) != null) {
                        listNode = children.item(j);
                        continue;
                    }
                    isList = true;
                    children = children.item(j).getChildNodes();
                    j = 0;
                    continue;
                }
                if (tempQName != null && tempQName.getLocalPart().equals("restriction") && Constants.isSchemaXSD(tempQName.getNamespaceURI())) {
                    if (isList) {
                        listNode = children.item(j);
                        continue;
                    }
                    children = children.item(j).getChildNodes();
                    j = 0;
                    continue;
                }
                if (tempQName != null && tempQName.getLocalPart().equals("simpleContent") && Constants.isSchemaXSD(tempQName.getNamespaceURI())) {
                    children = children.item(j).getChildNodes();
                    j = 0;
                    continue;
                }
                if (tempQName == null || !tempQName.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(tempQName.getNamespaceURI())) continue;
                children = children.item(j).getChildNodes();
                j = 0;
            }
            if (listNode != null) {
                return Utils.getTypeQName(listNode, new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv());
            }
        }
        return null;
    }

    static Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable, List nodeStack) {
        int j;
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && (nodeKind.getLocalPart().equals("element") || nodeKind.getLocalPart().equals("list")) && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            for (j = 0; j < children.getLength() && simpleNode == null; ++j) {
                QName simpleKind = Utils.getNodeQName(children.item(j));
                if (simpleKind == null || !simpleKind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(simpleKind.getNamespaceURI())) continue;
                node = simpleNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            QName baseType;
            children = node.getChildNodes();
            Node restrictionNode = null;
            for (j = 0; j < children.getLength() && restrictionNode == null; ++j) {
                QName restrictionKind = Utils.getNodeQName(children.item(j));
                if (restrictionKind == null || !restrictionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) continue;
                restrictionNode = children.item(j);
            }
            Type baseEType = null;
            if (restrictionNode != null && (baseEType = symbolTable.getType(baseType = Utils.getTypeQName(restrictionNode, new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv()))) != null && !SchemaUtils.supportEnumForBase(baseType)) {
                baseEType = null;
            }
            if (baseEType != null && restrictionNode != null) {
                Vector<ChildEnumValueEntry> v = null;
                NodeList enums = restrictionNode.getChildNodes();
                for (int i = 0; i < enums.getLength(); ++i) {
                    Node enumNode;
                    String value2;
                    QName enumKind = Utils.getNodeQName(enums.item(i));
                    if (enumKind == null || !enumKind.getLocalPart().equals("enumeration") || !Constants.isSchemaXSD(enumKind.getNamespaceURI()) || (value2 = Utils.getAttribute(enumNode = enums.item(i), "value")) == null) continue;
                    if (v == null) {
                        v = new Vector<ChildEnumValueEntry>();
                    }
                    v.add(new ChildEnumValueEntry(baseEType, value2, symbolTable));
                }
                return v;
            }
        }
        return null;
    }

    static Vector getEnumerationBaseAndValuesToEmit(Node node, SymbolTable symbolTable, List nodeStack) {
        int j;
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && (nodeKind.getLocalPart().equals("element") || nodeKind.getLocalPart().equals("list")) && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            for (j = 0; j < children.getLength() && simpleNode == null; ++j) {
                QName simpleKind = Utils.getNodeQName(children.item(j));
                if (simpleKind == null || !simpleKind.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(simpleKind.getNamespaceURI())) continue;
                node = simpleNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            QName baseType;
            children = node.getChildNodes();
            Node restrictionNode = null;
            for (j = 0; j < children.getLength() && restrictionNode == null; ++j) {
                QName restrictionKind = Utils.getNodeQName(children.item(j));
                if (restrictionKind == null || !restrictionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) continue;
                restrictionNode = children.item(j);
            }
            Type baseEType = null;
            if (restrictionNode != null && (baseEType = symbolTable.getType(baseType = Utils.getTypeQName(restrictionNode, new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv()))) != null && !SchemaUtils.emitEnumForBase(baseType)) {
                baseEType = null;
            }
            if (baseEType != null && restrictionNode != null) {
                Vector<ChildEnumValueEntry> v = null;
                NodeList enums = restrictionNode.getChildNodes();
                for (int i = 0; i < enums.getLength(); ++i) {
                    Node enumNode;
                    String value2;
                    QName enumKind = Utils.getNodeQName(enums.item(i));
                    if (enumKind == null || !enumKind.getLocalPart().equals("enumeration") || !Constants.isSchemaXSD(enumKind.getNamespaceURI()) || (value2 = Utils.getAttribute(enumNode = enums.item(i), "value")) == null) continue;
                    if (v == null) {
                        v = new Vector<ChildEnumValueEntry>();
                    }
                    v.add(new ChildEnumValueEntry(baseEType, value2, symbolTable));
                }
                return v;
            }
        }
        return null;
    }

    static boolean isNotMappable(Node node, SymbolTable symbolTable, List nodeStack) {
        String maxOccursValue;
        if (SchemaUtils.getArrayComponentQName_JAXRPC(node, new IntHolder(), nodeStack, symbolTable) != null) {
            return false;
        }
        if (SchemaUtils.getEnumerationBaseAndValuesToEmit(node, symbolTable, nodeStack) != null) {
            return false;
        }
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            NodeList children = node.getChildNodes();
            Node complexNode = null;
            for (int j = 0; j < children.getLength() && complexNode == null; ++j) {
                QName complexKind = Utils.getNodeQName(children.item(j));
                if (complexKind == null || !complexKind.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(complexKind.getNamespaceURI())) continue;
                node = complexNode = children.item(j);
            }
        }
        if ((nodeKind = Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("complexType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            QName extensionKind;
            int j;
            maxOccursValue = Utils.getAttribute(node, "maxOccurs");
            if (maxOccursValue != null && !maxOccursValue.equals("1")) {
                return true;
            }
            String mixedValue = Utils.getAttribute(node, "mixed");
            if (mixedValue != null && !mixedValue.equals("false")) {
                return true;
            }
            NodeList children = node.getChildNodes();
            Node complexContent = null;
            Node simpleContent = null;
            Node extension = null;
            for (j = 0; j < children.getLength() && complexContent == null && simpleContent == null; ++j) {
                QName complexContentKind = Utils.getNodeQName(children.item(j));
                if (complexContentKind == null || !Constants.isSchemaXSD(complexContentKind.getNamespaceURI())) continue;
                if (complexContentKind.getLocalPart().equals("complexContent")) {
                    complexContent = children.item(j);
                    continue;
                }
                if (!complexContentKind.getLocalPart().equals("simpleContent")) continue;
                simpleContent = children.item(j);
            }
            if (complexContent != null) {
                children = complexContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j);
                    }
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI())) continue;
                    return true;
                }
            } else if (simpleContent != null) {
                children = simpleContent.getChildNodes();
                for (j = 0; j < children.getLength() && extension == null; ++j) {
                    extensionKind = Utils.getNodeQName(children.item(j));
                    if (extensionKind != null && extensionKind.getLocalPart().equals("extension") && Constants.isSchemaXSD(extensionKind.getNamespaceURI())) {
                        extension = children.item(j);
                    }
                    if (extensionKind == null || !extensionKind.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(extensionKind.getNamespaceURI())) continue;
                    return false;
                }
            }
            if (extension != null) {
                QName attrQName = Utils.getTypeQName(extension, new BooleanHolder(), false, nodeStack, symbolTable.getToolEnv());
                if (attrQName != null && Constants.equals(attrQName, Constants.XSD_ANYTYPE)) {
                    return true;
                }
                node = extension;
            }
            children = node.getChildNodes();
            return SchemaUtils.childrenNotMappable(children);
        }
        if (nodeKind != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            maxOccursValue = Utils.getAttribute(node, "maxOccurs");
            if (maxOccursValue != null && !maxOccursValue.equals("1")) {
                return true;
            }
            NodeList children = node.getChildNodes();
            Node restriction = null;
            Node list = null;
            for (int j = 0; j < children.getLength() && restriction == null && list == null; ++j) {
                QName restrictionKind = Utils.getNodeQName(children.item(j));
                if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                    restriction = children.item(j);
                    continue;
                }
                if (restrictionKind == null || !restrictionKind.getLocalPart().equals("list") || !Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) continue;
                list = children.item(j);
            }
            return restriction == null && list == null;
        }
        return false;
    }

    private static boolean childrenNotMappable(NodeList children) {
        boolean nested = false;
        String maxOccursValue = null;
        for (int j = 0; j < children.getLength(); ++j) {
            QName subNodeKind = Utils.getNodeQName(children.item(j));
            if (subNodeKind == null || !Constants.isSchemaXSD(subNodeKind.getNamespaceURI())) continue;
            if (subNodeKind.getLocalPart().equals("sequence")) {
                if (nested) {
                    return true;
                }
                nested = true;
                maxOccursValue = Utils.getAttribute(children.item(j), "maxOccurs");
                if (maxOccursValue != null && !maxOccursValue.equals("1")) {
                    return true;
                }
                if (!SchemaUtils.childrenNotMappable(children.item(j).getChildNodes())) continue;
                return true;
            }
            if (subNodeKind.getLocalPart().equals("all")) {
                if (nested) {
                    return true;
                }
                nested = true;
                maxOccursValue = Utils.getAttribute(children.item(j), "maxOccurs");
                if (maxOccursValue != null && !maxOccursValue.equals("1")) {
                    return true;
                }
                if (!SchemaUtils.childrenNotMappable(children.item(j).getChildNodes())) continue;
                return true;
            }
            if (subNodeKind.getLocalPart().equals("choice")) {
                return true;
            }
            if (subNodeKind.getLocalPart().equals("group")) {
                boolean isAnonGroup;
                if (Utils.getAttribute(children.item(j), "ref") != null) {
                    // empty if block
                }
                if (!(isAnonGroup = true)) continue;
                return true;
            }
            if (subNodeKind.getLocalPart().equals("attributeGroup")) {
                boolean isAnonAttributeGroup;
                boolean bl = isAnonAttributeGroup = Utils.getAttribute(children.item(j), "ref") == null;
                if (!isAnonAttributeGroup) continue;
                return true;
            }
            if (!subNodeKind.getLocalPart().equals("anyAttribute")) continue;
            return true;
        }
        return false;
    }

    private static boolean isXSDType(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < schemaTypes.length; ++i) {
            if (!schemaTypes[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    static boolean isXSDType(QName qname) {
        if (qname == null || !Constants.isSchemaXSD(qname.getNamespaceURI())) {
            return false;
        }
        return SchemaUtils.isXSDType(qname.getLocalPart());
    }

    static boolean supportEnumForBase(QName base) {
        if (SchemaUtils.isXSDType(base)) {
            for (int i = 0; i < supportEnum.length; ++i) {
                if (!supportEnum[i].equals(base.getLocalPart())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean emitEnumForBase(QName base) {
        if (SchemaUtils.isXSDType(base)) {
            for (int i = 0; i < emitEnum.length; ++i) {
                if (!emitEnum[i].equals(base.getLocalPart())) continue;
                return true;
            }
        }
        return false;
    }
}

