/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.query;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class WsdlImportResolver
implements ImportResolver {
    protected static Log log = LogFactory.getLog(WsdlImportResolver.class.getName());
    private LoadStrategy loadStrategy = null;

    public WsdlImportResolver(LoadStrategy ls) {
        this.loadStrategy = ls;
    }

    public InputStream resolve(String fileName) {
        InputStream wsdlInputStream;
        block14: {
            File wFile = null;
            wsdlInputStream = null;
            String path = null;
            if (log.isDebugEnabled()) {
                try {
                    log.debug("WsdlImportResolver: entry.  fileName = " + fileName);
                    log.debug("WsdlImportResolver: loadStrategy = " + this.loadStrategy.getResourcesPath());
                }
                catch (FileNotFoundException e) {
                    log.debug("WsdlImportResolver: entry.  caught exception. ", e);
                }
            }
            if (this.loadStrategy != null) {
                try {
                    String prePath;
                    Archive ejFile;
                    block13: {
                        ejFile = (Archive)this.loadStrategy.getContainer();
                        prePath = ejFile.isWARFile() ? "WEB-INF" : "META-INF";
                        path = prePath + '/' + "wsdl" + '/' + fileName;
                        if (log.isDebugEnabled()) {
                            log.debug("WsdlImportResolver: path = " + path);
                        }
                        try {
                            wFile = ejFile.getFile(path);
                            if (wFile != null) {
                                wsdlInputStream = wFile.getInputStream();
                            }
                        }
                        catch (FileNotFoundException f) {
                            if (!log.isDebugEnabled()) break block13;
                            log.debug("WsdlImportResolver: caught exception", f);
                        }
                    }
                    if (wsdlInputStream != null) break block14;
                    String directoryURIString = prePath + '/' + "wsdl";
                    List files = ejFile.filterFilesByPrefix(directoryURIString);
                    for (int i = 0; i < files.size(); ++i) {
                        String aName = ((File)files.get(i)).getName();
                        if (!fileName.equals(aName)) continue;
                        wsdlInputStream = ((File)files.get(i)).getInputStream();
                        break;
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("WsdlImportResolver: caught exception = " + e, e);
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.query.WsdlImportResolver.resolve", "76", this);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("WsdlImportResolver: exit.  wsdlInputStream = " + wsdlInputStream);
        }
        return wsdlInputStream;
    }
}

