/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.introspect;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.introspect.TypeEntryIntrospector;
import com.ibm.ws.webservices.wsdl.mapping.Utils;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.holders.BooleanHolder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public class BindingEntryIntrospector {
    private Emitter emitter;
    private ClassFactory classFactory;
    private SymbolTable symbolTable;

    BindingEntryIntrospector(Emitter emitter) {
        this.emitter = emitter;
        this.classFactory = emitter.getToolEnv().getClassFactory();
        this.symbolTable = emitter.getSymbolTable();
    }

    void introspect1(BindingEntry bEntry) {
        JavaClass sei = this.findSEI(bEntry);
        if (sei == null) {
            return;
        }
    }

    void introspect2(BindingEntry bEntry) {
        JavaClass sei = this.findSEI(bEntry);
        if (sei == null) {
            return;
        }
        if (this.emitter.isDebug()) {
            this.symbolTable.getToolEnv().report(Messages.getMessage("introspectSEI00", bEntry.getQName().toString(), sei.infoString()));
        }
        Iterator it = bEntry.getOperations();
        while (it.hasNext()) {
            BindingOperationEntry boEntry = (BindingOperationEntry)it.next();
            Method method = this.findMethod(sei, boEntry);
            if (method == null) continue;
            this.processParameters(method, boEntry, false);
        }
    }

    JavaClass findSEI(BindingEntry bEntry) {
        PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(bEntry.getBinding().getPortType().getQName());
        String seiName = (String)bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        JavaClass sei = (JavaClass)this.classFactory.forName(seiName);
        if (sei == null) {
            sei = (JavaClass)TypeEntryIntrospector.locateClass(ptEntry, this.emitter, this.classFactory);
        }
        if (sei != null) {
            bEntry.setDynamicVar(JavaGeneratorFactory.INTERFACE_NAME, sei.getJavaName());
        }
        return sei;
    }

    Method findMethod(JavaClass sei, BindingOperationEntry boEntry) {
        Method method;
        int i;
        Method foundMethod = null;
        List methodList1 = sei.getPublicMethodsExtendedNamed(boEntry.getName());
        List methodList2 = null;
        if (methodList1 != null) {
            for (i = 0; i < methodList1.size() && foundMethod == null; ++i) {
                method = (Method)methodList1.get(i);
                if (!this.processParameters(method, boEntry, true)) continue;
                foundMethod = method;
            }
        }
        if (foundMethod == null && !boEntry.getName().equals(boEntry.getQName().getLocalPart()) && (methodList2 = sei.getPublicMethodsExtendedNamed(boEntry.getQName().getLocalPart())) != null) {
            for (i = 0; i < methodList2.size() && foundMethod == null; ++i) {
                method = (Method)methodList2.get(i);
                if (!this.processParameters(method, boEntry, true)) continue;
                foundMethod = method;
            }
        }
        if (foundMethod == null) {
            int count2;
            int count1 = methodList1 == null ? 0 : methodList1.size();
            int n = count2 = methodList2 == null ? 0 : methodList2.size();
            if (count1 + count2 == 1) {
                Method method2 = foundMethod = count1 == 0 ? (Method)methodList2.get(0) : (Method)methodList1.get(0);
            }
        }
        if (foundMethod != null && !foundMethod.getName().equals(boEntry.getName())) {
            Utils.setJavaName(this.symbolTable, boEntry, foundMethod.getName(), false);
        }
        return foundMethod;
    }

    private boolean processParameters(Method method, BindingOperationEntry boe, boolean queryOnly) {
        boolean rc = true;
        EList javaParams = method.getParameters();
        if (javaParams == null || boe.numParameters() != javaParams.size()) {
            return false;
        }
        JavaHelpers javaType = method.getReturnType();
        BindingParamEntry bpEntry = boe.getReturn();
        TypeEntry tEntry = null;
        if (bpEntry != null) {
            tEntry = bpEntry.getType();
            while (!(tEntry instanceof Type) && !tEntry.isCollectionTypeEntry()) {
                tEntry = tEntry.getRefType();
            }
        }
        String pTypeName = null;
        if (bpEntry != null && (pTypeName = (String)bpEntry.getDynamicVar("parameterType")) == null) {
            pTypeName = JavaGeneratorFactory.defaultParamType(bpEntry);
            if (!queryOnly) {
                bpEntry.setDynamicVar("parameterType", pTypeName);
            }
        }
        BooleanHolder primitiveWrapperSubstitutionOccurred = new BooleanHolder();
        if (javaType != null && bpEntry != null) {
            String newJavaName = TypeEntryIntrospector.compatibleTypeTest(javaType, pTypeName, tEntry, this.emitter.getFactory().getBaseTypeMapping().getTypeMapping(), this.classFactory, this.symbolTable, this.emitter, queryOnly, true, primitiveWrapperSubstitutionOccurred);
            if (!queryOnly) {
                if (newJavaName == null) {
                    this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("incompatibleTypes00", method.getMethodElementSignature(), javaType.getJavaName(), pTypeName));
                } else if (!newJavaName.equals(pTypeName)) {
                    bpEntry.setDynamicVar("parameterType", newJavaName);
                    bpEntry.setDynamicVar("parameterSignatureType", javaType.getJavaName());
                    if (primitiveWrapperSubstitutionOccurred.value) {
                        this.emitter.getToolEnv().reportWarning(Messages.getMessage("incompatibleTypes00", method.getMethodElementSignature(), javaType.getJavaName(), pTypeName));
                    }
                }
            }
        }
        if (javaParams != null) {
            for (int i = 0; i < boe.numParameters(); ++i) {
                JavaParameter javaParam = (JavaParameter)javaParams.get(i);
                javaType = javaParam.getJavaType();
                JavaHelpers heldJavaType = com.ibm.ws.webservices.wsdl.fromJava.Utils.getHolderValueType(javaType, this.classFactory);
                if (heldJavaType != null) {
                    javaType = heldJavaType;
                }
                bpEntry = boe.getParameter(i);
                tEntry = null;
                if (bpEntry != null) {
                    tEntry = bpEntry.getType();
                    while (!(tEntry instanceof Type) && !tEntry.isCollectionTypeEntry()) {
                        tEntry = tEntry.getRefType();
                    }
                }
                if ((pTypeName = (String)bpEntry.getDynamicVar("parameterType")) == null) {
                    pTypeName = JavaGeneratorFactory.defaultParamType(bpEntry);
                    if (!queryOnly) {
                        bpEntry.setDynamicVar("parameterType", pTypeName);
                    }
                }
                primitiveWrapperSubstitutionOccurred.value = false;
                if (javaType != null) {
                    String newJavaName = TypeEntryIntrospector.compatibleTypeTest(javaType, pTypeName, tEntry, this.emitter.getFactory().getBaseTypeMapping().getTypeMapping(), this.classFactory, this.symbolTable, this.emitter, queryOnly, true, primitiveWrapperSubstitutionOccurred);
                    if (newJavaName == null) {
                        rc = false;
                    }
                    if (queryOnly) continue;
                    if (newJavaName == null) {
                        this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("incompatibleTypes01", method.getMethodElementSignature(), javaType.getJavaName(), pTypeName));
                        continue;
                    }
                    if (!newJavaName.equals(pTypeName)) {
                        bpEntry.setDynamicVar("parameterType", newJavaName);
                        if (heldJavaType == null) {
                            bpEntry.setDynamicVar("parameterSignatureType", newJavaName);
                        }
                    }
                    if (heldJavaType != null) {
                        String holderName = javaParam.getJavaType().getJavaName();
                        bpEntry.setDynamicVar("parameterSignatureType", holderName);
                        tEntry.setDynamicVar("HolderName", holderName);
                    }
                    if (!primitiveWrapperSubstitutionOccurred.value) continue;
                    this.emitter.getToolEnv().reportWarning(Messages.getMessage("incompatibleTypes01", method.getMethodElementSignature(), javaType.getJavaName(), pTypeName));
                    continue;
                }
                rc = false;
            }
        }
        return rc;
    }
}

