/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava.description;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor;
import com.ibm.ws.webservices.wsdl.fromJava.Emitter;
import com.ibm.ws.webservices.wsdl.fromJava.Utils;
import com.ibm.ws.webservices.wsdl.fromJava.description.FaultDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.OperationDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.ParameterDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;

public class PortDesc {
    protected static Log log = LogFactory.getLog(PortDesc.class.getName());
    private String name = null;
    private JavaClass implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = null;
    private String wsdlFileName = null;
    private String endpointURL = null;
    private HashMap properties = null;
    private ArrayList stopClasses = null;
    private ArrayList methodNames = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = null;
    private boolean introspectionComplete = false;
    private Emitter emitter = null;
    private int paramMangle = 0;
    private HashMap paramList2Method = new HashMap();
    private HashMap method2ParamList = new HashMap();
    private boolean uniqueParamNames = false;

    public PortDesc(Emitter emitter) {
        this.emitter = emitter;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String wsdlFileName) {
        this.wsdlFileName = wsdlFileName;
    }

    public JavaClass getImplClass() {
        return this.implClass;
    }

    public void setImplClass(JavaClass implClass) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = implClass;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping tm) {
        this.tm = tm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList stopClasses) {
        this.stopClasses = stopClasses;
    }

    public ArrayList getMethods() {
        return this.methodNames;
    }

    public void setMethods(ArrayList methods) {
        this.methodNames = methods;
    }

    public void addOperationDesc(OperationDesc operation) {
        String name2;
        ArrayList<OperationDesc> overloads;
        this.operations.add(operation);
        operation.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((overloads = (ArrayList<OperationDesc>)this.name2OperationsMap.get(name2 = operation.getName())) == null) {
            overloads = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(name2, overloads);
        }
        overloads.add(operation);
    }

    public ArrayList getOperations() {
        this.loadPortDescByIntrospection();
        return this.operations;
    }

    public OperationDesc[] getOperationsByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    public OperationDesc getOperationByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        return (OperationDesc)overloads.get(0);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadPortDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            Iterator i = this.operations.iterator();
            while (i.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)i.next();
                ArrayList<OperationDesc> list = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(operationDesc.getElementQName());
                if (list == null) {
                    list = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(operationDesc.getElementQName(), list);
                }
                list.add(operationDesc);
            }
        }
    }

    private void syncOperationToClass(OperationDesc oper, JavaClass implClass) {
        if (oper.getMethod() != null) {
            return;
        }
        EList methods = implClass.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            EList paramTypes;
            Method method = (Method)methods.get(i);
            if (!method.getName().equals(oper.getName()) || method.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL || method.isStatic() || (paramTypes = method.getParameters()).size() != oper.getNumParams()) continue;
            for (int j = 0; j < paramTypes.size(); ++j) {
                ParameterDesc param;
                QName typeQName;
                JavaParameter parameter2 = (JavaParameter)paramTypes.get(j);
                JavaHelpers type = parameter2.getJavaType();
                JavaHelpers heldType = Utils.getHolderValueType(type, this.emitter.getToolEnv().getClassFactory());
                if (heldType == null) {
                    heldType = type;
                }
                if ((typeQName = (param = oper.getParameter(j)).getTypeQName()) == null) {
                    typeQName = Utils.getTypeQName(heldType, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory());
                    param.setTypeQName(typeQName);
                }
                param.setJavaType(type, this.emitter);
            }
            JavaHelpers returnClass = method.getReturnType();
            if (returnClass.getJavaName().equals("void")) {
                oper.setReturnClass(returnClass, this.emitter);
            }
            this.createFaultMetadata(method, oper);
            oper.setMethod(method);
            this.method2OperationMap.put(method, oper);
            return;
        }
        JavaClass superClass = implClass.getSupertype();
        if (!(superClass == null || superClass.getJavaName().startsWith("java.") || superClass.getJavaName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getJavaName()))) {
            this.syncOperationToClass(oper, superClass);
        }
        if (oper.getMethod() == null) {
            InternalException ie = new InternalException(Messages.getMessage("serviceDescOperSync00", oper.getName(), implClass.getJavaName()));
            throw ie;
        }
    }

    public void loadPortDescByIntrospection() {
        this.loadPortDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    public void loadPortDescByIntrospection(JavaClass implClass) {
        if (this.introspectionComplete || implClass == null) {
            return;
        }
        this.implClass = implClass;
        this.loadPortDescByIntrospectionRecursive(implClass);
        Iterator iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            OperationDesc operation = (OperationDesc)iterator.next();
            if (operation.getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", operation.getName(), "" + operation.getNumParams()));
        }
        this.introspectionComplete = true;
    }

    private void loadPortDescByIntrospectionRecursive(JavaClass implClass) {
        EList methods = implClass.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            Method method = (Method)methods.get(i);
            if (this.methodNames != null && !this.methodNames.contains(method.getName()) || method.getName().equals(implClass.getName()) || method.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL || method.isStatic()) continue;
            this.getSyncedOperationsForName(implClass, method.getName());
        }
        if (implClass.isInterface()) {
            EList superClasses = implClass.getImplementsInterfaces();
            for (int i = 0; i < superClasses.size(); ++i) {
                JavaClass superClass = (JavaClass)superClasses.get(i);
                if (this.stopClasses != null && this.stopClasses.contains(superClass.getJavaName())) continue;
                this.loadPortDescByIntrospectionRecursive(superClass);
            }
        } else {
            JavaClass superClass = implClass.getSupertype();
            if (!(superClass == null || superClass.getJavaName().startsWith("java.") || superClass.getJavaName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getJavaName()))) {
                this.loadPortDescByIntrospectionRecursive(superClass);
            }
        }
    }

    public void loadPortDescByIntrospection(JavaClass cls, TypeMapping tm) {
        this.implClass = cls;
        this.tm = tm;
        this.loadPortDescByIntrospection();
    }

    private void getSyncedOperationsForName(JavaClass implClass, String methodName) {
        ArrayList currentOverloads;
        if (implClass == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(methodName)) {
            return;
        }
        if (this.name2OperationsMap != null && (currentOverloads = (ArrayList)this.name2OperationsMap.get(methodName)) != null) {
            Iterator i = currentOverloads.iterator();
            while (i.hasNext()) {
                OperationDesc oper = (OperationDesc)i.next();
                if (oper.getMethod() != null) continue;
                this.syncOperationToClass(oper, implClass);
            }
        }
        this.createOperationsForName(implClass, methodName);
        this.completedNames.add(methodName);
    }

    private void createOperationsForName(JavaClass implClass, String methodName) {
        EList methods = implClass.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            Method method = (Method)methods.get(i);
            if (!method.getName().equals(methodName) || method.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL || method.isStatic()) continue;
            this.createOperationForMethod(method);
        }
        JavaClass superClass = implClass.getSupertype();
        if (superClass != null && !superClass.getJavaName().startsWith("java.") && !superClass.getJavaName().startsWith("javax.")) {
            this.createOperationsForName(superClass, methodName);
        }
    }

    private void createOperationForMethod(Method method) {
        ArrayList overloads;
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        EList paramTypes = method.getParameters();
        ArrayList arrayList = overloads = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (overloads != null && !overloads.isEmpty()) {
            for (int i = 0; i < overloads.size(); ++i) {
                OperationDesc op = (OperationDesc)overloads.get(i);
                Method checkMethod = op.getMethod();
                if (checkMethod == null) continue;
                EList others = checkMethod.getParameters();
                if (paramTypes.size() != others.size()) continue;
                boolean match = true;
                for (int j = 0; j < others.size(); ++j) {
                    if (others.get(j).equals(paramTypes.get(j))) continue;
                    match = false;
                }
                if (!match) continue;
                return;
            }
        }
        OperationDesc operation = new OperationDesc();
        String defaultNS = "";
        if (this.namespaceMappings != null && !this.namespaceMappings.isEmpty()) {
            defaultNS = (String)this.namespaceMappings.get(0);
        }
        operation.setElementQName(QNameTable.createQName(defaultNS, JavaUtils.java2NCName(method.getName())));
        operation.setMethod(method);
        JavaHelpers retClass = method.getReturnType();
        operation.setReturnClass(retClass, this.emitter);
        List paramNames = this.getParamNames(method);
        for (int k = 0; k < paramTypes.size(); ++k) {
            JavaParameter parameter2 = (JavaParameter)paramTypes.get(k);
            JavaHelpers type = parameter2.getJavaType();
            ParameterDesc paramDesc = new ParameterDesc();
            paramDesc.setName(JavaUtils.java2NCName((String)paramNames.get(k)));
            JavaHelpers heldClass = Utils.getHolderValueType(type, this.emitter.getToolEnv().getClassFactory());
            if (heldClass != null) {
                paramDesc.setMode((byte)3);
                paramDesc.setTypeQName(Utils.getTypeQName(heldClass, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory()));
            } else {
                paramDesc.setMode((byte)1);
                paramDesc.setTypeQName(Utils.getTypeQName(type, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory()));
            }
            paramDesc.setJavaType(type, this.emitter);
            operation.addParameter(paramDesc);
        }
        this.createFaultMetadata(method, operation);
        this.addOperationDesc(operation);
        this.method2OperationMap.put(method, operation);
    }

    private void createFaultMetadata(Method method, OperationDesc operation) {
        EList exceptionTypes = method.getJavaExceptions();
        for (int i = 0; i < exceptionTypes.size(); ++i) {
            JavaClass ex = (JavaClass)exceptionTypes.get(i);
            if (ex.getJavaName().equals("java.rmi.RemoteException") || ex.getJavaName().equals("com.ibm.ws.webservices.engine.WebServicesFault") || ex.getJavaName().startsWith("java.") || ex.getJavaName().startsWith("javax.")) continue;
            FaultDesc fault2 = operation.getFaultByClass(ex);
            if (fault2 == null) {
                fault2 = new FaultDesc();
            }
            fault2.setJavaClass(ex);
            operation.addFault(fault2);
        }
    }

    private List getParamNames(Method method) {
        Method existingMethod;
        if (this.method2ParamList.get(method) != null) {
            return (List)this.method2ParamList.get(method);
        }
        ArrayList<String> list = new ArrayList<String>();
        EList params = method.getParameters();
        if (this.emitter.getToolEnv().isJavaIntrospectionAllowed()) {
            int i;
            java.lang.reflect.Method iMethod = null;
            Class cls = null;
            java.lang.reflect.Method[] iMethods = null;
            try {
                cls = ClassUtils.forName(this.implClass.getJavaName(), false, this.emitter.getToolEnv().getClassLoader());
                iMethods = cls.getDeclaredMethods();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (iMethods != null) {
                boolean duplicate = false;
                for (i = 0; i < iMethods.length; ++i) {
                    if (!iMethods[i].getName().equals(method.getName())) continue;
                    duplicate = iMethod != null;
                    iMethod = iMethods[i];
                }
                if (duplicate) {
                    iMethod = null;
                }
            }
            if (iMethod != null) {
                try {
                    String[] paramNames = ParamNameExtractor.getParameterNamesFromDebugInfo(iMethod);
                    if (paramNames != null) {
                        for (i = 0; i < paramNames.length; ++i) {
                            list.add(paramNames[i]);
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (list.size() == 0) {
            for (int i = 0; i < params.size(); ++i) {
                list.add(((JavaParameter)params.get(i)).getName());
            }
        }
        if (list.size() > 0) {
            boolean useless = true;
            for (int i = 0; i < params.size() && useless; ++i) {
                if (list.get(i).equals("arg" + i)) continue;
                useless = false;
            }
            if (useless) {
                list.clear();
            }
        }
        if (this.uniqueParamNames && list.size() > 0 && this.paramList2Method.get(list) != null) {
            list.clear();
        }
        if (list.size() == 0) {
            for (int i = 0; i < params.size(); ++i) {
                list.add("arg_" + i + "_" + this.paramMangle);
            }
            ++this.paramMangle;
        }
        if (this.uniqueParamNames && (existingMethod = (Method)this.paramList2Method.get(list)) != null) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("matchingDocLitParams01", existingMethod.getName(), method.getName()));
        }
        this.method2ParamList.put(method, list);
        this.paramList2Method.put(list, method);
        return list;
    }

    public void setNamespaceMappings(List namespaces) {
        this.namespaceMappings = namespaces;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings == null || this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String namespace) {
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList();
        }
        this.namespaceMappings.add(0, namespace);
    }

    public void setProperty(String name2, Object value2) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name2, value2);
    }

    public Object getProperty(String name2) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name2);
    }

    public void setUniqueParamNames(boolean value2) {
        this.uniqueParamNames = value2;
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String indent) {
        String text = "";
        text = text + indent + "name:        " + this.getName() + "\n";
        text = text + indent + "implClass:   " + this.getImplClass() + "\n";
        text = text + indent + "defaultNS:   " + this.getDefaultNamespace() + "\n";
        text = text + indent + "endpointURL: " + this.getEndpointURL() + "\n";
        if (this.operations != null) {
            for (int i = 0; i < this.operations.size(); ++i) {
                text = text + indent + " OperationDesc[" + i + "]:\n";
                text = text + indent + ((OperationDesc)this.operations.get(i)).toString("  ") + "\n";
            }
        }
        return text;
    }
}

